/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.ResourceSet;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.ResourceSetWithId;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.ResourceSetService;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.util.ServerUtil;

@Name(value="resourceSetRegistrationRestWebService")
@Path(value="/host/rsrc/resource_set")
@Api(value="/host/rsrc/resource_set", description="The resource server uses the RESTful API at the authorization server's resource set registration endpoint to create, read, update, and delete resource set descriptions, along with retrieving lists of such descriptions.")
public class ResourceSetRegistrationWS {
    @Logger
    private Log log;
    @In
    private TokenService tokenService;
    @In
    private UmaValidationService umaValidationService;
    @In
    private ResourceSetService resourceSetService;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ScopeService umaScopeService;

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Adds a new resource set description using the POST method", notes="Adds a new resource set description using the POST method. If the request is successful, the authorization server MUST respond with a status message that includes an _id property.")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public Response createResourceSet(@HeaderParam(value="Authorization") String authorization, @ApiParam(value="Resource set description", required=true) ResourceSet resourceSet) {
        try {
            String id = this.generatedId();
            this.log.trace((Object)"Try to create resource set, id: {0}", new Object[]{id});
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            return this.putResourceSetImpl(Response.Status.CREATED, authorization, id, resourceSet);
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception during resource creation", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    @PUT
    @Path(value="{rsid}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates a previously registered resource set description using the PUT method", notes="Updates a previously registered resource set description using the PUT method. If the request is successful, the authorization server MUST respond with a status message that includes an \"_id\" property.")
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public Response updateResourceSet(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") @ApiParam(value="Resource set description ID", required=true) String rsid, @ApiParam(value="Resource set description JSON object", required=true) ResourceSet resourceSet) {
        try {
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            return this.putResourceSetImpl(Response.Status.NO_CONTENT, authorization, rsid, resourceSet);
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private synchronized String generatedId() {
        return String.valueOf(System.currentTimeMillis());
    }

    @GET
    @Path(value="{rsid}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Reads a previously registered resource set description using the GET method.", notes="Reads a previously registered resource set description using the GET method. If the request is successful, the authorization server MUST respond with a status message that includes a body containing the referenced resource set description, along with an \"_id\" property.", response=ResourceSet.class)
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public Response getResourceSet(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") @ApiParam(value="Resource set description object ID", required=true) String rsid) {
        try {
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            this.log.debug((Object)"Getting resource set description: '{0}'", new Object[]{rsid});
            this.prepareResourceSetsBranch();
            org.xdi.oxauth.model.uma.persistence.ResourceSet ldapResourceSet = new org.xdi.oxauth.model.uma.persistence.ResourceSet();
            ldapResourceSet.setDn(this.resourceSetService.getBaseDnForResourceSet());
            ldapResourceSet.setId(rsid);
            List<org.xdi.oxauth.model.uma.persistence.ResourceSet> ldapResourceSets = this.resourceSetService.findResourceSets(ldapResourceSet);
            if (ldapResourceSets.size() != 1) {
                this.log.error((Object)"Specified resource set description isn't exist", new Object[0]);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
            }
            ldapResourceSet = ldapResourceSets.get(0);
            ResourceSetWithId resourceSetWithId = new ResourceSetWithId();
            BeanUtils.copyProperties((Object)resourceSetWithId, (Object)ldapResourceSet);
            resourceSetWithId.setId(ldapResourceSet.getId());
            resourceSetWithId.setScopes(this.umaScopeService.getScopeUrlsByDns(ldapResourceSet.getScopes()));
            Response.ResponseBuilder builder = Response.ok();
            builder.entity((Object)ServerUtil.asJson(resourceSetWithId));
            return builder.build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists all previously registered resource set identifiers for this user using the GET method.", notes="Lists all previously registered resource set identifiers for this user using the GET method. The authorization server MUST return the list in the form of a JSON array of {rsid} string values.\n\nThe resource server uses this method as a first step in checking whether its understanding of protected resources is in full synchronization with the authorization server's understanding.", response=ResourceSet.class)
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public List<String> getResourceSetList(@HeaderParam(value="Authorization") String authorization, @QueryParam(value="scope") @ApiParam(value="Scope uri", required=false) String p_scope) {
        block5: {
            try {
                this.log.trace((Object)"Getting resource set descriptions.", new Object[0]);
                this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
                String patToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(patToken);
                if (authorizationGrant != null) {
                    String clientDn = authorizationGrant.getClientDn();
                    this.prepareResourceSetsBranch();
                    List<org.xdi.oxauth.model.uma.persistence.ResourceSet> ldapResourceSets = this.resourceSetService.getResourceSetsByAssociatedClient(clientDn);
                    ArrayList<String> result = new ArrayList<String>(ldapResourceSets.size());
                    for (org.xdi.oxauth.model.uma.persistence.ResourceSet ldapResourceSet : ldapResourceSets) {
                        if (StringUtils.isNotBlank((String)p_scope)) {
                            List<String> scopeUrlsByDns = this.umaScopeService.getScopeUrlsByDns(ldapResourceSet.getScopes());
                            if (scopeUrlsByDns == null || !scopeUrlsByDns.contains(p_scope)) continue;
                            result.add(ldapResourceSet.getId());
                            continue;
                        }
                        result.add(ldapResourceSet.getId());
                    }
                    return result;
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Exception happened on getResourceSetList()", (Throwable)ex, new Object[0]);
                if (!(ex instanceof WebApplicationException)) break block5;
                throw (WebApplicationException)((Object)ex);
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
    }

    @DELETE
    @Path(value="{rsid}")
    @ApiOperation(value="Deletes a previously registered resource set description using the DELETE method.", notes="Deletes a previously registered resource set description using the DELETE method, thereby removing it from the authorization server's protection regime.", response=ResourceSet.class)
    @ApiResponses(value={@ApiResponse(code=401, message="Unauthorized")})
    public Response deleteResourceSet(@HeaderParam(value="Authorization") String authorization, @PathParam(value="rsid") @ApiParam(value="Resource set description ID", required=true) String rsid) {
        try {
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            this.log.debug((Object)"Getting resource set descriptions'", new Object[0]);
            this.prepareResourceSetsBranch();
            org.xdi.oxauth.model.uma.persistence.ResourceSet ldapResourceSet = new org.xdi.oxauth.model.uma.persistence.ResourceSet();
            ldapResourceSet.setDn(this.resourceSetService.getBaseDnForResourceSet());
            ldapResourceSet.setId(rsid);
            List<org.xdi.oxauth.model.uma.persistence.ResourceSet> ldapResourceSets = this.resourceSetService.findResourceSets(ldapResourceSet);
            if (ldapResourceSets.isEmpty()) {
                this.log.error((Object)"Specified resource set description doesn't exist", new Object[0]);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
            }
            this.resourceSetService.remove(ldapResourceSets);
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private Response putResourceSetImpl(Response.Status status, String authorization, String rsid, ResourceSet resourceSet) throws IllegalAccessException, InvocationTargetException, IOException {
        this.log.trace((Object)"putResourceSetImpl, rsid: {0}, status:", new Object[]{rsid, status.name()});
        String patToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(patToken);
        String userDn = authorizationGrant.getUserDn();
        String clientInum = authorizationGrant.getClientId();
        String clientDn = authorizationGrant.getClientDn();
        String resourceSetDn = status == Response.Status.CREATED ? this.addResourceSet(rsid, resourceSet, userDn, clientInum, clientDn) : this.updateResourceSet(rsid, resourceSet, authorizationGrant, clientDn);
        org.xdi.oxauth.model.uma.persistence.ResourceSet ldapUpdatedResourceSet = this.resourceSetService.getResourceSetByDn(resourceSetDn);
        ResourceSetStatus resourceSetStatus = new ResourceSetStatus();
        BeanUtils.copyProperties((Object)resourceSetStatus, (Object)ldapUpdatedResourceSet);
        String entity = ServerUtil.asJson(resourceSetStatus);
        Response.ResponseBuilder builder = Response.status((Response.Status)status);
        builder.entity((Object)entity);
        return builder.build();
    }

    private String addResourceSet(String rsid, ResourceSet resourceSet, String userDn, String clientInum, String clientDn) throws IllegalAccessException, InvocationTargetException {
        this.log.debug((Object)"Adding new resource set description: '{0}'", new Object[]{rsid});
        this.prepareResourceSetsBranch();
        String resourceSetDn = this.resourceSetService.getDnForResourceSet(rsid);
        List<String> scopeDNs = this.umaScopeService.getScopeDNsByUrlsAndAddToLdapIfNeeded(resourceSet.getScopes());
        org.xdi.oxauth.model.uma.persistence.ResourceSet ldapResourceSet = new org.xdi.oxauth.model.uma.persistence.ResourceSet();
        BeanUtils.copyProperties((Object)ldapResourceSet, (Object)resourceSet);
        ldapResourceSet.setId(rsid);
        ldapResourceSet.setRev("1");
        ldapResourceSet.setCreator(userDn);
        ldapResourceSet.setDn(resourceSetDn);
        ldapResourceSet.setScopes(scopeDNs);
        Boolean addClient = ConfigurationFactory.getConfiguration().getUmaKeepClientDuringResourceSetRegistration();
        if (addClient == null || addClient.booleanValue()) {
            ldapResourceSet.setClients(new ArrayList<String>(Arrays.asList(clientDn)));
        }
        this.resourceSetService.addResourceSet(ldapResourceSet);
        return resourceSetDn;
    }

    private String updateResourceSet(String rsid, ResourceSet resourceSet, AuthorizationGrant authorizationGrant, String clientDn) throws IllegalAccessException, InvocationTargetException {
        this.log.debug((Object)"Updating resource set description: '{0}'.", new Object[]{rsid});
        this.prepareResourceSetsBranch();
        org.xdi.oxauth.model.uma.persistence.ResourceSet ldapResourceSet = new org.xdi.oxauth.model.uma.persistence.ResourceSet();
        ldapResourceSet.setDn(this.resourceSetService.getBaseDnForResourceSet());
        ldapResourceSet.setId(rsid);
        List<org.xdi.oxauth.model.uma.persistence.ResourceSet> ldapResourceSets = this.resourceSetService.findResourceSets(ldapResourceSet);
        if (ldapResourceSets.size() != 1) {
            this.log.error((Object)"Specified resource set description doesn't exist", new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
        }
        ldapResourceSet = ldapResourceSets.get(0);
        String resourceSetDn = ldapResourceSet.getDn();
        BeanUtils.copyProperties((Object)ldapResourceSet, (Object)resourceSet);
        List<String> scopeDNs = this.umaScopeService.getScopeDNsByUrlsAndAddToLdapIfNeeded(resourceSet.getScopes());
        ldapResourceSet.setScopes(scopeDNs);
        ldapResourceSet.setRev(String.valueOf(this.incrementRev(ldapResourceSet.getRev())));
        this.resourceSetService.updateResourceSet(ldapResourceSet);
        return resourceSetDn;
    }

    private int incrementRev(String rev) {
        try {
            return Integer.parseInt(rev) + 1;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return 1;
        }
    }

    private void prepareResourceSetsBranch() {
        if (!this.resourceSetService.containsBranch()) {
            this.resourceSetService.addBranch();
        }
    }

    @HEAD
    @ApiOperation(value="Not allowed")
    public Response unsupportedHeadMethod() {
        this.log.error((Object)"HEAD method is not allowed", new Object[0]);
        throw new WebApplicationException(Response.status((int)405).entity((Object)"HEAD Method Not Allowed").build());
    }

    @OPTIONS
    @ApiOperation(value="Not allowed")
    public Response unsupportedOptionsMethod() {
        this.log.error((Object)"OPTIONS method is not allowed", new Object[0]);
        throw new WebApplicationException(Response.status((int)405).entity((Object)"OPTIONS Method Not Allowed").build());
    }
}

