/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.session.ws.rs;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;
import org.xdi.oxauth.model.session.EndSessionParamsValidator;
import org.xdi.oxauth.service.RedirectionUriService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.external.ExternalApplicationSessionService;
import org.xdi.oxauth.session.ws.rs.EndSessionRestWebService;
import org.xdi.oxauth.util.RedirectUri;
import org.xdi.oxauth.util.RedirectUtil;
import org.xdi.util.StringHelper;

@Name(value="endSessionRestWebService")
public class EndSessionRestWebServiceImpl
implements EndSessionRestWebService {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RedirectionUriService redirectionUriService;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ExternalApplicationSessionService externalApplicationSessionService;
    @In
    private SessionIdService sessionIdService;

    @Override
    public Response requestEndSession(String idTokenHint, String postLogoutRedirectUri, String state, String sessionId, HttpServletRequest httpRequest, HttpServletResponse httpResponse, SecurityContext sec) {
        this.log.debug((Object)"Attempting to end session, idTokenHint: {0}, postLogoutRedirectUri: {1}, sessionId: {2}, Is Secure = {3}", new Object[]{idTokenHint, postLogoutRedirectUri, sessionId, sec.isSecure()});
        Response.ResponseBuilder builder = Response.ok();
        if (!EndSessionParamsValidator.validateParams(idTokenHint, postLogoutRedirectUri)) {
            builder = Response.status((int)400);
            builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST));
        } else {
            boolean isGrantAndExternalLogoutSuccessful;
            AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByIdToken(idTokenHint);
            boolean isExternalAuthenticatorLogoutPresent = false;
            boolean externalLogoutResult = false;
            if (authorizationGrant != null) {
                this.removeSessionId(sessionId, httpRequest, httpResponse);
                isExternalAuthenticatorLogoutPresent = this.externalApplicationSessionService.isEnabled();
                if (isExternalAuthenticatorLogoutPresent) {
                    externalLogoutResult = this.externalApplicationSessionService.executeExternalEndSessionMethods(httpRequest, authorizationGrant);
                    this.log.info((Object)"End session result for '{0}': '{1}'", new Object[]{authorizationGrant.getUser().getUserId(), "logout", externalLogoutResult});
                }
            }
            boolean isGrantAndNoExternalLogout = authorizationGrant != null && !isExternalAuthenticatorLogoutPresent;
            boolean bl = isGrantAndExternalLogoutSuccessful = authorizationGrant != null && isExternalAuthenticatorLogoutPresent && externalLogoutResult;
            if (isGrantAndNoExternalLogout || isGrantAndExternalLogoutSuccessful) {
                authorizationGrant.revokeAllTokens();
                String redirectUri = this.redirectionUriService.validatePostLogoutRedirectUri(authorizationGrant.getClient().getClientId(), postLogoutRedirectUri);
                if (StringUtils.isNotBlank((String)redirectUri)) {
                    RedirectUri redirectUriResponse = new RedirectUri(redirectUri);
                    if (StringUtils.isNotBlank((String)state)) {
                        redirectUriResponse.addResponseParameter("state", state);
                    }
                    builder = RedirectUtil.getRedirectResponseBuilder(redirectUriResponse.toString(), httpRequest);
                } else {
                    builder = Response.status((int)400);
                    builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_REQUEST));
                }
            } else {
                builder = Response.status((int)401);
                builder.entity((Object)this.errorResponseFactory.getErrorAsJson((IErrorType)EndSessionErrorResponseType.INVALID_GRANT));
            }
        }
        return builder.build();
    }

    private void removeSessionId(String sessionId, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String id = sessionId;
        if (StringHelper.isEmpty((String)id)) {
            id = this.sessionIdService.getSessionIdFromCookie(httpRequest);
        }
        if (StringHelper.isNotEmpty((String)id)) {
            SessionId ldapSessionId = this.sessionIdService.getSessionId(id);
            if (ldapSessionId != null) {
                boolean result = this.sessionIdService.remove(ldapSessionId);
                if (!result) {
                    this.log.error((Object)"Failed to remove session_id '{0}' from LDAP", new Object[]{id});
                }
            } else {
                this.log.error((Object)"Failed to load session from LDAP by session_id: '{0}'", new Object[]{id});
            }
        }
        this.sessionIdService.removeSessionIdCookie(httpResponse);
    }
}

