/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.model.GluuAttribute;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.external.ExternalAuthenticationService;

public class OpenIdConfiguration
extends HttpServlet {
    private static final Log LOG = Logging.getLog(OpenIdConfiguration.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("issuer", (Object)ConfigurationFactory.getConfiguration().getIssuer());
            jsonObj.put("authorization_endpoint", (Object)ConfigurationFactory.getConfiguration().getAuthorizationEndpoint());
            jsonObj.put("token_endpoint", (Object)ConfigurationFactory.getConfiguration().getTokenEndpoint());
            jsonObj.put("userinfo_endpoint", (Object)ConfigurationFactory.getConfiguration().getUserInfoEndpoint());
            jsonObj.put("clientinfo_endpoint", (Object)ConfigurationFactory.getConfiguration().getClientInfoEndpoint());
            jsonObj.put("check_session_iframe", (Object)ConfigurationFactory.getConfiguration().getCheckSessionIFrame());
            jsonObj.put("end_session_endpoint", (Object)ConfigurationFactory.getConfiguration().getEndSessionEndpoint());
            jsonObj.put("jwks_uri", (Object)ConfigurationFactory.getConfiguration().getJwksUri());
            jsonObj.put("registration_endpoint", (Object)ConfigurationFactory.getConfiguration().getRegistrationEndpoint());
            jsonObj.put("validate_token_endpoint", (Object)ConfigurationFactory.getConfiguration().getValidateTokenEndpoint());
            jsonObj.put("federation_metadata_endpoint", (Object)ConfigurationFactory.getConfiguration().getFederationMetadataEndpoint());
            jsonObj.put("federation_endpoint", (Object)ConfigurationFactory.getConfiguration().getFederationEndpoint());
            jsonObj.put("id_generation_endpoint", (Object)ConfigurationFactory.getConfiguration().getIdGenerationEndpoint());
            jsonObj.put("introspection_endpoint", (Object)ConfigurationFactory.getConfiguration().getIntrospectionEndpoint());
            ScopeService scopeService = ScopeService.instance();
            JSONArray scopesSupported = new JSONArray();
            for (Scope scope : scopeService.getAllScopesList()) {
                scopesSupported.put((Object)scope.getDisplayName());
            }
            if (scopesSupported.length() > 0) {
                jsonObj.put("scopes_supported", (Object)scopesSupported);
            }
            JSONArray responseTypesSupported = new JSONArray();
            for (String responseType : ConfigurationFactory.getConfiguration().getResponseTypesSupported()) {
                responseTypesSupported.put((Object)responseType);
            }
            if (responseTypesSupported.length() > 0) {
                jsonObj.put("response_types_supported", (Object)responseTypesSupported);
            }
            JSONArray grantTypesSupported = new JSONArray();
            for (String grantType : ConfigurationFactory.getConfiguration().getGrantTypesSupported()) {
                grantTypesSupported.put((Object)grantType);
            }
            if (grantTypesSupported.length() > 0) {
                jsonObj.put("grant_types_supported", (Object)grantTypesSupported);
            }
            JSONArray acrValuesSupported = new JSONArray();
            ExternalAuthenticationService externalAuthenticationService = ExternalAuthenticationService.instance();
            for (String acr : externalAuthenticationService.getAcrValuesList()) {
                acrValuesSupported.put((Object)acr);
            }
            jsonObj.put("acr_values_supported", (Object)acrValuesSupported);
            JSONArray subjectTypesSupported = new JSONArray();
            for (String subjectType : ConfigurationFactory.getConfiguration().getSubjectTypesSupported()) {
                subjectTypesSupported.put((Object)subjectType);
            }
            if (subjectTypesSupported.length() > 0) {
                jsonObj.put("subject_types_supported", (Object)subjectTypesSupported);
            }
            JSONArray userInfoSigningAlgValuesSupported = new JSONArray();
            for (String userInfoSigningAlg : ConfigurationFactory.getConfiguration().getUserInfoSigningAlgValuesSupported()) {
                userInfoSigningAlgValuesSupported.put((Object)userInfoSigningAlg);
            }
            if (userInfoSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("userinfo_signing_alg_values_supported", (Object)userInfoSigningAlgValuesSupported);
            }
            JSONArray userInfoEncryptionAlgValuesSupported = new JSONArray();
            for (String userInfoEncryptionAlg : ConfigurationFactory.getConfiguration().getUserInfoEncryptionAlgValuesSupported()) {
                userInfoEncryptionAlgValuesSupported.put((Object)userInfoEncryptionAlg);
            }
            if (userInfoEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("userinfo_encryption_alg_values_supported", (Object)userInfoEncryptionAlgValuesSupported);
            }
            JSONArray userInfoEncryptionEncValuesSupported = new JSONArray();
            for (String userInfoEncryptionEnc : ConfigurationFactory.getConfiguration().getUserInfoEncryptionEncValuesSupported()) {
                userInfoEncryptionEncValuesSupported.put((Object)userInfoEncryptionEnc);
            }
            if (userInfoEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("userinfo_encryption_enc_values_supported", (Object)userInfoEncryptionAlgValuesSupported);
            }
            JSONArray idTokenSigningAlgValuesSupported = new JSONArray();
            for (String idTokenSigningAlg : ConfigurationFactory.getConfiguration().getIdTokenSigningAlgValuesSupported()) {
                idTokenSigningAlgValuesSupported.put((Object)idTokenSigningAlg);
            }
            if (idTokenSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("id_token_signing_alg_values_supported", (Object)idTokenSigningAlgValuesSupported);
            }
            JSONArray idTokenEncryptionAlgValuesSupported = new JSONArray();
            for (String idTokenEncryptionAlg : ConfigurationFactory.getConfiguration().getIdTokenEncryptionAlgValuesSupported()) {
                idTokenEncryptionAlgValuesSupported.put((Object)idTokenEncryptionAlg);
            }
            if (idTokenEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("id_token_encryption_alg_values_supported", (Object)idTokenEncryptionAlgValuesSupported);
            }
            JSONArray idTokenEncryptionEncValuesSupported = new JSONArray();
            for (String idTokenEncryptionEnc : ConfigurationFactory.getConfiguration().getIdTokenEncryptionEncValuesSupported()) {
                idTokenEncryptionEncValuesSupported.put((Object)idTokenEncryptionEnc);
            }
            if (idTokenEncryptionEncValuesSupported.length() > 0) {
                jsonObj.put("id_token_encryption_enc_values_supported", (Object)idTokenEncryptionEncValuesSupported);
            }
            JSONArray requestObjectSigningAlgValuesSupported = new JSONArray();
            for (String requestObjectSigningAlg : ConfigurationFactory.getConfiguration().getRequestObjectSigningAlgValuesSupported()) {
                requestObjectSigningAlgValuesSupported.put((Object)requestObjectSigningAlg);
            }
            if (requestObjectSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("request_object_signing_alg_values_supported", (Object)requestObjectSigningAlgValuesSupported);
            }
            JSONArray requestObjectEncryptionAlgValuesSupported = new JSONArray();
            for (String requestObjectEncryptionAlg : ConfigurationFactory.getConfiguration().getRequestObjectEncryptionAlgValuesSupported()) {
                requestObjectEncryptionAlgValuesSupported.put((Object)requestObjectEncryptionAlg);
            }
            if (requestObjectEncryptionAlgValuesSupported.length() > 0) {
                jsonObj.put("request_object_encryption_alg_values_supported", (Object)requestObjectEncryptionAlgValuesSupported);
            }
            JSONArray requestObjectEncryptionEncValuesSupported = new JSONArray();
            for (String requestObjectEncryptionEnc : ConfigurationFactory.getConfiguration().getRequestObjectEncryptionEncValuesSupported()) {
                requestObjectEncryptionEncValuesSupported.put((Object)requestObjectEncryptionEnc);
            }
            if (requestObjectEncryptionEncValuesSupported.length() > 0) {
                jsonObj.put("request_object_encryption_enc_values_supported", (Object)requestObjectEncryptionEncValuesSupported);
            }
            JSONArray tokenEndpointAuthMethodsSupported = new JSONArray();
            for (String tokenEndpointAuthMethod : ConfigurationFactory.getConfiguration().getTokenEndpointAuthMethodsSupported()) {
                tokenEndpointAuthMethodsSupported.put((Object)tokenEndpointAuthMethod);
            }
            if (tokenEndpointAuthMethodsSupported.length() > 0) {
                jsonObj.put("token_endpoint_auth_methods_supported", (Object)tokenEndpointAuthMethodsSupported);
            }
            JSONArray tokenEndpointAuthSigningAlgValuesSupported = new JSONArray();
            for (String tokenEndpointAuthSigningAlg : ConfigurationFactory.getConfiguration().getTokenEndpointAuthSigningAlgValuesSupported()) {
                tokenEndpointAuthSigningAlgValuesSupported.put((Object)tokenEndpointAuthSigningAlg);
            }
            if (tokenEndpointAuthSigningAlgValuesSupported.length() > 0) {
                jsonObj.put("token_endpoint_auth_signing_alg_values_supported", (Object)tokenEndpointAuthSigningAlgValuesSupported);
            }
            JSONArray displayValuesSupported = new JSONArray();
            for (String display : ConfigurationFactory.getConfiguration().getDisplayValuesSupported()) {
                displayValuesSupported.put((Object)display);
            }
            if (displayValuesSupported.length() > 0) {
                jsonObj.put("display_values_supported", (Object)displayValuesSupported);
            }
            JSONArray claimTypesSupported = new JSONArray();
            for (String claimType : ConfigurationFactory.getConfiguration().getClaimTypesSupported()) {
                claimTypesSupported.put((Object)claimType);
            }
            if (claimTypesSupported.length() > 0) {
                jsonObj.put("claim_types_supported", (Object)claimTypesSupported);
            }
            JSONArray claimsSupported = new JSONArray();
            List<GluuAttribute> gluuAttributes = AttributeService.instance().getAllAttributes();
            for (GluuAttribute gluuAttribute : gluuAttributes) {
                String claimName = gluuAttribute.getOxAuthClaimName();
                if (!StringUtils.isNotBlank((String)claimName)) continue;
                claimsSupported.put((Object)claimName);
            }
            if (claimsSupported.length() > 0) {
                jsonObj.put("claims_supported", (Object)claimsSupported);
            }
            jsonObj.put("service_documentation", (Object)ConfigurationFactory.getConfiguration().getServiceDocumentation());
            JSONArray claimsLocalesSupported = new JSONArray();
            for (String claimLocale : ConfigurationFactory.getConfiguration().getClaimsLocalesSupported()) {
                claimsLocalesSupported.put((Object)claimLocale);
            }
            if (claimsLocalesSupported.length() > 0) {
                jsonObj.put("claims_locales_supported", (Object)claimsLocalesSupported);
            }
            JSONArray uiLocalesSupported = new JSONArray();
            for (String uiLocale : ConfigurationFactory.getConfiguration().getUiLocalesSupported()) {
                uiLocalesSupported.put((Object)uiLocale);
            }
            if (uiLocalesSupported.length() > 0) {
                jsonObj.put("ui_locales_supported", (Object)uiLocalesSupported);
            }
            jsonObj.put("scope_to_claims_mapping", (Object)OpenIdConfiguration.createScopeToClaimsMapping());
            jsonObj.put("claims_parameter_supported", (Object)ConfigurationFactory.getConfiguration().getClaimsParameterSupported());
            jsonObj.put("request_parameter_supported", (Object)ConfigurationFactory.getConfiguration().getRequestParameterSupported());
            jsonObj.put("request_uri_parameter_supported", (Object)ConfigurationFactory.getConfiguration().getRequestUriParameterSupported());
            jsonObj.put("require_request_uri_registration", (Object)ConfigurationFactory.getConfiguration().getRequireRequestUriRegistration());
            jsonObj.put("op_policy_uri", (Object)ConfigurationFactory.getConfiguration().getOpPolicyUri());
            jsonObj.put("op_tos_uri", (Object)ConfigurationFactory.getConfiguration().getOpTosUri());
            out.println(jsonObj.toString(4).replace("\\/", "/"));
        }
        catch (JSONException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        finally {
            out.close();
        }
    }

    private static JSONArray createScopeToClaimsMapping() {
        JSONArray result = new JSONArray();
        try {
            AttributeService attributeService = AttributeService.instance();
            ScopeService scopeService = ScopeService.instance();
            for (Scope scope : scopeService.getAllScopesList()) {
                JSONArray claimsList = new JSONArray();
                JSONObject mapping = new JSONObject();
                mapping.put("scope", (Object)scope.getDisplayName());
                mapping.put("claims", (Object)claimsList);
                result.put((Object)mapping);
                List<String> claimIdList = scope.getOxAuthClaims();
                if (claimIdList == null || claimIdList.isEmpty()) continue;
                for (String claimDn : claimIdList) {
                    GluuAttribute attribute = attributeService.getAttributeByDn(claimDn);
                    String claimName = attribute.getOxAuthClaimName();
                    if (!StringUtils.isNotBlank((String)claimName)) continue;
                    claimsList.put((Object)claimName);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return result;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "OpenID Provider Configuration Information";
    }
}

