/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma.resourceserver;

import java.util.Date;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.RegisterPermissionRequest;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.persistence.ResourceSet;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManager;
import org.xdi.oxauth.service.uma.resourceserver.RsResourceService;
import org.xdi.oxauth.service.uma.resourceserver.RsResourceType;
import org.xdi.oxauth.service.uma.resourceserver.RsScopeType;
import org.xdi.oxauth.uma.ws.rs.PermissionRegistrationWS;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.Pair;

@Scope(value=ScopeType.STATELESS)
@Name(value="umaRsPermissionService")
@AutoCreate
public class PermissionService {
    @Logger
    private Log log;
    @In
    private RsResourceService umaRsResourceService;
    @In
    private TokenService tokenService;
    @In
    private ResourceSetPermissionManager resourceSetPermissionManager;

    public static PermissionService instance() {
        return (PermissionService)ServerUtil.instance(PermissionService.class);
    }

    public Pair<Boolean, Response> hasEnoughPermissionsWithTicketRegistration(UmaRPT p_rpt, List<ResourceSetPermission> p_rptPermissions, RsResourceType p_resourceType, List<RsScopeType> p_scopes) {
        Pair result = new Pair((Object)false, null);
        ResourceSet resource = this.umaRsResourceService.getResource(p_resourceType);
        if (resource == null || StringUtils.isBlank((String)resource.getId())) {
            result.setFirst((Object)false);
            result.setSecond((Object)Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build());
            return result;
        }
        if (this.hasEnoughPermissions(p_rpt, p_rptPermissions, resource, p_scopes)) {
            result.setFirst((Object)true);
            return result;
        }
        result.setFirst((Object)false);
        String ticket = this.registerPermission(p_rpt, resource, p_scopes);
        String entity = ServerUtil.asJsonSilently(new ResourceSetPermissionTicket(ticket));
        this.log.debug((Object)("Construct response: HTTP 403 (Forbidden), entity: " + entity), new Object[0]);
        Response response = Response.status((Response.Status)Response.Status.FORBIDDEN).header("host_id", (Object)ConfigurationFactory.getConfiguration().getIssuer()).header("as_uri", (Object)ConfigurationFactory.getConfiguration().getUmaConfigurationEndpoint()).header("error", (Object)"insufficient_scope").entity((Object)entity).build();
        result.setSecond((Object)response);
        return result;
    }

    private boolean hasEnoughPermissions(UmaRPT p_rpt, List<ResourceSetPermission> p_rptPermissions, ResourceSet p_resource, List<RsScopeType> p_scopes) {
        if (p_rptPermissions != null && !p_rptPermissions.isEmpty()) {
            List<String> scopeDns = this.umaRsResourceService.getScopeDns(p_scopes);
            for (ResourceSetPermission p : p_rptPermissions) {
                if (!this.hasAny(p, scopeDns)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAny(ResourceSetPermission p_p, List<String> p_scopeDns) {
        List scopeDns = p_p.getScopeDns();
        if (scopeDns != null && !scopeDns.isEmpty() && p_scopeDns != null && !p_scopeDns.isEmpty()) {
            for (String scopeDn : scopeDns) {
                if (!p_scopeDns.contains(scopeDn)) continue;
                return true;
            }
        }
        return false;
    }

    private String registerPermission(UmaRPT p_rpt, ResourceSet p_resource, List<RsScopeType> p_scopes) {
        Date expirationDate = PermissionRegistrationWS.rptExpirationDate();
        RegisterPermissionRequest r = new RegisterPermissionRequest();
        r.setResourceSetId(p_resource.getId());
        r.setExpiresAt(expirationDate);
        String host = ConfigurationFactory.getConfiguration().getIssuer();
        ResourceSetPermission permission = this.resourceSetPermissionManager.createResourceSetPermission(host, r, expirationDate);
        permission.setScopeDns(this.umaRsResourceService.getScopeDns(p_scopes));
        Client client = ClientService.instance().getClient(p_rpt.getClientId());
        this.resourceSetPermissionManager.addResourceSetPermission(permission, client.getDn());
        return permission.getTicket();
    }
}

