/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma.authorization;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.SubnetUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.model.GluuAttribute;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.uma.ClaimToken;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.AttributeService;
import org.xdi.oxauth.service.uma.authorization.NeedInfoAuthenticationContext;
import org.xdi.oxauth.service.uma.authorization.NeedInfoRequestingPartyClaims;
import org.xdi.oxauth.util.ServerUtil;

public class AuthorizationContext {
    private static final Log LOG = Logging.getLog(AuthorizationContext.class);
    private final LdapEntryManager ldapEntryManager = ServerUtil.getLdapManager();
    private final UmaRPT m_rpt;
    private final ResourceSetPermission m_permission;
    private final IAuthorizationGrant m_grant;
    private final HttpServletRequest m_httpRequest;
    private final Map<String, List<String>> m_claims;
    private NeedInfoAuthenticationContext needInfoAuthenticationContext;
    private NeedInfoRequestingPartyClaims needInfoRequestingPartyClaims;

    public AuthorizationContext(UmaRPT p_rpt, ResourceSetPermission p_permission, IAuthorizationGrant p_grant, HttpServletRequest p_httpRequest, List<ClaimToken> claims) {
        this.m_rpt = p_rpt;
        this.m_permission = p_permission;
        this.m_grant = p_grant;
        this.m_httpRequest = p_httpRequest;
        this.m_claims = new HashMap<String, List<String>>();
        if (claims != null) {
            for (ClaimToken claim : claims) {
                List<String> strings = this.m_claims.get(claim.getFormat());
                if (strings == null) {
                    strings = new ArrayList<String>();
                }
                strings.add(claim.getToken());
                this.m_claims.put(claim.getFormat(), strings);
            }
        }
    }

    public Log getLog() {
        return LOG;
    }

    public HttpServletRequest getHttpRequest() {
        return this.m_httpRequest;
    }

    public List<String> getRequestClaim(String p_claimName) {
        List<String> value;
        if (StringUtils.isNotBlank((String)p_claimName) && this.m_claims != null && (value = this.m_claims.get(p_claimName)) != null) {
            return Collections.unmodifiableList(value);
        }
        return Collections.emptyList();
    }

    public String getIpAddress() {
        return this.m_httpRequest != null ? this.m_httpRequest.getRemoteAddr() : "";
    }

    public boolean isInNetwork(String p_cidrNotation) {
        String ip = this.getIpAddress();
        if (Util.allNotBlank((String[])new String[]{ip, p_cidrNotation})) {
            SubnetUtils utils = new SubnetUtils(p_cidrNotation);
            return utils.getInfo().isInRange(ip);
        }
        return false;
    }

    public IAuthorizationGrant getGrant() {
        return this.m_grant;
    }

    public String getAcrs() {
        return this.m_grant.getAcrValues();
    }

    public String getClientClaim(String p_claimName) {
        return this.getEntryAttributeValue(this.getGrant().getClientDn(), p_claimName);
    }

    public String getUserClaim(String p_claimName) {
        GluuAttribute gluuAttribute = AttributeService.instance().getByClaimName(p_claimName);
        if (gluuAttribute != null) {
            String ldapClaimName = gluuAttribute.getGluuLdapAttributeName();
            return this.getEntryAttributeValue(this.getGrant().getUserDn(), ldapClaimName);
        }
        return null;
    }

    public String getUserClaimByLdapName(String p_ldapName) {
        return this.getEntryAttributeValue(this.getGrant().getUserDn(), p_ldapName);
    }

    public UmaRPT getRpt() {
        return this.m_rpt;
    }

    public ResourceSetPermission getPermission() {
        return this.m_permission;
    }

    private SearchResultEntry getEntryByDn(String p_dn) {
        LDAPConnectionPool pool = this.ldapEntryManager.getLdapOperationService().getConnectionPool();
        try {
            return pool.getEntry(p_dn);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private String getEntryAttributeValue(String p_dn, String p_attributeName) {
        Attribute attribute;
        SearchResultEntry entry = this.getEntryByDn(p_dn);
        if (entry != null && (attribute = entry.getAttribute(p_attributeName)) != null) {
            return attribute.getValue();
        }
        return "";
    }

    public NeedInfoAuthenticationContext getNeedInfoAuthenticationContext() {
        return this.needInfoAuthenticationContext;
    }

    public void setNeedInfoAuthenticationContext(NeedInfoAuthenticationContext needInfoAuthenticationContext) {
        this.needInfoAuthenticationContext = needInfoAuthenticationContext;
    }

    public NeedInfoRequestingPartyClaims getNeedInfoRequestingPartyClaims() {
        return this.needInfoRequestingPartyClaims;
    }

    public void setNeedInfoRequestingPartyClaims(NeedInfoRequestingPartyClaims needInfoRequestingPartyClaims) {
        this.needInfoRequestingPartyClaims = needInfoRequestingPartyClaims;
    }
}

