/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.InternalExternal;
import org.xdi.oxauth.model.uma.persistence.ScopeDescription;
import org.xdi.oxauth.model.uma.persistence.UmaScopeType;
import org.xdi.oxauth.service.InumService;
import org.xdi.oxauth.util.ServerUtil;

@AutoCreate
@Scope(value=ScopeType.STATELESS)
@Name(value="umaScopeService")
public class ScopeService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private InumService inumService;
    @In
    private ErrorResponseFactory errorResponseFactory;

    public static ScopeService instance() {
        return (ScopeService)ServerUtil.instance(ScopeService.class);
    }

    public List<ScopeDescription> getAllScopes() {
        try {
            return this.ldapEntryManager.findEntries(ScopeService.baseDn(), ScopeDescription.class, Filter.createPresenceFilter((String)"inum"));
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return Collections.emptyList();
        }
    }

    public List<ScopeDescription> getScopes(UmaScopeType p_type) {
        try {
            if (p_type != null) {
                Filter filter = Filter.create((String)String.format("&(oxType=%s)", p_type.getValue()));
                return this.ldapEntryManager.findEntries(ScopeService.baseDn(), ScopeDescription.class, filter);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return Collections.emptyList();
    }

    public ScopeDescription getInternalScope(String p_scopeId) {
        try {
            Filter filter = Filter.create((String)String.format("&(oxType=%s)(oxId=%s)", UmaScopeType.INTERNAL.getValue(), p_scopeId));
            List entries = this.ldapEntryManager.findEntries(ScopeService.baseDn(), ScopeDescription.class, filter);
            if (entries != null && !entries.isEmpty()) {
                if (entries.size() > 1) {
                    this.log.error((Object)("Found more then one internal uma scope by input id: {0}" + p_scopeId), new Object[0]);
                    for (ScopeDescription s : entries) {
                        this.log.error((Object)"Scope, Id: {0}, dn: {1}", new Object[]{s.getId(), s.getDn()});
                    }
                }
                return (ScopeDescription)entries.get(0);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    public boolean persist(ScopeDescription p_scopeDescription) {
        try {
            if (StringUtils.isBlank((String)p_scopeDescription.getDn())) {
                p_scopeDescription.setDn(String.format("inum=%s,%s", p_scopeDescription.getInum(), ScopeService.baseDn()));
            }
            this.ldapEntryManager.persist((Object)p_scopeDescription);
            return true;
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return false;
        }
    }

    public List<String> getScopeDNsByUrlsAndAddToLdapIfNeeded(List<String> p_scopeUrls) {
        ArrayList<String> result = new ArrayList<String>();
        if (p_scopeUrls != null && !p_scopeUrls.isEmpty()) {
            try {
                List<String> sourceScopeUrls = this.handleInternalScopes(p_scopeUrls, result);
                if (sourceScopeUrls.size() > 0) {
                    this.handleExternalScopes(sourceScopeUrls, result);
                }
            }
            catch (WebApplicationException e) {
                throw e;
            }
            catch (Exception e) {
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
        }
        return result;
    }

    private List<String> handleInternalScopes(List<String> p_scopeUrls, List<String> result) {
        ArrayList<String> notProcessedScopeUrls = new ArrayList<String>(p_scopeUrls);
        try {
            Filter filter = Filter.create((String)String.format("&(oxType=%s)", InternalExternal.INTERNAL.getValue()));
            List entries = this.ldapEntryManager.findEntries(ScopeService.baseDn(), ScopeDescription.class, filter);
            if (entries != null && !entries.isEmpty()) {
                for (String scopeUrl : p_scopeUrls) {
                    for (ScopeDescription scopeDescription : entries) {
                        String internalScopeUrl = ScopeService.getInternalScopeUrl(scopeDescription);
                        if (!internalScopeUrl.equals(scopeUrl) || result.contains(internalScopeUrl)) continue;
                        result.add(scopeDescription.getDn());
                        notProcessedScopeUrls.remove(scopeUrl);
                    }
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return notProcessedScopeUrls;
    }

    private void handleExternalScopes(List<String> p_scopeUrls, List<String> result) throws LDAPException {
        for (String scopeUrl : p_scopeUrls) {
            Filter filter = Filter.create((String)String.format("&(oxUrl=%s)", scopeUrl));
            List entries = this.ldapEntryManager.findEntries(ScopeService.baseDn(), ScopeDescription.class, filter);
            if (entries != null && !entries.isEmpty()) {
                result.add(((ScopeDescription)entries.get(0)).getDn());
                continue;
            }
            Boolean addAutomatically = ConfigurationFactory.getConfiguration().getUmaAddScopesAutomatically();
            if (addAutomatically != null && addAutomatically.booleanValue()) {
                String inum = this.inumService.generateInum();
                ScopeDescription newScope = new ScopeDescription();
                newScope.setInum(inum);
                newScope.setUrl(scopeUrl);
                newScope.setDisplayName(scopeUrl);
                newScope.setId(UmaScopeType.EXTERNAL_AUTO.getValue());
                newScope.setType(InternalExternal.EXTERNAL_AUTO);
                boolean persisted = this.persist(newScope);
                if (!persisted) continue;
                result.add(newScope.getDn());
                continue;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.INVALID_RESOURCE_SET_SCOPE)).build());
        }
    }

    public List<ScopeDescription> getScopesByUrls(List<String> p_scopeUrls) {
        try {
            List entries;
            Filter filter = this.createAnyFilterByUrls(p_scopeUrls);
            if (filter != null && (entries = this.ldapEntryManager.findEntries(ScopeService.baseDn(), ScopeDescription.class, filter)) != null) {
                return entries;
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return Collections.emptyList();
    }

    public List<ScopeDescription> getScopesByDns(List<String> p_scopeDns) {
        ArrayList<ScopeDescription> result = new ArrayList<ScopeDescription>();
        try {
            if (p_scopeDns != null && !p_scopeDns.isEmpty()) {
                for (String dn : p_scopeDns) {
                    ScopeDescription scopeDescription = (ScopeDescription)this.ldapEntryManager.find(ScopeDescription.class, (Object)dn);
                    if (scopeDescription == null) continue;
                    result.add(scopeDescription);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return result;
    }

    public List<String> getScopeUrlsByDns(List<String> p_scopeDns) {
        return ScopeService.getScopeUrls(this.getScopesByDns(p_scopeDns));
    }

    public static List<String> getScopeDNs(List<ScopeDescription> p_scopes) {
        ArrayList<String> result = new ArrayList<String>();
        if (p_scopes != null && !p_scopes.isEmpty()) {
            for (ScopeDescription s : p_scopes) {
                result.add(s.getDn());
            }
        }
        return result;
    }

    public static List<String> getScopeUrls(List<ScopeDescription> p_scopes) {
        ArrayList<String> result = new ArrayList<String>();
        if (p_scopes != null && !p_scopes.isEmpty()) {
            for (ScopeDescription s : p_scopes) {
                InternalExternal type = s.getType();
                if (type != null) {
                    switch (type) {
                        case EXTERNAL: 
                        case EXTERNAL_AUTO: {
                            result.add(s.getUrl());
                            break;
                        }
                        case INTERNAL: {
                            result.add(ScopeService.getInternalScopeUrl(s));
                        }
                    }
                    continue;
                }
                result.add(s.getUrl());
            }
        }
        return result;
    }

    private static String getInternalScopeUrl(ScopeDescription internalScope) {
        if (internalScope != null && internalScope.getType() == InternalExternal.INTERNAL) {
            return ScopeService.getScopeEndpoint() + "/" + internalScope.getId();
        }
        return "";
    }

    private static String getScopeEndpoint() {
        return ConfigurationFactory.getConfiguration().getBaseEndpoint() + "/uma/scopes";
    }

    private Filter createAnyFilterByUrls(List<String> p_scopeUrls) {
        try {
            if (p_scopeUrls != null && !p_scopeUrls.isEmpty()) {
                StringBuilder sb = new StringBuilder("(|");
                for (String url : p_scopeUrls) {
                    sb.append("(");
                    sb.append("oxUrl=");
                    sb.append(url);
                    sb.append(")");
                }
                sb.append(")");
                String filterAsString = sb.toString();
                this.log.trace((Object)("Uma scope urls: " + p_scopeUrls + ", ldapFilter: " + filterAsString), new Object[0]);
                return Filter.create((String)filterAsString);
            }
        }
        catch (LDAPException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    public static String baseDn() {
        return String.format("ou=scopes,%s", ConfigurationFactory.getBaseDn().getUmaBase());
    }
}

