/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import java.util.Date;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.uma.RegisterPermissionRequest;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.uma.IResourceSetPermissionManager;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManagerInMemory;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManagerLdap;
import org.xdi.oxauth.util.ServerUtil;

@AutoCreate
@Scope(value=ScopeType.APPLICATION)
@Name(value="resourceSetPermissionManager")
public class ResourceSetPermissionManager
implements IResourceSetPermissionManager {
    @Logger
    private Log log;
    private IResourceSetPermissionManager manager;

    @Create
    public void init() {
        switch (ConfigurationFactory.getConfiguration().getModeEnum()) {
            case IN_MEMORY: {
                this.manager = new ResourceSetPermissionManagerInMemory();
                this.log.info((Object)"Created IN-MEMORY UMA resource set manager", new Object[0]);
                break;
            }
            case LDAP: {
                this.manager = new ResourceSetPermissionManagerLdap();
                this.log.info((Object)"Created LDAP UMA resource set manager", new Object[0]);
                break;
            }
            default: {
                this.log.error((Object)"Unable to identify mode of the server. (Please check configuration.)", new Object[0]);
                throw new IllegalArgumentException("Unable to identify mode of the server. (Please check configuration.)");
            }
        }
    }

    @Override
    public void addResourceSetPermission(ResourceSetPermission resourceSetPermission, String p_clientDn) {
        this.manager.addResourceSetPermission(resourceSetPermission, p_clientDn);
    }

    @Override
    public ResourceSetPermission getResourceSetPermissionByTicket(String resourceSetPermissionTicket) {
        return this.manager.getResourceSetPermissionByTicket(resourceSetPermissionTicket);
    }

    @Override
    public String getResourceSetPermissionTicketByConfigurationCode(String configurationCode, String clientDn) {
        return this.manager.getResourceSetPermissionTicketByConfigurationCode(configurationCode, clientDn);
    }

    @Override
    public ResourceSetPermission createResourceSetPermission(String amHost, RegisterPermissionRequest resourceSetPermissionRequest, Date expirationDate) {
        return this.manager.createResourceSetPermission(amHost, resourceSetPermissionRequest, expirationDate);
    }

    @Override
    public void deleteResourceSetPermission(String resourceSetPermissionTicket) {
        this.manager.deleteResourceSetPermission(resourceSetPermissionTicket);
    }

    @Override
    public void cleanupResourceSetPermissions(Date now) {
        this.manager.cleanupResourceSetPermissions(now);
    }

    public static ResourceSetPermissionManager instance() {
        return (ResourceSetPermissionManager)ServerUtil.instance(ResourceSetPermissionManager.class);
    }
}

