/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import com.unboundid.ldap.sdk.Filter;
import com.unboundid.util.StaticUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.uma.AbstractRPTManager;
import org.xdi.oxauth.util.ServerUtil;

public class RPTManagerLdap
extends AbstractRPTManager {
    private static final String ORGUNIT_OF_RPT = "uma_requester_permission_token";
    private static final Log LOG = Logging.getLog(RPTManagerLdap.class);
    private final LdapEntryManager ldapEntryManager = ServerUtil.getLdapManager();

    @Override
    public void addRPT(UmaRPT p_rpt, String p_clientDn) {
        try {
            this.addBranchIfNeeded(p_clientDn);
            String id = UUID.randomUUID().toString();
            p_rpt.setId(id);
            p_rpt.setDn(RPTManagerLdap.getDn(p_clientDn, id));
            this.ldapEntryManager.persist((Object)p_rpt);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public UmaRPT getRPTByCode(String p_code) {
        try {
            Filter filter = Filter.create((String)String.format("&(oxAuthTokenCode=%s)", p_code));
            String baseDn = ConfigurationFactory.getBaseDn().getClients();
            List entries = this.ldapEntryManager.findEntries(baseDn, UmaRPT.class, filter);
            if (entries != null && !entries.isEmpty()) {
                return (UmaRPT)entries.get(0);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    @Override
    public void deleteRPT(String rptCode) {
        try {
            UmaRPT t = this.getRPTByCode(rptCode);
            if (t != null) {
                this.ldapEntryManager.remove((Object)t);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void cleanupRPTs(Date now) {
        try {
            Filter filter = Filter.create((String)String.format("(oxAuthExpiration<=%s)", StaticUtils.encodeGeneralizedTime((Date)now)));
            List entries = this.ldapEntryManager.findEntries(ConfigurationFactory.getBaseDn().getClients(), UmaRPT.class, filter);
            if (entries != null && !entries.isEmpty()) {
                for (UmaRPT p : entries) {
                    this.ldapEntryManager.remove((Object)p);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public void addPermissionToRPT(UmaRPT p_rpt, ResourceSetPermission p_permission) {
        ArrayList<String> permissions = new ArrayList<String>();
        if (p_rpt.getPermissions() != null) {
            permissions.addAll(p_rpt.getPermissions());
        }
        permissions.add(p_permission.getDn());
        p_rpt.setPermissions(permissions);
        try {
            this.ldapEntryManager.merge((Object)p_rpt);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    @Override
    public List<ResourceSetPermission> getRptPermissions(UmaRPT p_rpt) {
        ArrayList<ResourceSetPermission> result = new ArrayList<ResourceSetPermission>();
        try {
            if (p_rpt != null && p_rpt.getPermissions() != null) {
                List<String> permissionDns = p_rpt.getPermissions();
                for (String permissionDn : permissionDns) {
                    ResourceSetPermission permissionObject = (ResourceSetPermission)this.ldapEntryManager.find(ResourceSetPermission.class, (Object)permissionDn);
                    if (permissionObject == null) continue;
                    result.add(permissionObject);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return result;
    }

    @Override
    public UmaRPT createRPT(String authorization, String amHost) {
        throw new UnsupportedOperationException("We don't need this method implementation in delegated manager");
    }

    @Override
    public ResourceSetPermission getPermissionFromRPTByResourceSetId(UmaRPT p_rpt, String p_resourceSetId) {
        try {
            if (p_rpt != null && p_rpt.getPermissions() != null && Util.allNotBlank((String[])new String[]{p_resourceSetId})) {
                List<String> permissionDns = p_rpt.getPermissions();
                for (String permissionDn : permissionDns) {
                    ResourceSetPermission permissionObject = (ResourceSetPermission)this.ldapEntryManager.find(ResourceSetPermission.class, (Object)permissionDn);
                    if (permissionObject == null || !p_resourceSetId.equals(permissionObject.getResourceSetId())) continue;
                    return permissionObject;
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    public void addBranch(String clientDn) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName(ORGUNIT_OF_RPT);
        branch.setDn(RPTManagerLdap.branchDn(clientDn));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addBranchIfNeeded(String clientDn) {
        if (!this.containsBranch(clientDn)) {
            this.addBranch(clientDn);
        }
    }

    public boolean containsBranch(String clientDn) {
        return this.ldapEntryManager.contains(SimpleBranch.class, RPTManagerLdap.branchDn(clientDn));
    }

    public static String getDn(String clientDn, String uniqueIdentifier) {
        return String.format("uniqueIdentifier=%s,%s", uniqueIdentifier, RPTManagerLdap.branchDn(clientDn));
    }

    public static String branchDn(String clientDn) {
        return String.format("ou=%s,%s", ORGUNIT_OF_RPT, clientDn);
    }
}

