/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import java.util.Date;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.IRPTManager;
import org.xdi.oxauth.service.uma.RPTManagerInMemory;
import org.xdi.oxauth.service.uma.RPTManagerLdap;
import org.xdi.oxauth.util.ServerUtil;

@AutoCreate
@Scope(value=ScopeType.APPLICATION)
@Name(value="rptManager")
public class RPTManager
implements IRPTManager {
    @Logger
    private Log log;
    @In
    private TokenService tokenService;
    @In
    private AuthorizationGrantList authorizationGrantList;
    private IRPTManager manager;

    @Create
    public void init() {
        switch (ConfigurationFactory.getConfiguration().getModeEnum()) {
            case IN_MEMORY: {
                this.manager = new RPTManagerInMemory();
                this.log.info((Object)"Created IN-MEMORY UMA RPT manager", new Object[0]);
                break;
            }
            case LDAP: {
                this.manager = new RPTManagerLdap();
                this.log.info((Object)"Created LDAP UMA RPT manager", new Object[0]);
                break;
            }
            default: {
                this.log.error((Object)"Unable to identify mode of the server. (Please check configuration.)", new Object[0]);
                throw new IllegalArgumentException("Unable to identify mode of the server. (Please check configuration.)");
            }
        }
    }

    @Override
    public UmaRPT createRPT(String authorization, String amHost) {
        String aatToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(aatToken);
        AbstractToken accessToken = authorizationGrant.getAccessToken(aatToken);
        UmaRPT rpt = this.createRPT(accessToken, authorizationGrant.getUserId(), authorizationGrant.getClientId(), amHost);
        this.addRPT(rpt, authorizationGrant.getClientDn());
        return rpt;
    }

    @Override
    public void addRPT(UmaRPT requesterPermissionToken, String clientDn) {
        this.manager.addRPT(requesterPermissionToken, clientDn);
    }

    @Override
    public UmaRPT getRPTByCode(String requesterPermissionTokenCode) {
        return this.manager.getRPTByCode(requesterPermissionTokenCode);
    }

    @Override
    public UmaRPT createRPT(AbstractToken authorizationApiToken, String userId, String clientId, String amHost) {
        return this.manager.createRPT(authorizationApiToken, userId, clientId, amHost);
    }

    @Override
    public void deleteRPT(String rptCode) {
        this.manager.deleteRPT(rptCode);
    }

    @Override
    public void cleanupRPTs(Date now) {
        this.manager.cleanupRPTs(now);
    }

    @Override
    public void addPermissionToRPT(UmaRPT p_rpt, ResourceSetPermission p_permission) {
        this.manager.addPermissionToRPT(p_rpt, p_permission);
    }

    @Override
    public ResourceSetPermission getPermissionFromRPTByResourceSetId(UmaRPT p_rpt, String p_resourceSetId) {
        return this.manager.getPermissionFromRPTByResourceSetId(p_rpt, p_resourceSetId);
    }

    @Override
    public List<ResourceSetPermission> getRptPermissions(UmaRPT p_rpt) {
        return this.manager.getRptPermissions(p_rpt);
    }

    public static RPTManager instance() {
        return (RPTManager)ServerUtil.instance(RPTManager.class);
    }
}

