/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.unboundid.ldap.sdk.Filter;
import java.util.Date;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.fido.u2f.RequestMessageLdap;

@Scope(value=ScopeType.STATELESS)
@Name(value="u2fRequestService")
@AutoCreate
public class RequestService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public List<RequestMessageLdap> getExpiredRequestMessages(Date expirationDate) {
        String u2fBaseDn = ConfigurationFactory.getBaseDn().getU2fBase();
        Filter expiratioFilter = Filter.createLessOrEqualFilter((String)"creationDate", (String)this.ldapEntryManager.encodeGeneralizedTime(expirationDate));
        List requestMessageLdap = this.ldapEntryManager.findEntries(u2fBaseDn, RequestMessageLdap.class, expiratioFilter);
        return requestMessageLdap;
    }

    public void removeRequestMessage(RequestMessageLdap requestMessageLdap) {
        this.ldapEntryManager.remove((Object)requestMessageLdap);
    }
}

