/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.unboundid.ldap.sdk.Filter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.crypto.random.ChallengeGenerator;
import org.xdi.oxauth.exception.fido.u2f.DeviceCompromisedException;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistrationStatus;
import org.xdi.oxauth.model.fido.u2f.RegisterRequestMessageLdap;
import org.xdi.oxauth.model.fido.u2f.RequestMessageLdap;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.message.RawRegisterResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateRequest;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterRequest;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterRequestMessage;
import org.xdi.oxauth.model.fido.u2f.protocol.RegisterResponse;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.fido.u2f.ApplicationService;
import org.xdi.oxauth.service.fido.u2f.AuthenticationService;
import org.xdi.oxauth.service.fido.u2f.ClientDataValidationService;
import org.xdi.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RawRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RequestService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="u2fRegistrationService")
@AutoCreate
public class RegistrationService
extends RequestService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private ApplicationService applicationService;
    @In
    private UserService userService;
    @In
    private AuthenticationService u2fAuthenticationService;
    @In
    private RawRegistrationService rawRegistrationService;
    @In
    private ClientDataValidationService clientDataValidationService;
    @In
    private DeviceRegistrationService deviceRegistrationService;
    @In(value="randomChallengeGenerator")
    private ChallengeGenerator challengeGenerator;

    public RegisterRequestMessage builRegisterRequestMessage(String appId, String userName) {
        String userInum;
        if (this.applicationService.isValidateApplication()) {
            this.applicationService.checkIsValid(appId);
        }
        if (StringHelper.isEmpty((String)(userInum = this.userService.getUserInum(userName)))) {
            throw new BadInputException(String.format("Failed to find user '%s' in LDAP", userName));
        }
        ArrayList<AuthenticateRequest> authenticateRequests = new ArrayList<AuthenticateRequest>();
        ArrayList<RegisterRequest> registerRequests = new ArrayList<RegisterRequest>();
        List<DeviceRegistration> deviceRegistrations = this.deviceRegistrationService.findUserDeviceRegistrations(userInum, appId, new String[0]);
        for (DeviceRegistration deviceRegistration : deviceRegistrations) {
            if (deviceRegistration.isCompromised()) continue;
            try {
                AuthenticateRequest authenticateRequest = this.u2fAuthenticationService.startAuthentication(appId, deviceRegistration);
                authenticateRequests.add(authenticateRequest);
            }
            catch (DeviceCompromisedException ex) {
                this.log.error((Object)"Faield to authenticate device", (Throwable)ex, new Object[0]);
            }
        }
        RegisterRequest request = this.startRegistration(appId);
        registerRequests.add(request);
        return new RegisterRequestMessage(authenticateRequests, registerRequests);
    }

    public RegisterRequest startRegistration(String appId) {
        return this.startRegistration(appId, this.challengeGenerator.generateChallenge());
    }

    public RegisterRequest startRegistration(String appId, byte[] challenge) {
        return new RegisterRequest(Base64Util.base64urlencode((byte[])challenge), appId);
    }

    public DeviceRegistration finishRegistration(RegisterRequestMessage requestMessage, RegisterResponse response, String userName) throws BadInputException {
        return this.finishRegistration(requestMessage, response, userName, null);
    }

    public DeviceRegistration finishRegistration(RegisterRequestMessage requestMessage, RegisterResponse response, String userName, Set<String> facets) throws BadInputException {
        String userInum = this.userService.getUserInum(userName);
        if (StringHelper.isEmpty((String)userInum)) {
            throw new BadInputException(String.format("Failed to find user '%s' in LDAP", userName));
        }
        RegisterRequest request = requestMessage.getRegisterRequest();
        String appId = request.getAppId();
        ClientData clientData = response.getClientData();
        this.clientDataValidationService.checkContent(clientData, "navigator.id.finishEnrollment", request.getChallenge(), facets);
        RawRegisterResponse rawRegisterResponse = this.rawRegistrationService.parseRawRegisterResponse(response.getRegistrationData());
        this.rawRegistrationService.checkSignature(appId, clientData, rawRegisterResponse);
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        DeviceRegistration deviceRegistration = this.rawRegistrationService.createDevice(rawRegisterResponse);
        deviceRegistration.setStatus(DeviceRegistrationStatus.ACTIVE);
        deviceRegistration.setApplication(appId);
        deviceRegistration.setCreationDate(now);
        String deviceRegistrationId = String.valueOf(System.currentTimeMillis());
        deviceRegistration.setId(deviceRegistrationId);
        deviceRegistration.setDn(this.deviceRegistrationService.getDnForU2fDevice(deviceRegistrationId, userInum));
        this.deviceRegistrationService.addUserDeviceRegistration(userInum, deviceRegistration);
        return deviceRegistration;
    }

    public void storeRegisterRequestMessage(RegisterRequestMessage requestMessage) {
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String registerRequestMessageId = UUID.randomUUID().toString();
        RegisterRequestMessageLdap registerRequestMessageLdap = new RegisterRequestMessageLdap(requestMessage);
        registerRequestMessageLdap.setCreationDate(now);
        registerRequestMessageLdap.setId(registerRequestMessageId);
        registerRequestMessageLdap.setDn(this.getDnForRegisterRequestMessage(registerRequestMessageId));
        this.ldapEntryManager.persist((Object)registerRequestMessageLdap);
    }

    public RegisterRequestMessage getRegisterRequestMessage(String oxId) {
        String requestDn = this.getDnForRegisterRequestMessage(oxId);
        RegisterRequestMessageLdap registerRequestMessageLdap = (RegisterRequestMessageLdap)this.ldapEntryManager.find(RegisterRequestMessageLdap.class, (Object)requestDn);
        if (registerRequestMessageLdap == null) {
            return null;
        }
        return registerRequestMessageLdap.getRegisterRequestMessage();
    }

    public RegisterRequestMessageLdap getRegisterRequestMessageByRequestId(String requestId) {
        Filter requestIdFilter;
        String baseDn = this.getDnForRegisterRequestMessage(null);
        List registerRequestMessagesLdap = this.ldapEntryManager.findEntries(baseDn, RegisterRequestMessageLdap.class, requestIdFilter = Filter.createEqualityFilter((String)"oxRequestId", (String)requestId));
        if (registerRequestMessagesLdap == null || registerRequestMessagesLdap.isEmpty()) {
            return null;
        }
        return (RegisterRequestMessageLdap)registerRequestMessagesLdap.get(0);
    }

    public void removeRegisterRequestMessage(RequestMessageLdap registerRequestMessageLdap) {
        this.removeRequestMessage(registerRequestMessageLdap);
    }

    public String getDnForRegisterRequestMessage(String oxId) {
        String u2fBaseDn = ConfigurationFactory.getBaseDn().getU2fBase();
        if (StringHelper.isEmpty((String)oxId)) {
            return String.format("ou=registration_requests,%s", u2fBaseDn);
        }
        return String.format("oxid=%s,ou=registration_requests,%s", oxId, u2fBaseDn);
    }
}

