/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.crypto.signature.BouncyCastleSignatureVerification;
import org.xdi.oxauth.model.exception.SignatureException;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.message.RawAuthenticateResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.util.io.ByteDataInputStream;

@Scope(value=ScopeType.STATELESS)
@Name(value="rawAuthenticationService")
@AutoCreate
public class RawAuthenticationService {
    public static final String AUTHENTICATE_TYPE = "navigator.id.getAssertion";
    @Logger
    private Log log;
    @In(value="bouncyCastleSignatureVerification")
    private BouncyCastleSignatureVerification signatureVerification;

    public RawAuthenticateResponse parseRawAuthenticateResponse(String rawDataBase64) {
        ByteDataInputStream bis = new ByteDataInputStream(Base64Util.base64urldecode((String)rawDataBase64));
        try {
            RawAuthenticateResponse rawAuthenticateResponse = new RawAuthenticateResponse(bis.readSigned(), (long)bis.readInt(), bis.readAll());
            return rawAuthenticateResponse;
        }
        catch (IOException ex) {
            throw new BadInputException("Failed to parse RAW authenticate response", (Throwable)ex);
        }
        finally {
            IOUtils.closeQuietly((InputStream)bis);
        }
    }

    public void checkSignature(String appId, ClientData clientData, RawAuthenticateResponse rawAuthenticateResponse, byte[] publicKey) throws BadInputException {
        String rawClientData = clientData.getRawClientData();
        byte[] signedBytes = this.packBytesToSign(this.signatureVerification.hash(appId), rawAuthenticateResponse.getUserPresence(), rawAuthenticateResponse.getCounter(), this.signatureVerification.hash(rawClientData));
        try {
            this.signatureVerification.checkSignature(this.signatureVerification.decodePublicKey(publicKey), signedBytes, rawAuthenticateResponse.getSignature());
        }
        catch (SignatureException ex) {
            throw new BadInputException("Failed to checkSignature", (Throwable)ex);
        }
    }

    private byte[] packBytesToSign(byte[] appIdHash, byte userPresence, long counter, byte[] challengeHash) {
        ByteArrayDataOutput encoded = ByteStreams.newDataOutput();
        encoded.write(appIdHash);
        encoded.write((int)userPresence);
        encoded.writeInt((int)counter);
        encoded.write(challengeHash);
        return encoded.toByteArray();
    }
}

