/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.unboundid.ldap.sdk.Filter;
import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.hibernate.annotations.common.util.StringHelper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.service.UserService;

@Scope(value=ScopeType.STATELESS)
@Name(value="deviceRegistrationService")
@AutoCreate
public class DeviceRegistrationService {
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private UserService userService;
    @Logger
    private Log log;

    public void addBranch(String userInum) {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("u2f_devices");
        branch.setDn(this.getBaseDnForU2fUserDevices(userInum));
        this.ldapEntryManager.persist((Object)branch);
    }

    public boolean containsBranch(String userInum) {
        return this.ldapEntryManager.contains(SimpleBranch.class, this.getBaseDnForU2fUserDevices(userInum));
    }

    public void prepareBranch(String userInum) {
        if (!this.containsBranch(userInum)) {
            this.addBranch(userInum);
        }
    }

    public List<DeviceRegistration> findUserDeviceRegistrations(String userInum, String appId, String ... returnAttributes) {
        this.prepareBranch(userInum);
        String baseDnForU2fDevices = this.getBaseDnForU2fUserDevices(userInum);
        Filter appIdFilter = Filter.createEqualityFilter((String)"oxApplication", (String)appId);
        return this.ldapEntryManager.findEntries(baseDnForU2fDevices, DeviceRegistration.class, returnAttributes, appIdFilter);
    }

    public void addUserDeviceRegistration(String userInum, DeviceRegistration deviceRegistration) {
        this.prepareBranch(userInum);
        this.ldapEntryManager.persist((Object)deviceRegistration);
    }

    public void updateDeviceRegistration(String userInum, DeviceRegistration deviceRegistration) {
        this.prepareBranch(userInum);
        this.ldapEntryManager.merge((Object)deviceRegistration);
    }

    public String getDnForU2fDevice(String oxId, String userInum) {
        String baseDnForU2fDevices = this.getBaseDnForU2fUserDevices(userInum);
        if (StringHelper.isEmpty((String)oxId)) {
            return baseDnForU2fDevices;
        }
        return String.format("oxId=%s,%s", oxId, baseDnForU2fDevices);
    }

    public String getBaseDnForU2fUserDevices(String userInum) {
        String userBaseDn = this.userService.getDnForUser(userInum);
        return String.format("ou=u2f_devices,%s", userBaseDn);
    }

    public static DeviceRegistrationService instance() {
        return (DeviceRegistrationService)Component.getInstance(DeviceRegistrationService.class);
    }
}

