/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.fido.u2f;

import com.unboundid.ldap.sdk.Filter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.crypto.random.ChallengeGenerator;
import org.xdi.oxauth.exception.fido.u2f.DeviceCompromisedException;
import org.xdi.oxauth.exception.fido.u2f.NoEligableDevicesException;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.fido.u2f.AuthenticateRequestMessageLdap;
import org.xdi.oxauth.model.fido.u2f.DeviceRegistration;
import org.xdi.oxauth.model.fido.u2f.exception.BadInputException;
import org.xdi.oxauth.model.fido.u2f.message.RawAuthenticateResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateRequest;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateRequestMessage;
import org.xdi.oxauth.model.fido.u2f.protocol.AuthenticateResponse;
import org.xdi.oxauth.model.fido.u2f.protocol.ClientData;
import org.xdi.oxauth.model.util.Base64Util;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.fido.u2f.ApplicationService;
import org.xdi.oxauth.service.fido.u2f.ClientDataValidationService;
import org.xdi.oxauth.service.fido.u2f.DeviceRegistrationService;
import org.xdi.oxauth.service.fido.u2f.RawAuthenticationService;
import org.xdi.oxauth.service.fido.u2f.RequestService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="u2fAuthenticationService")
@AutoCreate
public class AuthenticationService
extends RequestService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;
    @In
    private ApplicationService applicationService;
    @In
    private RawAuthenticationService rawAuthenticationService;
    @In
    private ClientDataValidationService clientDataValidationService;
    @In
    private DeviceRegistrationService deviceRegistrationService;
    @In
    private UserService userService;
    @In(value="randomChallengeGenerator")
    private ChallengeGenerator challengeGenerator;

    public AuthenticateRequestMessage buildAuthenticateRequestMessage(String appId, String userName) throws BadInputException, NoEligableDevicesException {
        String userInum;
        if (this.applicationService.isValidateApplication()) {
            this.applicationService.checkIsValid(appId);
        }
        if (StringHelper.isEmpty((String)(userInum = this.userService.getUserInum(userName)))) {
            throw new BadInputException(String.format("Failed to find user '%s' in LDAP", userName));
        }
        ArrayList<AuthenticateRequest> authenticateRequests = new ArrayList<AuthenticateRequest>();
        byte[] challenge = this.challengeGenerator.generateChallenge();
        List<DeviceRegistration> deviceRegistrations = this.deviceRegistrationService.findUserDeviceRegistrations(userInum, appId, new String[0]);
        for (DeviceRegistration deviceRegistration : deviceRegistrations) {
            if (deviceRegistration.isCompromised()) continue;
            try {
                AuthenticateRequest request = this.startAuthentication(appId, deviceRegistration, challenge);
                authenticateRequests.add(request);
            }
            catch (DeviceCompromisedException ex) {
                this.log.error((Object)"Faield to authenticate device", (Throwable)ex, new Object[0]);
            }
        }
        if (authenticateRequests.isEmpty()) {
            if (deviceRegistrations.isEmpty()) {
                throw new NoEligableDevicesException(deviceRegistrations, "No devices registrered");
            }
            throw new NoEligableDevicesException(deviceRegistrations, "All devices compromised");
        }
        return new AuthenticateRequestMessage(authenticateRequests);
    }

    public AuthenticateRequest startAuthentication(String appId, DeviceRegistration device) throws DeviceCompromisedException {
        return this.startAuthentication(appId, device, this.challengeGenerator.generateChallenge());
    }

    public AuthenticateRequest startAuthentication(String appId, DeviceRegistration device, byte[] challenge) throws DeviceCompromisedException {
        if (device.isCompromised()) {
            throw new DeviceCompromisedException(device, "Device has been marked as compromised, cannot authenticate");
        }
        return new AuthenticateRequest(Base64Util.base64urlencode((byte[])challenge), appId, device.getDeviceRegistrationConfiguration().getKeyHandle());
    }

    public DeviceRegistration finishAuthentication(AuthenticateRequestMessage requestMessage, AuthenticateResponse response, String userName) throws BadInputException, DeviceCompromisedException {
        return this.finishAuthentication(requestMessage, response, userName, null);
    }

    public DeviceRegistration finishAuthentication(AuthenticateRequestMessage requestMessage, AuthenticateResponse response, String userName, Set<String> facets) throws BadInputException, DeviceCompromisedException {
        String userInum = this.userService.getUserInum(userName);
        if (StringHelper.isEmpty((String)userInum)) {
            throw new BadInputException(String.format("Failed to find user '%s' in LDAP", userName));
        }
        List<DeviceRegistration> deviceRegistrations = this.deviceRegistrationService.findUserDeviceRegistrations(userInum, requestMessage.getAppId(), new String[0]);
        AuthenticateRequest request = this.getAuthenticateRequest(requestMessage, response);
        DeviceRegistration usedDeviceRegistration = null;
        for (DeviceRegistration deviceRegistration : deviceRegistrations) {
            if (!StringHelper.equals((String)request.getKeyHandle(), (String)deviceRegistration.getDeviceRegistrationConfiguration().getKeyHandle())) continue;
            usedDeviceRegistration = deviceRegistration;
            break;
        }
        if (usedDeviceRegistration == null) {
            throw new BadInputException("Failed to find DeviceRegistration for the given AuthenticateRequest");
        }
        if (usedDeviceRegistration.isCompromised()) {
            throw new DeviceCompromisedException(usedDeviceRegistration, "The device is marked as possibly compromised, and cannot be authenticated");
        }
        ClientData clientData = response.getClientData();
        this.clientDataValidationService.checkContent(clientData, "navigator.id.getAssertion", request.getChallenge(), facets);
        RawAuthenticateResponse rawAuthenticateResponse = this.rawAuthenticationService.parseRawAuthenticateResponse(response.getSignatureData());
        this.rawAuthenticationService.checkSignature(request.getAppId(), clientData, rawAuthenticateResponse, Base64Util.base64urldecode((String)usedDeviceRegistration.getDeviceRegistrationConfiguration().getPublicKey()));
        rawAuthenticateResponse.checkUserPresence();
        usedDeviceRegistration.checkAndUpdateCounter(rawAuthenticateResponse.getCounter());
        this.deviceRegistrationService.updateDeviceRegistration(userInum, usedDeviceRegistration);
        return usedDeviceRegistration;
    }

    public AuthenticateRequest getAuthenticateRequest(AuthenticateRequestMessage requestMessage, AuthenticateResponse response) throws BadInputException {
        if (!StringHelper.equals((String)requestMessage.getRequestId(), (String)response.getRequestId())) {
            throw new BadInputException("Wrong request for response data");
        }
        for (AuthenticateRequest request : requestMessage.getAuthenticateRequests()) {
            if (!StringHelper.equals((String)request.getKeyHandle(), (String)response.getKeyHandle())) continue;
            return request;
        }
        throw new BadInputException("Responses keyHandle does not match any contained request");
    }

    public void storeAuthenticationRequestMessage(AuthenticateRequestMessage requestMessage) {
        Date now = new GregorianCalendar(TimeZone.getTimeZone("UTC")).getTime();
        String authenticateRequestMessageId = UUID.randomUUID().toString();
        AuthenticateRequestMessageLdap authenticateRequestMessageLdap = new AuthenticateRequestMessageLdap(requestMessage);
        authenticateRequestMessageLdap.setCreationDate(now);
        authenticateRequestMessageLdap.setId(authenticateRequestMessageId);
        authenticateRequestMessageLdap.setDn(this.getDnForAuthenticateRequestMessage(authenticateRequestMessageId));
        this.ldapEntryManager.persist((Object)authenticateRequestMessageLdap);
    }

    public AuthenticateRequestMessage getAuthenticationRequestMessage(String oxId) {
        String requestDn = this.getDnForAuthenticateRequestMessage(oxId);
        AuthenticateRequestMessageLdap authenticateRequestMessageLdap = (AuthenticateRequestMessageLdap)this.ldapEntryManager.find(AuthenticateRequestMessageLdap.class, (Object)requestDn);
        if (authenticateRequestMessageLdap == null) {
            return null;
        }
        return authenticateRequestMessageLdap.getAuthenticateRequestMessage();
    }

    public AuthenticateRequestMessageLdap getAuthenticationRequestMessageByRequestId(String requestId) {
        Filter requestIdFilter;
        String baseDn = this.getDnForAuthenticateRequestMessage(null);
        List authenticateRequestMessagesLdap = this.ldapEntryManager.findEntries(baseDn, AuthenticateRequestMessageLdap.class, requestIdFilter = Filter.createEqualityFilter((String)"oxRequestId", (String)requestId));
        if (authenticateRequestMessagesLdap == null || authenticateRequestMessagesLdap.isEmpty()) {
            return null;
        }
        return (AuthenticateRequestMessageLdap)authenticateRequestMessagesLdap.get(0);
    }

    public void removeAuthenticationRequestMessage(AuthenticateRequestMessageLdap authenticateRequestMessageLdap) {
        this.removeRequestMessage(authenticateRequestMessageLdap);
    }

    public String getDnForAuthenticateRequestMessage(String oxId) {
        String u2fBaseDn = ConfigurationFactory.getBaseDn().getU2fBase();
        if (StringHelper.isEmpty((String)oxId)) {
            return String.format("ou=authentication_requests,%s", u2fBaseDn);
        }
        return String.format("oxid=%s,ou=authentication_requests,%s", oxId, u2fBaseDn);
    }
}

