/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.Configuration;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.service.BaseAuthFilterService;

@Scope(value=ScopeType.APPLICATION)
@Name(value="clientFilterService")
@AutoCreate
@Startup
public class ClientFilterService
extends BaseAuthFilterService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    @Create
    public void init() {
        Configuration conf = ConfigurationFactory.getConfiguration();
        super.init(conf.getClientAuthenticationFilters(), Boolean.TRUE.equals(conf.getClientAuthenticationFiltersEnabled()), false);
    }

    @Override
    public String processAuthenticationFilter(BaseAuthFilterService.AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<?, ?> attributeValues) {
        if (attributeValues != null) {
            return ClientFilterService.loadEntryDN(this.ldapEntryManager, authenticationFilterWithParameters, ClientFilterService.normalizeAttributeMap(attributeValues));
        }
        return null;
    }

    public String processFilters(String p_clientId) {
        return this.processFilters(p_clientId, "");
    }

    public String processFilters(String p_clientId, String p_clientSecret) {
        try {
            Map<String, String> map = ClientFilterService.createMap(p_clientId, p_clientSecret);
            List<BaseAuthFilterService.AuthenticationFilterWithParameters> filters = this.getFilterWithParameters();
            if (filters != null && !filters.isEmpty()) {
                for (BaseAuthFilterService.AuthenticationFilterWithParameters p : filters) {
                    List<String> variableNames = p.getVariableNames();
                    if (variableNames == null || variableNames.isEmpty()) continue;
                    for (String variable : variableNames) {
                        map.put(variable, p_clientId);
                    }
                }
            }
            return this.processAuthenticationFilters(map);
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return "";
        }
    }

    public static Map<String, String> createMap(String p_clientId, String p_clientSecret) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)p_clientId)) {
            result.put("client_id", p_clientId);
        }
        if (StringUtils.isNotBlank((String)p_clientSecret)) {
            result.put("client_secret", p_clientSecret);
        }
        return result;
    }

    public static ClientFilterService instance() {
        return (ClientFilterService)Component.getInstance(ClientFilterService.class);
    }
}

