/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.AuthenticationException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.Configuration;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.service.BaseAuthFilterService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="authenticationFilterService")
@AutoCreate
@Startup
public class AuthenticationFilterService
extends BaseAuthFilterService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    @Create
    public void init() {
        Configuration conf = ConfigurationFactory.getConfiguration();
        super.init(conf.getAuthenticationFilters(), Boolean.TRUE.equals(conf.getAuthenticationFiltersEnabled()), true);
    }

    @Override
    public String processAuthenticationFilter(BaseAuthFilterService.AuthenticationFilterWithParameters authenticationFilterWithParameters, Map<?, ?> attributeValues) {
        if (attributeValues == null) {
            return null;
        }
        Map<String, String> normalizedAttributeValues = AuthenticationFilterService.normalizeAttributeMap(attributeValues);
        String resultDn = AuthenticationFilterService.loadEntryDN(this.ldapEntryManager, authenticationFilterWithParameters, normalizedAttributeValues);
        if (StringUtils.isBlank((String)resultDn)) {
            return null;
        }
        if (!Boolean.TRUE.equals(authenticationFilterWithParameters.getAuthenticationFilter().getBind())) {
            return resultDn;
        }
        String bindPasswordAttribute = authenticationFilterWithParameters.getAuthenticationFilter().getBindPasswordAttribute();
        if (StringHelper.isEmpty((String)bindPasswordAttribute)) {
            this.log.error((Object)"Skipping authentication filter:\n '{0}'\n. It should contains not empty bind-password-attribute attribute. ", new Object[]{authenticationFilterWithParameters.getAuthenticationFilter()});
            return null;
        }
        bindPasswordAttribute = StringHelper.toLowerCase((String)bindPasswordAttribute);
        try {
            boolean authenticated = this.ldapEntryManager.authenticate(resultDn, normalizedAttributeValues.get(bindPasswordAttribute));
            if (authenticated) {
                return resultDn;
            }
        }
        catch (AuthenticationException ex) {
            this.log.error((Object)"Invalid password", (Throwable)ex, new Object[0]);
        }
        return null;
    }

    public static AuthenticationFilterService instance() {
        return (AuthenticationFilterService)Component.getInstance(AuthenticationFilterService.class);
    }
}

