/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.List;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.appliance.GluuAppliance;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.STATELESS)
@Name(value="applianceService")
@AutoCreate
public class ApplianceService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public void addAppliance(GluuAppliance appliance) {
        this.ldapEntryManager.persist((Object)appliance);
    }

    public void updateAppliance(GluuAppliance appliance) {
        this.ldapEntryManager.merge((Object)appliance);
    }

    public boolean containsAppliance(GluuAppliance appliance) {
        return this.ldapEntryManager.contains((Object)appliance);
    }

    public GluuAppliance getApplianceByInum(String inum) {
        return (GluuAppliance)this.ldapEntryManager.find(GluuAppliance.class, (Object)this.getDnForAppliance(inum));
    }

    public GluuAppliance getAppliance() {
        String applianceInum = this.getApplianceInum();
        if (StringHelper.isEmpty((String)applianceInum)) {
            return null;
        }
        return (GluuAppliance)this.ldapEntryManager.find(GluuAppliance.class, (Object)this.getDnForAppliance(this.getApplianceInum()));
    }

    public List<GluuAppliance> getAppliances() {
        List applianceList = this.ldapEntryManager.findEntries(this.getDnForAppliance(null), GluuAppliance.class, null);
        return applianceList;
    }

    public String getDnForAppliance(String inum) {
        String baseDn = ConfigurationFactory.getBaseDn().getAppliance();
        if (StringHelper.isEmpty((String)inum)) {
            return baseDn;
        }
        return String.format("inum=%s,%s", inum, baseDn);
    }

    public String getDnForAppliance() {
        return this.getDnForAppliance(this.getApplianceInum());
    }

    public String getApplianceInum() {
        return ConfigurationFactory.getConfiguration().getApplianceInum();
    }

    public static ApplianceService instance() {
        return (ApplianceService)Component.getInstance(ApplianceService.class);
    }
}

