/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.token;

import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jws.JwsValidator;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.jwt.JwtType;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.token.ClientAssertionType;
import org.xdi.oxauth.service.ClientService;
import org.xdi.util.security.StringEncrypter;

public class ClientAssertion {
    private Jwt jwt;
    private String clientSecret;

    public ClientAssertion(String clientId, ClientAssertionType clientAssertionType, String encodedAssertion) throws InvalidJwtException {
        try {
            if (!this.load(clientId, clientAssertionType, encodedAssertion)) {
                throw new InvalidJwtException("Cannot load the JWT");
            }
        }
        catch (StringEncrypter.EncryptionException e) {
            throw new InvalidJwtException(e.getMessage(), (Throwable)e);
        }
    }

    public String getSubjectIdentifier() {
        return this.jwt.getClaims().getClaimAsString("sub");
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean load(String clientId, ClientAssertionType clientAssertionType, String encodedAssertion) throws InvalidJwtException, StringEncrypter.EncryptionException {
        boolean result = false;
        if (clientAssertionType != ClientAssertionType.JWT_BEARER) throw new InvalidJwtException("Invalid Client Assertion Type");
        if (!StringUtils.isNotBlank((String)encodedAssertion)) throw new InvalidJwtException("The Client Assertion is null or empty");
        this.jwt = Jwt.parse((String)encodedAssertion);
        String issuer = this.jwt.getClaims().getClaimAsString("iss");
        String subject = this.jwt.getClaims().getClaimAsString("sub");
        List audience = this.jwt.getClaims().getClaimAsStringList("aud");
        Date expirationTime = this.jwt.getClaims().getClaimAsDate("exp");
        if (!(clientId == null && StringUtils.isNotBlank((String)issuer) && StringUtils.isNotBlank((String)subject) && issuer.equals(subject))) {
            if (!StringUtils.isNotBlank((String)clientId)) throw new InvalidJwtException("Invalid clientId");
            if (!StringUtils.isNotBlank((String)issuer)) throw new InvalidJwtException("Invalid clientId");
            if (!StringUtils.isNotBlank((String)subject)) throw new InvalidJwtException("Invalid clientId");
            if (!clientId.equals(issuer)) throw new InvalidJwtException("Invalid clientId");
            if (!issuer.equals(subject)) throw new InvalidJwtException("Invalid clientId");
        }
        String tokenUrl = ConfigurationFactory.getConfiguration().getTokenEndpoint();
        if (audience == null) throw new InvalidJwtException("Invalid audience");
        if (!audience.contains(tokenUrl)) throw new InvalidJwtException("Invalid audience");
        if (!expirationTime.after(new Date())) throw new InvalidJwtException("JWT has expired");
        ClientService clientService = (ClientService)Component.getInstance(ClientService.class);
        Client client = clientService.getClient(subject);
        if (client == null) throw new InvalidJwtException("Invalid client");
        JwtType jwtType = JwtType.fromString((String)this.jwt.getHeader().getClaimAsString("typ"));
        AuthenticationMethod authenticationMethod = client.getAuthenticationMethod();
        SignatureAlgorithm signatureAlgorithm = this.jwt.getHeader().getAlgorithm();
        if (jwtType == null && signatureAlgorithm != null) {
            jwtType = signatureAlgorithm.getJwtType();
        }
        if (jwtType != JwtType.JWS) throw new InvalidJwtException("Invalid authentication method");
        if (signatureAlgorithm == null) throw new InvalidJwtException("Invalid authentication method");
        if (signatureAlgorithm.getFamily() == null) throw new InvalidJwtException("Invalid authentication method");
        if (authenticationMethod != AuthenticationMethod.CLIENT_SECRET_JWT || !signatureAlgorithm.getFamily().equals("HMAC")) {
            if (authenticationMethod != AuthenticationMethod.PRIVATE_KEY_JWT) throw new InvalidJwtException("Invalid authentication method");
            if (!signatureAlgorithm.getFamily().equals("RSA")) {
                if (!signatureAlgorithm.getFamily().equals("EC")) throw new InvalidJwtException("Invalid authentication method");
            }
        }
        this.clientSecret = client.getClientSecret();
        JwsValidator jwtValidator = new JwsValidator(this.jwt, this.clientSecret, client.getJwksUri(), client.getJwks());
        if (!jwtValidator.validateSignature()) throw new InvalidJwtException("Invalid cryptographic segment");
        return true;
    }
}

