/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.registration;

import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.util.Util;

public class RegisterParamsValidator {
    private static final Log LOG = Logging.getLog(RegisterParamsValidator.class);
    private static final String HTTP = "http";
    private static final String HTTPS = "https";
    private static final String LOCALHOST = "localhost";

    public static boolean validateParamsClientRegister(ApplicationType applicationType, List<String> redirectUris, String sectorIdentifierUrl) {
        boolean validParams;
        boolean bl = validParams = applicationType != null && redirectUris != null && !redirectUris.isEmpty();
        if (validParams && StringUtils.isNotBlank((String)sectorIdentifierUrl)) {
            try {
                URI uri = new URI(sectorIdentifierUrl);
                if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                    return false;
                }
                ClientRequest clientRequest = new ClientRequest(sectorIdentifierUrl);
                clientRequest.setHttpMethod("GET");
                ClientResponse clientResponse = clientRequest.get(String.class);
                int status = clientResponse.getStatus();
                if (status == 200) {
                    String entity = (String)clientResponse.getEntity(String.class);
                    JSONArray sectorIdentifierJsonArray = new JSONArray(entity);
                    return Util.asList((JSONArray)sectorIdentifierJsonArray).containsAll(redirectUris);
                }
            }
            catch (URISyntaxException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
            catch (UnknownHostException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
            catch (ConnectException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
            catch (JSONException e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
            catch (Exception e) {
                LOG.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return false;
            }
        }
        return validParams;
    }

    public static boolean validateParamsClientRead(String clientId, String accessToken) {
        return StringUtils.isNotBlank((String)clientId) && StringUtils.isNotBlank((String)accessToken);
    }

    public static boolean validateRedirectUris(ApplicationType applicationType, SubjectType subjectType, List<String> redirectUris, String sectorIdentifierUrl) {
        HashSet<String> redirectUriHosts;
        block11: {
            redirectUriHosts = new HashSet<String>();
            try {
                if (redirectUris != null && !redirectUris.isEmpty()) {
                    for (String redirectUri : redirectUris) {
                        if (redirectUri == null || redirectUri.contains("#")) {
                            return false;
                        }
                        URI uri = new URI(redirectUri);
                        redirectUriHosts.add(uri.getHost());
                        switch (applicationType) {
                            case WEB: {
                                if (!HTTPS.equalsIgnoreCase(uri.getScheme())) {
                                    return false;
                                }
                                if (!LOCALHOST.equalsIgnoreCase(uri.getHost())) break;
                                return false;
                            }
                            case NATIVE: {
                                if (!HTTP.equalsIgnoreCase(uri.getScheme())) {
                                    return false;
                                }
                                if (LOCALHOST.equalsIgnoreCase(uri.getHost())) break;
                                return false;
                            }
                        }
                    }
                    break block11;
                }
                return false;
            }
            catch (URISyntaxException e) {
                return false;
            }
        }
        return subjectType == null || !subjectType.equals((Object)SubjectType.PAIRWISE) || !StringUtils.isBlank((String)sectorIdentifierUrl) || redirectUriHosts.size() <= 1;
    }
}

