/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.persistence.Transient;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapJsonObject;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.xdi.oxauth.model.common.SessionIdAccessMap;
import org.xdi.oxauth.model.common.SessionIdState;

@Name(value="sessionUser")
@AutoCreate
@LdapEntry
@LdapObjectClass(values={"top", "oxAuthSessionId"})
public class SessionId
implements Serializable {
    private static final long serialVersionUID = -237476411915686378L;
    @LdapDN
    private String dn;
    @LdapAttribute(name="uniqueIdentifier")
    private String id;
    @LdapAttribute(name="lastModifiedTime")
    private Date lastUsedAt;
    @LdapAttribute(name="oxAuthUserDN")
    private String userDn;
    @LdapAttribute(name="oxAuthAuthenticationTime")
    private Date authenticationTime;
    @LdapAttribute(name="oxState")
    private SessionIdState state;
    @LdapAttribute(name="oxAuthSessionState")
    private Boolean permissionGranted;
    @LdapJsonObject
    @LdapAttribute(name="oxAuthPermissionGrantedMap")
    private SessionIdAccessMap permissionGrantedMap;
    @LdapJsonObject
    @LdapAttribute(name="oxAuthSessionAttribute")
    private Map<String, String> sessionAttributes;
    @Transient
    private transient boolean persisted;

    public String getDn() {
        return this.dn;
    }

    public void setDn(String p_dn) {
        this.dn = p_dn;
    }

    public SessionIdState getState() {
        return this.state;
    }

    public void setState(SessionIdState state) {
        this.state = state;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String p_id) {
        this.id = p_id;
    }

    public Date getLastUsedAt() {
        return this.lastUsedAt != null ? new Date(this.lastUsedAt.getTime()) : null;
    }

    public void setLastUsedAt(Date p_lastUsedAt) {
        this.lastUsedAt = p_lastUsedAt != null ? new Date(p_lastUsedAt.getTime()) : null;
    }

    public String getUserDn() {
        return this.userDn;
    }

    public void setUserDn(String p_userDn) {
        this.userDn = p_userDn;
    }

    public Date getAuthenticationTime() {
        return this.authenticationTime != null ? new Date(this.authenticationTime.getTime()) : null;
    }

    public void setAuthenticationTime(Date authenticationTime) {
        this.authenticationTime = authenticationTime != null ? new Date(authenticationTime.getTime()) : null;
    }

    public Boolean getPermissionGranted() {
        return this.permissionGranted;
    }

    public void setPermissionGranted(Boolean permissionGranted) {
        this.permissionGranted = permissionGranted;
    }

    public SessionIdAccessMap getPermissionGrantedMap() {
        return this.permissionGrantedMap;
    }

    public void setPermissionGrantedMap(SessionIdAccessMap permissionGrantedMap) {
        this.permissionGrantedMap = permissionGrantedMap;
    }

    public Boolean isPermissionGrantedForClient(String clientId) {
        if (this.permissionGrantedMap != null) {
            return this.permissionGrantedMap.get(clientId);
        }
        return false;
    }

    public void addPermission(String clientId, Boolean granted) {
        if (this.permissionGrantedMap == null) {
            this.permissionGrantedMap = new SessionIdAccessMap();
        }
        this.permissionGrantedMap.put(clientId, granted);
    }

    @Nonnull
    public Map<String, String> getSessionAttributes() {
        if (this.sessionAttributes == null) {
            this.sessionAttributes = Maps.newHashMap();
        }
        return this.sessionAttributes;
    }

    public void setSessionAttributes(Map<String, String> sessionAttributes) {
        this.sessionAttributes = sessionAttributes;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionId id1 = (SessionId)o;
        return !(this.id != null ? !this.id.equals(id1.id) : id1.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SessionId [dn=").append(this.dn).append(", id=").append(this.id).append(", lastUsedAt=").append(this.lastUsedAt).append(", userDn=").append(this.userDn).append(", authenticationTime=").append(this.authenticationTime).append(", state=").append((Object)this.state).append(", permissionGranted=").append(this.permissionGranted).append(", permissionGrantedMap=").append(this.permissionGrantedMap).append(", sessionAttributes=").append(this.sessionAttributes).append("]");
        return builder.toString();
    }
}

