/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.common;

import java.security.SignatureException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import org.xdi.oxauth.model.common.AbstractAuthorizationGrant;
import org.xdi.oxauth.model.common.AccessToken;
import org.xdi.oxauth.model.common.AuthorizationCode;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantType;
import org.xdi.oxauth.model.common.IAuthorizationGrant;
import org.xdi.oxauth.model.common.IdToken;
import org.xdi.oxauth.model.common.RefreshToken;
import org.xdi.oxauth.model.common.TokenIssuerObserver;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.exception.InvalidClaimException;
import org.xdi.oxauth.model.exception.InvalidJweException;
import org.xdi.oxauth.model.exception.InvalidJwtException;
import org.xdi.oxauth.model.jwe.Jwe;
import org.xdi.oxauth.model.jwt.Jwt;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.token.IdTokenFactory;
import org.xdi.util.security.StringEncrypter;

public class AuthorizationGrantInMemory
extends AbstractAuthorizationGrant {
    private TokenIssuerObserver tokenIssuerObserver;
    private AuthorizationGrant parentRef;

    public AuthorizationGrantInMemory(User user, AuthorizationGrantType authorizationGrantType, Client client, Date authenticationTime) {
        super(user, authorizationGrantType, client, authenticationTime);
    }

    @Override
    public AccessToken createAccessToken() {
        AccessToken accessToken = super.createAccessToken();
        this.accessTokens.put(accessToken.getCode(), accessToken);
        if (this.tokenIssuerObserver != null) {
            this.tokenIssuerObserver.indexByAccessToken(accessToken, this.getParentRef());
        }
        return accessToken;
    }

    @Override
    public AccessToken createLongLivedAccessToken() {
        if (this.getLongLivedAccessToken() == null) {
            this.setLongLivedAccessToken(super.createLongLivedAccessToken());
        } else {
            GregorianCalendar currentDate = new GregorianCalendar();
            GregorianCalendar issueDate = new GregorianCalendar();
            issueDate.setTime(this.getLongLivedAccessToken().getCreationDate());
            issueDate.add(10, 24);
            if (issueDate.before(currentDate)) {
                this.setLongLivedAccessToken(super.createLongLivedAccessToken());
            }
        }
        if (this.tokenIssuerObserver != null) {
            this.tokenIssuerObserver.indexByAccessToken(this.getLongLivedAccessToken(), this.getParentRef());
        }
        return this.getLongLivedAccessToken();
    }

    @Override
    public RefreshToken createRefreshToken() {
        for (RefreshToken refToken : this.refreshTokens.values()) {
            refToken.setRevoked(true);
        }
        RefreshToken refreshToken = super.createRefreshToken();
        this.refreshTokens.put(refreshToken.getCode(), refreshToken);
        if (this.tokenIssuerObserver != null) {
            this.tokenIssuerObserver.indexByRefreshToken(refreshToken, this.getParentRef());
        }
        return refreshToken;
    }

    @Override
    public IdToken createIdToken(String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, String authMode) throws SignatureException, StringEncrypter.EncryptionException, InvalidJwtException, InvalidJweException, InvalidClaimException {
        if (this.getIdToken() == null) {
            IdToken idToken = AuthorizationGrantInMemory.createIdToken(this, nonce, authorizationCode, accessToken, this.getScopes());
            this.setIdToken(idToken);
            if (this.tokenIssuerObserver != null) {
                this.tokenIssuerObserver.indexByIdToken(idToken, this.getParentRef());
            }
        }
        return this.getIdToken();
    }

    public static IdToken createIdToken(IAuthorizationGrant p_grant, String nonce, AuthorizationCode authorizationCode, AccessToken accessToken, Set<String> scopes) throws InvalidJweException, SignatureException, StringEncrypter.EncryptionException, InvalidJwtException, InvalidClaimException {
        Client grantClient = p_grant.getClient();
        if (grantClient != null && grantClient.getIdTokenEncryptedResponseAlg() != null && grantClient.getIdTokenEncryptedResponseEnc() != null) {
            Jwe jwe = IdTokenFactory.generateEncryptedIdToken(p_grant, nonce, authorizationCode, accessToken, scopes);
            return new IdToken(jwe.toString(), jwe.getClaims().getClaimAsDate("iat"), jwe.getClaims().getClaimAsDate("exp"));
        }
        Jwt jwt = IdTokenFactory.generateSignedIdToken(p_grant, nonce, authorizationCode, accessToken, scopes);
        return new IdToken(jwt.toString(), jwt.getClaims().getClaimAsDate("iat"), jwt.getClaims().getClaimAsDate("exp"));
    }

    @Override
    public boolean isValid() {
        this.checkExpiredTokens();
        for (AccessToken accessToken : this.accessTokens.values()) {
            if (!accessToken.isValid()) continue;
            return true;
        }
        for (RefreshToken refreshToken : this.refreshTokens.values()) {
            if (!refreshToken.isValid()) continue;
            return true;
        }
        IdToken idToken = this.getIdToken();
        if (idToken != null && idToken.isValid()) {
            return true;
        }
        AccessToken longLivedAccessToken = this.getLongLivedAccessToken();
        return longLivedAccessToken != null && longLivedAccessToken.isValid();
    }

    @Override
    public void revokeAllTokens() {
        for (AccessToken accessToken : this.accessTokens.values()) {
            accessToken.setRevoked(true);
        }
        for (RefreshToken refreshToken : this.refreshTokens.values()) {
            refreshToken.setRevoked(true);
        }
        if (this.getIdToken() != null) {
            this.getIdToken().setRevoked(true);
        }
        if (this.getLongLivedAccessToken() != null) {
            this.getLongLivedAccessToken().setRevoked(true);
        }
    }

    @Override
    public void checkExpiredTokens() {
        for (AccessToken accessToken : this.accessTokens.values()) {
            accessToken.checkExpired();
        }
        for (RefreshToken refreshToken : this.refreshTokens.values()) {
            refreshToken.checkExpired();
        }
        if (this.getIdToken() != null) {
            this.getIdToken().checkExpired();
        }
        if (this.getLongLivedAccessToken() != null) {
            this.getLongLivedAccessToken().checkExpired();
        }
    }

    @Override
    public void save() {
    }

    public void setTokenIssuerObserver(TokenIssuerObserver tokenIssuerObserver) {
        this.tokenIssuerObserver = tokenIssuerObserver;
    }

    public AuthorizationGrant getParentRef() {
        return this.parentRef;
    }

    public void setParentRef(AuthorizationGrant p_parentRef) {
        this.parentRef = p_parentRef;
    }
}

