/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.authorize.ws.rs;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jettison.json.JSONException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.faces.FacesManager;
import org.jboss.seam.international.LocaleSelector;
import org.jboss.seam.log.Log;
import org.jboss.seam.security.Identity;
import org.xdi.model.AuthenticationScriptUsageType;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.oxauth.auth.Authenticator;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.authorize.AuthorizeParamsValidator;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.common.SessionId;
import org.xdi.oxauth.model.common.SessionIdState;
import org.xdi.oxauth.model.common.User;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.util.LocaleUtil;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.service.AcrChangedException;
import org.xdi.oxauth.service.AuthenticationService;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.RedirectionUriService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.UserGroupService;
import org.xdi.oxauth.service.UserService;
import org.xdi.oxauth.service.external.ExternalAuthenticationService;
import org.xdi.util.StringHelper;

@Name(value="authorizeAction")
@org.jboss.seam.annotations.Scope(value=ScopeType.EVENT)
public class AuthorizeAction {
    @Logger
    private Log log;
    @In
    private ClientService clientService;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private UserGroupService userGroupService;
    @In
    private FederationDataService federationDataService;
    @In
    private SessionIdService sessionIdService;
    @In
    private UserService userService;
    @In
    private RedirectionUriService redirectionUriService;
    @In
    private AuthenticationService authenticationService;
    @In
    private ExternalAuthenticationService externalAuthenticationService;
    @In(value="org.jboss.seam.international.localeSelector")
    private LocaleSelector localeSelector;
    @In
    private Identity identity;
    private String scope;
    private String responseType;
    private String clientId;
    private String redirectUri;
    private String state;
    private String nonce;
    private String display;
    private String prompt;
    private Integer maxAge;
    private String uiLocales;
    private String idTokenHint;
    private String loginHint;
    private String acrValues;
    private String amrValues;
    private String request;
    private String requestUri;
    private String sessionId;

    public void checkUiLocales() {
        List uiLocalesList = null;
        if (StringUtils.isNotBlank((String)this.uiLocales)) {
            uiLocalesList = Util.splittedStringAsList((String)this.uiLocales, (String)" ");
            FacesContext facesContext = FacesContext.getCurrentInstance();
            ArrayList supportedLocales = new ArrayList();
            Iterator it = facesContext.getApplication().getSupportedLocales();
            while (it.hasNext()) {
                supportedLocales.add(it.next());
            }
            Locale matchingLocale = LocaleUtil.localeMatch((List)uiLocalesList, supportedLocales);
            if (matchingLocale != null) {
                this.localeSelector.setLocale(matchingLocale);
            }
        }
    }

    public void checkPermissionGranted() {
        Client client;
        SessionId session = this.getSession();
        List prompts = Prompt.fromString((String)this.prompt, (String)" ");
        try {
            session = this.sessionIdService.updateSessionIfNeeded(session, this.redirectUri, this.acrValues);
        }
        catch (AcrChangedException e) {
            this.log.error((Object)"There is already existing session which has another acr then {0}, session: {1}", new Object[]{this.acrValues, session.getId()});
            this.log.error((Object)"Please perform logout in order to be able login with new ACR value.", new Object[0]);
            this.permissionDenied();
        }
        if (session == null || session.getUserDn() == null || SessionIdState.AUTHENTICATED != session.getState()) {
            ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
            Map parameterMap = externalContext.getRequestParameterMap();
            Map<String, String> requestParameterMap = this.authenticationService.getAllowedParameters(parameterMap);
            String redirectTo = "/login.xhtml";
            boolean useExternalAuthenticator = this.externalAuthenticationService.isEnabled(AuthenticationScriptUsageType.INTERACTIVE);
            List<String> acrValuesList = this.acrValuesList();
            if (useExternalAuthenticator && !acrValuesList.isEmpty()) {
                CustomScriptConfiguration customScriptConfiguration = this.externalAuthenticationService.determineCustomScriptConfiguration(AuthenticationScriptUsageType.INTERACTIVE, acrValuesList);
                if (customScriptConfiguration == null) {
                    this.log.error((Object)"Failed to get CustomScriptConfiguration. auth_step: {0}, acr_values: {1}", new Object[]{1, this.acrValues});
                    this.permissionDenied();
                    return;
                }
                String acr = customScriptConfiguration.getName();
                requestParameterMap.put("acr", acr);
                requestParameterMap.put("auth_step", Integer.toString(1));
                String tmpRedirectTo = this.externalAuthenticationService.executeExternalGetPageForStep(customScriptConfiguration, 1);
                if (StringHelper.isNotEmpty((String)tmpRedirectTo)) {
                    this.log.trace((Object)"Redirect to person authentication login page: {0}", new Object[]{tmpRedirectTo});
                    redirectTo = tmpRedirectTo;
                }
            }
            SessionId unauthenticatedSession = this.sessionIdService.generateSessionId(null, new Date(), SessionIdState.UNAUTHENTICATED, requestParameterMap, false);
            unauthenticatedSession.setSessionAttributes(requestParameterMap);
            boolean persisted = this.sessionIdService.persistSessionId(unauthenticatedSession, !prompts.contains(Prompt.NONE));
            if (persisted && this.log.isTraceEnabled()) {
                this.log.trace((Object)"Session '{0}' persisted to LDAP", new Object[]{unauthenticatedSession.getId()});
            }
            this.sessionId = unauthenticatedSession.getId();
            this.sessionIdService.createSessionIdCookie(this.sessionId);
            FacesManager.instance().redirect(redirectTo, null, false);
            return;
        }
        if (this.clientId != null && !this.clientId.isEmpty() && (client = this.clientService.getClient(this.clientId)) != null) {
            if (StringUtils.isBlank((String)this.redirectionUriService.validateRedirectionUri(this.clientId, this.redirectUri))) {
                this.permissionDenied();
            }
            User user = this.userService.getUserByDn(session.getUserDn());
            this.log.trace((Object)("checkPermissionGranted, user = " + user), new Object[0]);
            if (user != null && client.hasUserGroups() && !this.userGroupService.isInAnyGroup(client.getUserGroups(), user.getDn())) {
                this.permissionDenied();
            }
            if (ConfigurationFactory.getConfiguration().getFederationEnabled().booleanValue()) {
                List<FederationTrust> list = this.federationDataService.getTrustByClient(client, FederationTrustStatus.ACTIVE);
                if (list == null || list.isEmpty()) {
                    this.log.trace((Object)"Deny authorization, client is not in any federation trust, client: {0}", new Object[]{client.getDn()});
                    this.permissionDenied();
                } else if (FederationDataService.skipAuthorization(list)) {
                    this.log.trace((Object)"Skip authorization (permissions granted), client is in federation trust where skip is allowed, client: {1}", new Object[]{client.getDn()});
                    this.permissionGranted(session);
                }
            }
            if (AuthorizeParamsValidator.validatePrompt(prompts)) {
                if (ConfigurationFactory.getConfiguration().getTrustedClientEnabled().booleanValue()) {
                    if (Boolean.parseBoolean(client.getTrustedClient()) && !prompts.contains(Prompt.CONSENT)) {
                        this.permissionGranted(session);
                    }
                } else {
                    this.consentRequired();
                }
            } else {
                this.invalidRequest();
            }
        }
    }

    private List<String> acrValuesList() {
        List acrs;
        try {
            acrs = Util.jsonArrayStringAsList((String)this.acrValues);
        }
        catch (JSONException ex) {
            acrs = Util.splittedStringAsList((String)this.acrValues, (String)" ");
        }
        return acrs;
    }

    private SessionId getSession() {
        SessionId ldapSessionId;
        if (StringUtils.isBlank((String)this.sessionId)) {
            this.sessionId = this.sessionIdService.getSessionIdFromCookie();
            if (StringUtils.isBlank((String)this.sessionId)) {
                return null;
            }
        }
        if (!this.identity.isLoggedIn()) {
            Authenticator authenticator = (Authenticator)Component.getInstance(Authenticator.class, (boolean)true);
            authenticator.authenticateBySessionId(this.sessionId);
        }
        if ((ldapSessionId = this.sessionIdService.getSessionId(this.sessionId)) == null) {
            this.identity.logout();
        }
        return ldapSessionId;
    }

    public List<Scope> getScopes() {
        ArrayList<Scope> scopes = new ArrayList<Scope>();
        ScopeService scopeService = ScopeService.instance();
        if (this.scope != null && !this.scope.isEmpty()) {
            String[] scopesName;
            for (String scopeName : scopesName = this.scope.split(" ")) {
                Scope s = scopeService.getScopeByDisplayName(scopeName);
                if (s == null || s.getDescription() == null) continue;
                scopes.add(s);
            }
        }
        return scopes;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public void setResponseType(String responseType) {
        this.responseType = responseType;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public void setRedirectUri(String redirectUri) {
        this.redirectUri = redirectUri;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getDisplay() {
        return this.display;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public Integer getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Integer maxAge) {
        this.maxAge = maxAge;
    }

    public String getUiLocales() {
        return this.uiLocales;
    }

    public void setUiLocales(String uiLocales) {
        this.uiLocales = uiLocales;
    }

    public String getIdTokenHint() {
        return this.idTokenHint;
    }

    public void setIdTokenHint(String idTokenHint) {
        this.idTokenHint = idTokenHint;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public String getAcrValues() {
        return this.acrValues;
    }

    public void setAcrValues(String acrValues) {
        this.acrValues = acrValues;
    }

    public String getAmrValues() {
        return this.amrValues;
    }

    public void setAmrValues(String amrValues) {
        this.amrValues = amrValues;
    }

    public String getRequest() {
        return this.request;
    }

    public void setRequest(String request) {
        this.request = request;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String p_sessionId) {
        this.sessionId = p_sessionId;
    }

    public void permissionGranted() {
        SessionId session = this.getSession();
        this.permissionGranted(session);
    }

    public void permissionGranted(SessionId session) {
        try {
            session.addPermission(this.clientId, true);
            this.sessionIdService.updateSessionId(session);
            SessionIdService.instance().createSessionIdCookie(this.sessionId);
            Map<String, String> sessionAttribute = this.authenticationService.getAllowedParameters(session.getSessionAttributes());
            String parametersAsString = this.authenticationService.parametersAsString(sessionAttribute);
            String uri = "seam/resource/restv1/oxauth/authorize?" + parametersAsString;
            this.log.trace((Object)"permissionGranted, redirectTo: {0}", new Object[]{uri});
            FacesManager.instance().redirectToExternalURL(uri);
        }
        catch (UnsupportedEncodingException e) {
            this.log.trace((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public void permissionDenied() {
        this.log.trace((Object)"permissionDenied", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.ACCESS_DENIED, this.getState()));
        FacesManager.instance().redirectToExternalURL(sb.toString());
    }

    public void invalidRequest() {
        this.log.trace((Object)"invalidRequest", new Object[0]);
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.INVALID_REQUEST, this.getState()));
        FacesManager.instance().redirectToExternalURL(sb.toString());
    }

    public void consentRequired() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.redirectUri);
        if (this.redirectUri != null && this.redirectUri.contains("?")) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(this.errorResponseFactory.getErrorAsQueryString((IErrorType)AuthorizeErrorResponseType.CONSENT_REQUIRED, this.getState()));
        FacesManager.instance().redirectToExternalURL(sb.toString());
    }
}

