/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.util.Arrays;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.client.RegisterResponse;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.SubjectType;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterRequestParam;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.uma.TestUtil;
import org.xdi.oxauth.model.util.StringUtils;
import org.xdi.oxauth.ws.rs.ClientTestUtil;

public class RegistrationRestWebServiceEmbeddedTest
extends BaseTest {
    private String registrationAccessToken1;
    private String registrationClientUri1;

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void requestClientAssociate1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientAssociate1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    RegisterResponse registerResponse = RegisterResponse.valueOf((String)response.getContentAsString());
                    ClientTestUtil.assert_((RegisterResponse)registerResponse);
                    RegistrationRestWebServiceEmbeddedTest.this.registrationAccessToken1 = registerResponse.getRegistrationAccessToken();
                    RegistrationRestWebServiceEmbeddedTest.this.registrationClientUri1 = registerResponse.getRegistrationClientUri();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris", "sectorIdentifierUri", "contactEmail1", "contactEmail2"})
    @Test
    public void requestClientAssociate2(String registerPath, final String redirectUris, final String sectorIdentifierUri, final String contactEmail1, final String contactEmail2) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    List<String> contacts = Arrays.asList(contactEmail1, contactEmail2);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setContacts(contacts);
                    registerRequest.setScopes(Arrays.asList("openid", "clientinfo", "profile", "email", "invalid_scope"));
                    registerRequest.setLogoUri("http://www.gluu.org/wp-content/themes/gluursn/images/logo.png");
                    registerRequest.setClientUri("http://www.gluu.org/company/team");
                    registerRequest.setTokenEndpointAuthMethod(AuthenticationMethod.CLIENT_SECRET_JWT);
                    registerRequest.setPolicyUri("http://www.gluu.org/policy");
                    registerRequest.setJwksUri("http://www.gluu.org/jwks");
                    registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
                    registerRequest.setSubjectType(SubjectType.PAIRWISE);
                    registerRequest.setRequestObjectSigningAlg(SignatureAlgorithm.RS256);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientAssociate2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    RegisterResponse registerResponse = RegisterResponse.valueOf((String)response.getContentAsString());
                    ClientTestUtil.assert_((RegisterResponse)registerResponse);
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.SCOPES.toString()));
                    JSONArray scopesJsonArray = jsonObj.getJSONArray(RegisterRequestParam.SCOPES.toString());
                    Assert.assertEquals((String)scopesJsonArray.getString(0), (String)"openid");
                    Assert.assertEquals((String)scopesJsonArray.getString(1), (String)"clientinfo");
                    Assert.assertEquals((String)scopesJsonArray.getString(2), (String)"profile");
                    Assert.assertEquals((String)scopesJsonArray.getString(3), (String)"email");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath"})
    @Test(dependsOnMethods={"requestClientAssociate1"})
    public void requestClientRead(String registerPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + RegistrationRestWebServiceEmbeddedTest.this.registrationAccessToken1));
                request.setContentType("application/json");
                request.setQueryString(RegistrationRestWebServiceEmbeddedTest.this.registrationClientUri1.substring(RegistrationRestWebServiceEmbeddedTest.this.registrationClientUri1.indexOf("?") + 1));
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientRead", response);
                RegistrationRestWebServiceEmbeddedTest.readResponseAssert(response);
            }
        }.run();
    }

    public static void readResponseAssert(EnhancedMockHttpServletResponse response) {
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
        Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
        try {
            JSONObject jsonObj = new JSONObject(response.getContentAsString());
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.REDIRECT_URIS.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.APPLICATION_TYPE.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.CLIENT_NAME.toString()));
            Assert.assertTrue((boolean)jsonObj.has(RegisterRequestParam.ID_TOKEN_SIGNED_RESPONSE_ALG.toString()));
            Assert.assertTrue((boolean)jsonObj.has("scopes"));
        }
        catch (JSONException e) {
            e.printStackTrace();
            Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
        }
    }

    @Parameters(value={"registerPath", "redirectUris", "contactEmail1", "contactEmail2"})
    @Test(dependsOnMethods={"requestClientAssociate1"})
    public void requestClientUpdate(String registerPath, final String redirectUris, final String contactEmail1, String contactEmail2) throws Exception {
        final String contactEmailNewValue = contactEmail2;
        String logoUriNewValue = "http://www.gluu.org/test/yuriy/logo.png";
        String clientUriNewValue = "http://www.gluu.org/company/yuriy";
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.PUT, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                try {
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.setContacts(Arrays.asList(contactEmail1, contactEmailNewValue));
                    registerRequest.setLogoUri("http://www.gluu.org/test/yuriy/logo.png");
                    registerRequest.setClientUri("http://www.gluu.org/company/yuriy");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.addHeader("Authorization", (Object)("Bearer " + RegistrationRestWebServiceEmbeddedTest.this.registrationAccessToken1));
                    request.setContentType("application/json");
                    request.setQueryString(RegistrationRestWebServiceEmbeddedTest.this.registrationClientUri1.substring(RegistrationRestWebServiceEmbeddedTest.this.registrationClientUri1.indexOf("?") + 1));
                    request.setContent(registerRequestContent.getBytes("UTF-8"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientRead", response);
                RegistrationRestWebServiceEmbeddedTest.readResponseAssert(response);
                try {
                    RegisterRequest r = RegisterRequest.fromJson((String)response.getContentAsString());
                    Assert.assertTrue((r.getContacts() != null && r.getContacts().contains(contactEmailNewValue) ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)r.getClientUri().equals("http://www.gluu.org/company/yuriy"));
                    Assert.assertTrue((boolean)r.getLogoUri().equals("http://www.gluu.org/test/yuriy/logo.png"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath"})
    @Test
    public void requestClientRegistrationFail1(String registerPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(null, null, null);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientRegistrationFail 1", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. " + response.getContentAsString()));
                TestUtil.assertErrorResponse((String)response.getContentAsString());
            }
        }.run();
    }

    @Parameters(value={"registerPath"})
    @Test
    public void requestClientRegistrationFail2(String registerPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", null);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientRegistrationFail 2", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. " + response.getContentAsString()));
                TestUtil.assertErrorResponse((String)response.getContentAsString());
            }
        }.run();
    }

    @Parameters(value={"registerPath"})
    @Test
    public void requestClientRegistrationFail3(String registerPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", Arrays.asList("https://client.example.com/cb#fail_fragment"));
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestClientRegistrationFail3", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. " + response.getContentAsString()));
                TestUtil.assertErrorResponse((String)response.getContentAsString());
            }
        }.run();
    }
}

