/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.util.Arrays;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.uma.ClaimToken;
import org.xdi.oxauth.model.uma.ClaimTokenList;
import org.xdi.oxauth.model.uma.RPTResponse;
import org.xdi.oxauth.model.uma.RegisterPermissionRequest;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.RptAuthorizationResponse;
import org.xdi.oxauth.model.uma.TUma;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class TrustElevationWSTest
extends BaseTest {
    private Token m_pat;
    private Token m_aat;
    private RPTResponse m_rpt;
    private ResourceSetStatus m_resourceSet;
    private ResourceSetPermissionTicket m_ticket;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaAatClientId", "umaAatClientSecret", "umaRedirectUri", "umaRptPath", "umaAmHost", "umaRegisterResourcePath"})
    public void init(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaAatClientId, String umaAatClientSecret, String umaRedirectUri, String umaRptPath, String umaAmHost, String umaRegisterResourcePath) {
        this.m_pat = TUma.requestPat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        this.m_aat = TUma.requestAat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaAatClientId, umaAatClientSecret, umaRedirectUri);
        this.m_rpt = TUma.requestRpt(this, this.m_aat, umaRptPath, umaAmHost);
        UmaTestUtil.assert_((Token)this.m_pat);
        UmaTestUtil.assert_((Token)this.m_aat);
        UmaTestUtil.assert_((RPTResponse)this.m_rpt);
        this.m_resourceSet = TUma.registerResourceSet(this, this.m_pat, umaRegisterResourcePath, UmaTestUtil.createResourceSet());
        UmaTestUtil.assert_((ResourceSetStatus)this.m_resourceSet);
    }

    @Test(dependsOnMethods={"init"})
    @Parameters(value={"umaAmHost", "umaHost", "umaPermissionPath"})
    public void registerPermissionForRpt(String umaAmHost, String umaHost, String umaPermissionPath) throws Exception {
        RegisterPermissionRequest r = new RegisterPermissionRequest();
        r.setResourceSetId(this.m_resourceSet.getId());
        r.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view"));
        this.m_ticket = TUma.registerPermission(this, this.m_pat, umaAmHost, umaHost, r, umaPermissionPath);
        UmaTestUtil.assert_((ResourceSetPermissionTicket)this.m_ticket);
    }

    @Test(dependsOnMethods={"registerPermissionForRpt"})
    @Parameters(value={"umaPermissionAuthorizationPath", "umaAmHost"})
    public void authorizePermission(String umaPermissionAuthorizationPath, String umaAmHost) {
        RptAuthorizationRequest request = new RptAuthorizationRequest();
        request.setRpt(this.m_rpt.getRpt());
        request.setTicket(this.m_ticket.getTicket());
        request.setClaims(new ClaimTokenList().addToken(new ClaimToken("clientClaim", "clientValue")));
        RptAuthorizationResponse response = TUma.requestAuthorization(this, umaPermissionAuthorizationPath, umaAmHost, this.m_aat, request);
        Assert.assertNotNull((Object)response, (String)"Token response status is null");
    }

    @Test(dependsOnMethods={"_7_requesterAccessProtectedResourceWithEnoughPermissionsRpt"})
    @Parameters(value={"umaRegisterResourcePath"})
    public void cleanUp(String umaRegisterResourcePath) {
        if (this.m_resourceSet != null) {
            TUma.deleteResourceSet(this, this.m_pat, umaRegisterResourcePath, this.m_resourceSet.getId());
        }
    }
}

