/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma;

import java.io.IOException;
import java.util.List;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.uma.RPTResponse;
import org.xdi.oxauth.model.uma.RegisterPermissionRequest;
import org.xdi.oxauth.model.uma.ResourceSet;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.RptAuthorizationResponse;
import org.xdi.oxauth.model.uma.RptIntrospectionResponse;
import org.xdi.oxauth.model.uma.TAuthorization;
import org.xdi.oxauth.model.uma.TConfiguration;
import org.xdi.oxauth.model.uma.TRegisterPermission;
import org.xdi.oxauth.model.uma.TRegisterResourceSet;
import org.xdi.oxauth.model.uma.TTokenRequest;
import org.xdi.oxauth.model.uma.UmaConfiguration;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.util.ServerUtil;

public class TUma {
    private TUma() {
    }

    public static Token requestPat(BaseTest p_test, String authorizePath, String tokenPath, String userId, String userSecret, String umaClientId, String umaClientSecret, String umaRedirectUri) {
        TTokenRequest r = new TTokenRequest(p_test);
        return r.pat(authorizePath, tokenPath, userId, userSecret, umaClientId, umaClientSecret, umaRedirectUri);
    }

    public static Token requestAat(BaseTest p_test, String authorizePath, String tokenPath, String userId, String userSecret, String umaClientId, String umaClientSecret, String umaRedirectUri) {
        TTokenRequest r = new TTokenRequest(p_test);
        return r.aat(authorizePath, tokenPath, userId, userSecret, umaClientId, umaClientSecret, umaRedirectUri);
    }

    public static Token newTokenByRefreshToken(BaseTest p_test, String tokenPath, Token p_oldToken, String umaClientId, String umaClientSecret) {
        TTokenRequest r = new TTokenRequest(p_test);
        return r.newTokenByRefreshToken(tokenPath, p_oldToken, umaClientId, umaClientSecret);
    }

    public static RPTResponse requestRpt(BaseTest p_test, Token p_aat, String p_rptPath, String umaAmHost) {
        TTokenRequest r = new TTokenRequest(p_test);
        return r.requestRpt(p_aat, p_rptPath, umaAmHost);
    }

    public static UmaConfiguration requestConfiguration(BaseTest p_test, String configurationPath) {
        TConfiguration c = new TConfiguration(p_test);
        return c.getConfiguration(configurationPath);
    }

    public static ResourceSetStatus registerResourceSet(BaseTest p_test, Token p_pat, String p_umaRegisterResourcePath, ResourceSet p_resourceSet) {
        TRegisterResourceSet s = new TRegisterResourceSet(p_test);
        return s.registerResourceSet(p_pat, p_umaRegisterResourcePath, p_resourceSet);
    }

    public static ResourceSetStatus modifyResourceSet(BaseTest p_test, Token p_pat, String p_umaRegisterResourcePath, String p_rsid, ResourceSet p_resourceSet) {
        TRegisterResourceSet s = new TRegisterResourceSet(p_test);
        return s.modifyResourceSet(p_pat, p_umaRegisterResourcePath, p_rsid, p_resourceSet);
    }

    public static List<String> getResourceSetList(BaseTest p_test, Token p_pat, String p_umaRegisterResourcePath) {
        TRegisterResourceSet s = new TRegisterResourceSet(p_test);
        return s.getResourceSetList(p_pat, p_umaRegisterResourcePath);
    }

    public static void deleteResourceSet(BaseTest p_test, Token p_pat, String p_umaRegisterResourcePath, String p_id) {
        TRegisterResourceSet s = new TRegisterResourceSet(p_test);
        s.deleteResourceSet(p_pat, p_umaRegisterResourcePath, p_id);
    }

    public static ResourceSetPermissionTicket registerPermission(BaseTest p_test, Token p_pat, String p_umaAmHost, String p_umaHost, RegisterPermissionRequest p_request, String p_umaPermissionPath) {
        TRegisterPermission p = new TRegisterPermission(p_test);
        return p.registerPermission(p_pat, p_umaAmHost, p_umaHost, p_request, p_umaPermissionPath);
    }

    public static RptIntrospectionResponse requestRptStatus(BaseTest p_test, String p_umaRptStatusPath, String p_umaAmHost, Token p_aat, String rpt) {
        TTokenRequest r = new TTokenRequest(p_test);
        return r.requestRptStatus(p_umaRptStatusPath, p_umaAmHost, p_aat, rpt);
    }

    public static RptAuthorizationResponse requestAuthorization(BaseTest p_test, String p_umaPermissionAuthorizationPath, String p_umaAmHost, Token p_aat, RptAuthorizationRequest p_request) {
        TAuthorization t = new TAuthorization(p_test);
        return t.requestAuthorization(p_umaPermissionAuthorizationPath, p_umaAmHost, p_aat, p_request);
    }

    public static <T> T readJsonValue(String p_json, Class<T> p_clazz) {
        try {
            return (T)ServerUtil.createJsonMapper().readValue(p_json, p_clazz);
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                System.out.println("TUMA: Exception happends, try falback");
                return (T)ServerUtil.jsonMapperWithUnwrapRoot().readValue(p_json, p_clazz);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
        }
    }
}

