/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma;

import java.io.IOException;
import javax.ws.rs.core.Response;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.common.Holder;
import org.xdi.oxauth.model.uma.RegisterPermissionRequest;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

class TRegisterPermission {
    private final BaseTest m_baseTest;

    public TRegisterPermission(BaseTest p_baseTest) {
        Assert.assertNotNull((Object)((Object)p_baseTest));
        this.m_baseTest = p_baseTest;
    }

    public ResourceSetPermissionTicket registerPermission(final Token p_pat, final String p_umaAmHost, String p_umaHost, final RegisterPermissionRequest p_request, String path) {
        final Holder ticketH = new Holder();
        try {
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.POST, path){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    request.addHeader("Accept", (Object)"application/json");
                    request.addHeader("Authorization", (Object)("Bearer " + p_pat.getAccessToken()));
                    request.addHeader("Host", (Object)p_umaAmHost);
                    try {
                        String json = ServerUtil.createJsonMapper().writeValueAsString((Object)p_request);
                        request.setContent(Util.getBytes((String)json));
                        request.setContentType("application/json");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("UMA : TRegisterPermission.registerPermission() : ", response);
                    Assert.assertEquals((int)response.getStatus(), (int)Response.Status.CREATED.getStatusCode(), (String)"Unexpected response code.");
                    try {
                        ResourceSetPermissionTicket t = (ResourceSetPermissionTicket)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), ResourceSetPermissionTicket.class);
                        UmaTestUtil.assert_((ResourceSetPermissionTicket)t);
                        ticketH.setT((Object)t);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Assert.fail();
                    }
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return (ResourceSetPermissionTicket)ticketH.getT();
    }
}

