/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.Component;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xdi.model.ProgrammingLanguage;
import org.xdi.model.custom.script.CustomScriptType;
import org.xdi.model.custom.script.model.CustomScript;
import org.xdi.oxauth.BaseComponentTest;
import org.xdi.oxauth.comp.InumGeneratorTest;
import org.xdi.oxauth.idgen.ws.rs.IdGenService;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.service.custom.CustomScriptService;
import org.xdi.util.INumGenerator;

public class IdGenServiceTest
extends BaseComponentTest {
    private String idCustomScriptDn;

    private CustomScript buildIdCustomScriptEntry(String idScript) {
        CustomScriptService customScriptService = (CustomScriptService)Component.getInstance(CustomScriptService.class);
        String basedInum = ConfigurationFactory.getConfiguration().getOrganizationInum();
        String customScriptId = basedInum + "!" + INumGenerator.generate((int)2);
        String dn = customScriptService.buildDn(customScriptId);
        CustomScript customScript = new CustomScript();
        customScript.setDn(dn);
        customScript.setInum(customScriptId);
        customScript.setProgrammingLanguage(ProgrammingLanguage.PYTHON);
        customScript.setScriptType(CustomScriptType.ID_GENERATOR);
        customScript.setScript(idScript);
        customScript.setName("test_id");
        customScript.setLevel(0);
        customScript.setEnabled(true);
        customScript.setRevision(1);
        return customScript;
    }

    @Override
    public void beforeClass() {
        InputStream inputStream = InumGeneratorTest.class.getResourceAsStream("/id/gen/SampleIdGenerator.py");
        try {
            String idScript = IOUtils.toString((InputStream)inputStream);
            CustomScript idCustomScript = this.buildIdCustomScriptEntry(idScript);
            this.idCustomScriptDn = idCustomScript.getDn();
            this.getLdapManager().persist((Object)idCustomScript);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    public void afterClass() {
        CustomScript customScript = new CustomScript();
        customScript.setDn(this.idCustomScriptDn);
        this.getLdapManager().remove((Object)customScript);
    }

    @Test
    public void testCustomIdGenerationByPythonScript() {
        IdGenService instance = IdGenService.instance();
        String uuid = instance.generateId("test", "");
        System.out.println("Generated Id: " + uuid);
        Assert.assertFalse((boolean)StringUtils.isNotBlank((String)uuid));
        String invalidUuid = instance.generateId("", "");
        System.out.println("Generated invalid Id: " + invalidUuid);
        Assert.assertFalse((boolean)StringUtils.equalsIgnoreCase((String)invalidUuid, (String)"invalid"));
    }
}

