/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.ResourceSetPermissionRequest;
import org.xdi.oxauth.model.uma.RptStatusRequest;
import org.xdi.oxauth.model.uma.RptStatusResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.uma.ws.rs.RptStatusRestWebService;
import org.xdi.oxauth.util.ServerUtil;

@Name(value="rptStatusRestWebService")
public class RptStatusRestWebServiceImpl
implements RptStatusRestWebService {
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RPTManager rptManager;
    @In
    private UmaValidationService umaValidationService;
    @In
    private ScopeService umaScopeService;

    @Override
    public Response requestRptStatus(String authorization, RptStatusRequest tokenStatusRequest) {
        try {
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            UmaRPT rpt = this.rptManager.getRPTByCode(tokenStatusRequest.getRpt());
            if (!this.isValid(rpt)) {
                return Response.status((Response.Status)Response.Status.OK).entity((Object)new RptStatusResponse(false)).cacheControl(ServerUtil.cacheControl(true)).build();
            }
            List<ResourceSetPermissionRequest> permissions = this.buildStatusResponsePermissions(rpt);
            RptStatusResponse statusResponse = new RptStatusResponse();
            statusResponse.setActive(true);
            statusResponse.setExpiresAt(rpt.getExpirationDate());
            statusResponse.setIssuedAt(rpt.getCreationDate());
            statusResponse.setPermissions(permissions);
            String entity = ServerUtil.asJson(statusResponse);
            return Response.status((Response.Status)Response.Status.OK).entity((Object)entity).cacheControl(ServerUtil.cacheControl(true)).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private boolean isValid(UmaRPT p_rpt) {
        if (p_rpt != null) {
            p_rpt.checkExpired();
            return p_rpt.isValid();
        }
        return false;
    }

    private boolean isValid(ResourceSetPermission resourceSetPermission) {
        if (resourceSetPermission != null) {
            resourceSetPermission.checkExpired();
            return resourceSetPermission.isValid();
        }
        return false;
    }

    private List<ResourceSetPermissionRequest> buildStatusResponsePermissions(UmaRPT p_rpt) {
        List<ResourceSetPermission> rptPermissions;
        ArrayList<ResourceSetPermissionRequest> result = new ArrayList<ResourceSetPermissionRequest>();
        if (p_rpt != null && (rptPermissions = this.rptManager.getRptPermissions(p_rpt)) != null && !rptPermissions.isEmpty()) {
            for (ResourceSetPermission permission : rptPermissions) {
                if (this.isValid(permission)) {
                    ResourceSetPermissionRequest toAdd = ServerUtil.convert(permission, this.umaScopeService);
                    if (toAdd == null) continue;
                    result.add(toAdd);
                    continue;
                }
                this.log.debug((Object)"Ignore permission, skip it in response because permission is not valid. Permission dn: {0}, rpt dn: {1}", new Object[]{permission.getDn(), p_rpt.getDn()});
            }
        }
        return result;
    }
}

