/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.io.IOException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AbstractToken;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.RequesterPermissionTokenResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.uma.ws.rs.RptRestWebService;
import org.xdi.oxauth.util.ServerUtil;

@Name(value="rptRestWebService")
public class RptRestWebServiceImpl
implements RptRestWebService {
    @Logger
    private Log log;
    @In
    private TokenService tokenService;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private RPTManager rptManager;
    @In
    private UmaValidationService umaValidationService;

    @Override
    public Response getRequesterPermissionToken(String authorization, String amHost) {
        try {
            this.umaValidationService.validateAuthorizationWithAuthScope(authorization);
            String validatedAmHost = this.umaValidationService.validateAmHost(amHost);
            return this.getPermissionTokenImpl(authorization, validatedAmHost);
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private Response getPermissionTokenImpl(String authorization, String amHost) throws IOException {
        String aatToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(aatToken);
        AbstractToken accessToken = authorizationGrant.getAccessToken(aatToken);
        UmaRPT requesterPermissionToken = this.rptManager.createRPT(accessToken, authorizationGrant.getUserId(), authorizationGrant.getClientId(), amHost);
        this.rptManager.addRPT(requesterPermissionToken, authorizationGrant.getClientDn());
        String entity = ServerUtil.asJson(new RequesterPermissionTokenResponse(requesterPermissionToken.getCode()));
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.CREATED);
        builder.entity((Object)entity);
        return builder.build();
    }
}

