/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.federation.FederationTrust;
import org.xdi.oxauth.model.federation.FederationTrustStatus;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.model.uma.AuthorizationResponse;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.FederationDataService;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManager;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.service.uma.authorization.AuthorizationService;
import org.xdi.oxauth.uma.ws.rs.RptPermissionAuthorizationRestWebService;
import org.xdi.oxauth.util.ServerUtil;

@Name(value="rptPermissionAuthorizationRestWebService")
public class RptPermissionAuthorizationRestWebServiceImpl
implements RptPermissionAuthorizationRestWebService {
    @Logger
    private Log log;
    @In
    private TokenService tokenService;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private RPTManager rptManager;
    @In
    private ResourceSetPermissionManager resourceSetPermissionManager;
    @In
    private UmaValidationService umaValidationService;
    @In
    private AuthorizationService umaAuthorizationService;
    @In
    private FederationDataService federationDataService;
    @In
    private ClientService clientService;

    @Override
    public Response requestRptPermissionAuthorization(String authorization, String amHost, RptAuthorizationRequest rptAuthorizationRequest, HttpServletRequest httpRequest) {
        try {
            this.umaValidationService.validateAuthorizationWithAuthScope(authorization);
            String validatedAmHost = this.umaValidationService.validateAmHost(amHost);
            AuthorizationGrant authorizationGrant = this.tokenService.getAuthorizationGrant(authorization);
            this.authorizeRptPermission(authorizationGrant, validatedAmHost, rptAuthorizationRequest, httpRequest);
            String entity = ServerUtil.asJson(new AuthorizationResponse(Response.Status.OK.getReasonPhrase()));
            return Response.ok((Object)entity).build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)((Object)ex);
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private ResourceSetPermission authorizeRptPermission(AuthorizationGrant authorizationGrant, String amHost, RptAuthorizationRequest rptAuthorizationRequest, HttpServletRequest httpRequest) {
        UmaRPT rpt = this.rptManager.getRPTByCode(rptAuthorizationRequest.getRpt());
        this.umaValidationService.validateRPT(rpt);
        ResourceSetPermission resourceSetPermission = this.resourceSetPermissionManager.getResourceSetPermissionByTicket(rptAuthorizationRequest.getTicket());
        this.umaValidationService.validateResourceSetPermission(resourceSetPermission);
        Boolean federationEnabled = ConfigurationFactory.getConfiguration().getFederationEnabled();
        if (federationEnabled != null && federationEnabled.booleanValue()) {
            Client client = this.clientService.getClient(rpt.getClientId());
            List<FederationTrust> trustList = this.federationDataService.getTrustByClient(client, FederationTrustStatus.ACTIVE);
            if (trustList != null && !trustList.isEmpty()) {
                for (FederationTrust t : trustList) {
                    Boolean skipAuthorization = t.getSkipAuthorization();
                    if (skipAuthorization == null || !skipAuthorization.booleanValue()) continue;
                    this.log.trace((Object)"grant access directly, client is in trust and skipAuthorization=true", new Object[0]);
                    this.rptManager.addPermissionToRPT(rpt, resourceSetPermission);
                    return resourceSetPermission;
                }
            } else {
                this.log.trace((Object)"Forbid RPT authorization - client is not in any trust however federation is enabled on server.", new Object[0]);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_AUTHORIZED_PERMISSION)).build());
            }
        }
        if (this.umaAuthorizationService.allowToAddPermission(authorizationGrant, rpt, resourceSetPermission, httpRequest, rptAuthorizationRequest)) {
            this.rptManager.addPermissionToRPT(rpt, resourceSetPermission);
            return resourceSetPermission;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_AUTHORIZED_PERMISSION)).build());
    }
}

