/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.config.Configuration;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.MetadataConfiguration;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.uma.ws.rs.MetaDataConfigurationRestWebService;
import org.xdi.oxauth.util.ServerUtil;

@Name(value="umaMetaDataConfigurationRestWebService")
public class MetaDataConfigurationRestWebServiceImpl
implements MetaDataConfigurationRestWebService {
    public static final String UMA_SCOPES_SUFFIX = "/uma/scopes";
    @Logger
    private Log log;
    @In
    private ErrorResponseFactory errorResponseFactory;

    @Override
    public Response getMetadataConfiguration() {
        try {
            Configuration configuration = ConfigurationFactory.getConfiguration();
            String baseEndpointUri = configuration.getBaseEndpoint();
            MetadataConfiguration c = new MetadataConfiguration();
            c.setVersion("1.0");
            c.setIssuer(configuration.getIssuer());
            c.setPatProfilesSupported(new String[]{"bearer"});
            c.setAatProfilesSupported(new String[]{"bearer"});
            c.setRptProfilesSupported(new String[]{"bearer"});
            c.setPatGrantTypesSupported(new String[]{"authorization_code"});
            c.setAatGrantTypesSupported(new String[]{"authorization_code"});
            c.setClaimProfilesSupported(new String[]{"openid"});
            c.setDynamicClientEndpoint(baseEndpointUri + "/oxauth/register");
            c.setTokenEndpoint(baseEndpointUri + "/oxauth/token");
            c.setUserEndpoint(baseEndpointUri + "/oxauth/authorize");
            c.setIntrospectionEndpoint(baseEndpointUri + "/host/status");
            c.setResourceSetRegistrationEndpoint(baseEndpointUri + "/host/rsrc/resource_set");
            c.setPermissionRegistrationEndpoint(baseEndpointUri + "/host/rsrc_pr");
            c.setRptEndpoint(baseEndpointUri + "/requester/rpt");
            c.setAuthorizationRequestEndpoint(baseEndpointUri + "/requester/perm");
            c.setScopeEndpoint(baseEndpointUri + UMA_SCOPES_SUFFIX);
            String entity = ServerUtil.asJson(c);
            this.log.trace((Object)"Uma configuration: {0}", new Object[]{entity});
            return Response.ok((Object)entity).build();
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }
}

