/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma.resourceserver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.uma.persistence.ResourceSet;
import org.xdi.oxauth.model.uma.persistence.ScopeDescription;
import org.xdi.oxauth.service.uma.ResourceSetService;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.oxauth.service.uma.resourceserver.RsResourceType;
import org.xdi.oxauth.service.uma.resourceserver.RsScopeType;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.STATELESS)
@Name(value="umaRsResourceService")
@AutoCreate
public class RsResourceService {
    @Logger
    private Log log;
    @In
    private ResourceSetService resourceSetService;
    @In
    private ScopeService umaScopeService;

    public static RsResourceService instance() {
        return (RsResourceService)ServerUtil.instance(RsResourceService.class);
    }

    public ResourceSet getResource(RsResourceType p_type) {
        ResourceSet criteria = new ResourceSet();
        criteria.setDn(this.resourceSetService.getBaseDnForResourceSet());
        criteria.setName(p_type.getValue());
        List<ResourceSet> ldapResourceSets = this.resourceSetService.findResourceSets(criteria);
        if (ldapResourceSets == null || ldapResourceSets.isEmpty()) {
            this.log.trace((Object)"No resource set for type: {0}", new Object[]{p_type});
            return this.createResourceSet(p_type);
        }
        int size = ldapResourceSets.size();
        ResourceSet first = ldapResourceSets.get(0);
        if (size > 1) {
            for (int i = 1; i < size; ++i) {
                this.resourceSetService.removeResourceSet(ldapResourceSets.get(i));
            }
        }
        return first;
    }

    public List<String> getScopeDns(RsScopeType ... p_types) {
        return p_types != null ? this.getScopeDns(Arrays.asList(p_types)) : new ArrayList();
    }

    public List<String> getScopeDns(List<RsScopeType> p_types) {
        ArrayList<String> result = new ArrayList<String>();
        if (p_types != null) {
            for (RsScopeType t : p_types) {
                ScopeDescription generateIdScope = this.umaScopeService.getInternalScope(t.getValue());
                if (generateIdScope == null) continue;
                result.add(generateIdScope.getDn());
            }
        }
        return result;
    }

    private ResourceSet createResourceSet(RsResourceType p_type) {
        this.log.trace((Object)"Creating new internal resource set, type: {0} ...", new Object[]{p_type});
        if (!this.resourceSetService.containsBranch()) {
            this.resourceSetService.addBranch();
        }
        String rsid = String.valueOf(System.currentTimeMillis());
        ResourceSet s = new ResourceSet();
        s.setId(rsid);
        s.setRev("1");
        s.setName(p_type.getValue());
        s.setDn(this.resourceSetService.getDnForResourceSet(rsid));
        s.setScopes(this.getScopeDns(p_type.getScopeTypes()));
        this.resourceSetService.addResourceSet(s);
        this.log.trace((Object)"New internal resource set created, type: {0}.", new Object[]{p_type});
        return s;
    }
}

