/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma.authorization;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.model.custom.script.conf.CustomScriptConfiguration;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.UnmodifiableAuthorizationGrant;
import org.xdi.oxauth.model.common.uma.UmaRPT;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.persistence.ResourceSetPermission;
import org.xdi.oxauth.model.uma.persistence.ScopeDescription;
import org.xdi.oxauth.service.external.ExternalUmaAuthorizationPolicyService;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.oxauth.service.uma.authorization.AuthorizationContext;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.STATELESS)
@Name(value="umaAuthorizationService")
@AutoCreate
public class AuthorizationService {
    @Logger
    private Log log;
    @In
    private ScopeService umaScopeService;
    @In
    private ExternalUmaAuthorizationPolicyService externalUmaAuthorizationPolicyService;

    public boolean allowToAddPermission(AuthorizationGrant p_grant, UmaRPT p_rpt, ResourceSetPermission p_permission, HttpServletRequest httpRequest, RptAuthorizationRequest rptAuthorizationRequest) {
        this.log.trace((Object)"Check policies for permission, id: '{0}'", new Object[]{p_permission.getDn()});
        List<ScopeDescription> scopes = this.umaScopeService.getScopesByDns(p_permission.getScopeDns());
        Set<String> authorizationPolicies = this.getAuthorizationPolicies(scopes);
        if (authorizationPolicies == null || authorizationPolicies.isEmpty()) {
            this.log.trace((Object)"No policies protection, allowed to grant permission.", new Object[0]);
            return true;
        }
        UnmodifiableAuthorizationGrant unmodifiableAuthorizationGrant = new UnmodifiableAuthorizationGrant(p_grant);
        AuthorizationContext context = new AuthorizationContext(p_rpt, p_permission, unmodifiableAuthorizationGrant, httpRequest, rptAuthorizationRequest.getClaims());
        for (String authorizationPolicy : authorizationPolicies) {
            if (this.applyPolicy(authorizationPolicy, context)) continue;
            this.log.trace((Object)"Reject access. Policy dn: '{0}'", new Object[]{authorizationPolicy});
            return false;
        }
        this.log.trace((Object)"All policies are ok, grant access.", new Object[0]);
        return true;
    }

    private Set<String> getAuthorizationPolicies(List<ScopeDescription> scopes) {
        HashSet<String> result = new HashSet<String>();
        for (ScopeDescription scope : scopes) {
            List authorizationPolicies = scope.getAuthorizationPolicies();
            if (authorizationPolicies == null) continue;
            result.addAll(authorizationPolicies);
        }
        return result;
    }

    private boolean applyPolicy(String authorizationPolicyDn, AuthorizationContext authorizationContext) {
        this.log.trace((Object)"Apply policy dn: '{0}' ...", new Object[]{authorizationPolicyDn});
        CustomScriptConfiguration customScriptConfiguration = this.externalUmaAuthorizationPolicyService.getAuthorizationPolicyByDn(authorizationPolicyDn);
        if (customScriptConfiguration != null) {
            boolean result = this.externalUmaAuthorizationPolicyService.executeExternalAuthorizeMethod(customScriptConfiguration, authorizationContext);
            this.log.trace((Object)"Policy '{0}' result: {1}", new Object[]{authorizationPolicyDn, result});
            return result;
        }
        this.log.error((Object)"Unable to load cusom script dn: '{0}'", new Object[]{authorizationPolicyDn});
        return false;
    }

    public static AuthorizationService instance() {
        return (AuthorizationService)ServerUtil.instance(AuthorizationService.class);
    }
}

