/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.uma;

import com.unboundid.ldap.sdk.Filter;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.hibernate.annotations.common.util.StringHelper;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.ldap.model.SimpleBranch;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.uma.persistence.ResourceSet;

@Scope(value=ScopeType.STATELESS)
@Name(value="resourceSetService")
@AutoCreate
public class ResourceSetService {
    @In
    private LdapEntryManager ldapEntryManager;
    @Logger
    private Log log;

    public void addBranch() {
        SimpleBranch branch = new SimpleBranch();
        branch.setOrganizationalUnitName("uma_resource_sets");
        branch.setDn(this.getDnForResourceSet(null));
        this.ldapEntryManager.persist((Object)branch);
    }

    public void addResourceSet(ResourceSet resourceSet) {
        this.ldapEntryManager.persist((Object)resourceSet);
    }

    public void updateResourceSet(ResourceSet resourceSet) {
        this.ldapEntryManager.merge((Object)resourceSet);
    }

    public void removeResourceSet(ResourceSet resourceSet) {
        this.ldapEntryManager.remove((Object)resourceSet);
    }

    public List<ResourceSet> getAllResourceSets(String ... ldapReturnAttributes) {
        return this.ldapEntryManager.findEntries(this.getBaseDnForResourceSet(), ResourceSet.class, ldapReturnAttributes, null);
    }

    public List<ResourceSet> getResourceSetsByAssociatedClient(String p_associatedClientDn) {
        try {
            if (StringUtils.isNotBlank((String)p_associatedClientDn)) {
                Filter filter = Filter.create((String)String.format("&(oxAssociatedClient=%s)", p_associatedClientDn));
                return this.ldapEntryManager.findEntries(this.getBaseDnForResourceSet(), ResourceSet.class, filter);
            }
        }
        catch (Exception e) {
            this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return Collections.emptyList();
    }

    public List<ResourceSet> findResourceSets(ResourceSet resourceSet) {
        return this.ldapEntryManager.findEntries((Object)resourceSet);
    }

    public boolean containsBranch() {
        return this.ldapEntryManager.contains(SimpleBranch.class, this.getDnForResourceSet(null));
    }

    public boolean containsResourceSet(ResourceSet resourceSet) {
        return this.ldapEntryManager.contains((Object)resourceSet);
    }

    public ResourceSet getResourceSetByDn(String dn) {
        return (ResourceSet)this.ldapEntryManager.find(ResourceSet.class, (Object)dn);
    }

    public String getDnForResourceSet(String oxId) {
        if (StringHelper.isEmpty((String)oxId)) {
            return this.getBaseDnForResourceSet();
        }
        return String.format("oxId=%s,%s", oxId, this.getBaseDnForResourceSet());
    }

    public String getBaseDnForResourceSet() {
        String umaBaseDn = ConfigurationFactory.getBaseDn().getUmaBase();
        return String.format("ou=resource_sets,%s", umaBaseDn);
    }

    public static ResourceSetService instance() {
        return (ResourceSetService)Component.getInstance(ResourceSetService.class);
    }
}

