/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service.token;

import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.common.util.StringHelper;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;

@Scope(value=ScopeType.STATELESS)
@Name(value="tokenService")
@AutoCreate
public class TokenService {
    @In
    private AuthorizationGrantList authorizationGrantList;

    public String getTokenFromAuthorizationParameter(String authorizationParameter) {
        String prefix = "Bearer ";
        if (StringHelper.isNotEmpty((String)authorizationParameter) && authorizationParameter.startsWith("Bearer ")) {
            return authorizationParameter.substring("Bearer ".length());
        }
        return null;
    }

    public AuthorizationGrant getAuthorizationGrant(String p_authorization) {
        String token = this.getTokenFromAuthorizationParameter(p_authorization);
        if (StringUtils.isNotBlank((String)token)) {
            return this.authorizationGrantList.getAuthorizationGrantByAccessToken(token);
        }
        return null;
    }

    public String getClientDn(String p_authorization) {
        AuthorizationGrant grant = this.getAuthorizationGrant(p_authorization);
        if (grant != null) {
            return grant.getClientDn();
        }
        return "";
    }
}

