/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import com.unboundid.ldap.sdk.Filter;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.EntryPersistenceException;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.ldap.UserGroup;

@Scope(value=ScopeType.APPLICATION)
@Name(value="userGroupService")
@AutoCreate
public class UserGroupService {
    @Logger
    private Log log;
    @In
    private LdapEntryManager ldapEntryManager;

    public UserGroup loadGroup(String p_groupDN) {
        try {
            if (StringUtils.isNotBlank((String)p_groupDN)) {
                return (UserGroup)this.ldapEntryManager.find(UserGroup.class, (Object)p_groupDN);
            }
        }
        catch (Exception e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return null;
    }

    public boolean isUserInGroup(String p_groupDN, String p_userDN) {
        String[] member;
        UserGroup group = this.loadGroup(p_groupDN);
        if (group != null && (member = group.getMember()) != null) {
            return Arrays.asList(member).contains(p_userDN);
        }
        return false;
    }

    public boolean isUserInGroupOrMember(String groupDn, String personDn) {
        Filter ownerFilter = Filter.createEqualityFilter((String)"owner", (String)personDn);
        Filter memberFilter = Filter.createEqualityFilter((String)"member", (String)personDn);
        Filter searchFilter = Filter.createORFilter((Filter[])new Filter[]{ownerFilter, memberFilter});
        boolean isMemberOrOwner = false;
        try {
            isMemberOrOwner = this.ldapEntryManager.findEntries(groupDn, UserGroup.class, searchFilter, 1).size() > 0;
        }
        catch (EntryPersistenceException ex) {
            this.log.error((Object)"Failed to determine if person '{0}' memeber or owner of group '{1}'", (Throwable)ex, new Object[]{personDn, groupDn});
        }
        return isMemberOrOwner;
    }

    public boolean isInAnyGroup(String[] p_groupDNs, String p_userDN) {
        return p_groupDNs != null && this.isInAnyGroup(Arrays.asList(p_groupDNs), p_userDN);
    }

    public boolean isInAnyGroup(List<String> p_groupDNs, String p_userDN) {
        if (p_groupDNs != null && !p_groupDNs.isEmpty() && p_userDN != null && !p_userDN.isEmpty()) {
            for (String groupDN : p_groupDNs) {
                if (!this.isUserInGroup(groupDN, p_userDN)) continue;
                return true;
            }
        }
        return false;
    }

    public static UserGroupService instance() {
        return (UserGroupService)Component.getInstance(UserGroupService.class);
    }
}

