/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.registration.Client;
import org.xdi.oxauth.service.ClientService;
import org.xdi.oxauth.service.GrantService;
import org.xdi.oxauth.service.SessionIdService;
import org.xdi.oxauth.service.uma.RPTManager;
import org.xdi.oxauth.service.uma.ResourceSetPermissionManager;

@Name(value="cleanerTimer")
@AutoCreate
@Scope(value=ScopeType.APPLICATION)
public class CleanerTimer {
    private static final String EVENT_TYPE = "CleanerTimerEvent";
    private static final int DEFAULT_INTERVAL = 600;
    @Logger
    private Log log;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ClientService clientService;
    @In
    private GrantService grantService;
    @In
    private RPTManager rptManager;
    @In
    private ResourceSetPermissionManager resourceSetPermissionManager;
    @In
    private SessionIdService sessionIdService;
    private AtomicBoolean isActive;

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void init() {
        this.log.debug((Object)"Initializing CleanerTimer", new Object[0]);
        this.isActive = new AtomicBoolean(false);
        long interval = ConfigurationFactory.getConfiguration().getCleanServiceInterval();
        if (interval <= 0L) {
            interval = 600L;
        }
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(interval *= 1000L), Long.valueOf(interval)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"CleanerTimerEvent"})
    @Asynchronous
    public void process() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.processAuthorizationGrantList();
            this.processRegisteredClients();
            this.sessionIdService.cleanUpSessions();
            Date now = new Date();
            this.rptManager.cleanupRPTs(now);
            this.resourceSetPermissionManager.cleanupResourceSetPermissions(now);
        }
        finally {
            this.isActive.set(false);
        }
    }

    private void processAuthorizationGrantList() {
        this.log.debug((Object)"Start AuthorizationGrant clean up", new Object[0]);
        switch (ConfigurationFactory.getConfiguration().getModeEnum()) {
            case IN_MEMORY: {
                List<AuthorizationGrant> grantList = this.authorizationGrantList.getAuthorizationGrants();
                if (grantList == null || grantList.isEmpty()) break;
                ArrayList<AuthorizationGrant> toRemove = new ArrayList<AuthorizationGrant>();
                for (AuthorizationGrant grant : grantList) {
                    if (grant.isValid()) continue;
                    toRemove.add(grant);
                    this.log.debug((Object)"Removing AuthorizationGrant, Client {0}", new Object[]{grant.getClient().getClientId()});
                }
                this.authorizationGrantList.removeAuthorizationGrants(toRemove);
                break;
            }
            case LDAP: {
                this.grantService.cleanUp();
            }
        }
        this.log.debug((Object)"End AuthorizationGrant clean up", new Object[0]);
    }

    private void processRegisteredClients() {
        this.log.debug((Object)"Start Client clean up", new Object[0]);
        List<Client> clientList = this.clientService.getClientsWithExpirationDate(new String[]{"inum", "oxAuthClientSecretExpiresAt"});
        if (clientList != null && !clientList.isEmpty()) {
            for (Client client : clientList) {
                GregorianCalendar now = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                GregorianCalendar expirationDate = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                expirationDate.setTime(client.getClientSecretExpiresAt());
                if (!expirationDate.before(now)) continue;
                List<AuthorizationGrant> toRemove = this.authorizationGrantList.getAuthorizationGrant(client.getClientId());
                this.authorizationGrantList.removeAuthorizationGrants(toRemove);
                this.log.debug((Object)"Removing Client: {0}, Expiration date: {1}", new Object[]{client.getClientId(), client.getClientSecretExpiresAt()});
                this.clientService.remove(client);
            }
        }
        this.log.debug((Object)"End Client clean up", new Object[0]);
    }
}

