/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.registration;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.codehaus.jettison.json.JSONArray;
import org.gluu.site.ldap.persistence.annotation.LdapAttribute;
import org.gluu.site.ldap.persistence.annotation.LdapAttributesList;
import org.gluu.site.ldap.persistence.annotation.LdapCustomObjectClass;
import org.gluu.site.ldap.persistence.annotation.LdapDN;
import org.gluu.site.ldap.persistence.annotation.LdapEntry;
import org.gluu.site.ldap.persistence.annotation.LdapObjectClass;
import org.xdi.oxauth.model.common.AuthenticationMethod;
import org.xdi.oxauth.model.common.CustomAttribute;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.common.Scope;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.exception.InvalidClaimException;
import org.xdi.oxauth.service.EncryptionService;
import org.xdi.oxauth.service.ScopeService;
import org.xdi.oxauth.util.LdapUtils;
import org.xdi.util.security.StringEncrypter;

@LdapEntry
@LdapObjectClass(values={"top", "oxAuthClient"})
public class Client {
    @LdapDN
    private String dn;
    @LdapAttribute(name="inum")
    private String clientId;
    @LdapAttribute(name="oxAuthClientSecret")
    private String encodedClientSecret;
    @LdapAttribute(name="oxAuthRegistrationAccessToken")
    private String registrationAccessToken;
    @LdapAttribute(name="oxAuthClientIdIssuedAt")
    private Date clientIdIssuedAt;
    @LdapAttribute(name="oxAuthClientSecretExpiresAt")
    private Date clientSecretExpiresAt;
    @LdapAttribute(name="oxAuthRedirectURI")
    private String[] redirectUris;
    @LdapAttribute(name="oxAuthResponseType")
    private ResponseType[] responseTypes;
    @LdapAttribute(name="oxAuthGrantType")
    private String[] grantTypes;
    @LdapAttribute(name="oxAuthAppType")
    private String applicationType;
    @LdapAttribute(name="oxAuthContact")
    private String[] contacts;
    @LdapAttribute(name="displayName")
    private String clientName;
    @LdapAttribute(name="oxAuthLogoURI")
    private String logoUri;
    @LdapAttribute(name="oxAuthClientURI")
    private String clientUri;
    @LdapAttribute(name="oxAuthTokenEndpointAuthMethod")
    private String tokenEndpointAuthMethod;
    @LdapAttribute(name="oxAuthPolicyURI")
    private String policyUri;
    @LdapAttribute(name="oxAuthTosURI")
    private String tosUri;
    @LdapAttribute(name="oxAuthJwksURI")
    private String jwksUri;
    @LdapAttribute(name="oxAuthSectorIdentifierURI")
    private String sectorIdentifierUri;
    @LdapAttribute(name="oxAuthSubjectType")
    private String subjectType;
    @LdapAttribute(name="oxAuthRequestObjectSigningAlg")
    private String requestObjectSigningAlg;
    @LdapAttribute(name="oxAuthSignedResponseAlg")
    private String userInfoSignedResponseAlg;
    @LdapAttribute(name="oxAuthUserInfoEncryptedResponseAlg")
    private String userInfoEncryptedResponseAlg;
    @LdapAttribute(name="oxAuthUserInfoEncryptedResponseEnc")
    private String userInfoEncryptedResponseEnc;
    @LdapAttribute(name="oxAuthIdTokenSignedResponseAlg")
    private String idTokenSignedResponseAlg;
    @LdapAttribute(name="oxAuthIdTokenEncryptedResponseAlg")
    private String idTokenEncryptedResponseAlg;
    @LdapAttribute(name="oxAuthIdTokenEncryptedResponseEnc")
    private String idTokenEncryptedResponseEnc;
    @LdapAttribute(name="oxAuthDefaultMaxAge")
    private Integer defaultMaxAge;
    @LdapAttribute(name="oxAuthRequireAuthTime")
    private Boolean requireAuthTime;
    @LdapAttribute(name="oxAuthDefaultAcrValues")
    private String[] defaultAcrValues;
    @LdapAttribute(name="oxAuthInitiateLoginURI")
    private String initiateLoginUri;
    @LdapAttribute(name="oxAuthPostLogoutRedirectURI")
    private String[] postLogoutRedirectUris;
    @LdapAttribute(name="oxAuthRequestURI")
    private String[] requestUris;
    @LdapAttribute(name="oxAuthScope")
    private String[] scopes;
    @LdapAttribute(name="oxAuthTrustedClient")
    private String trustedClient;
    @LdapAttribute(name="oxAuthClientUserGroup")
    private String[] userGroups;
    @LdapAttribute(name="oxAuthFederationId")
    private String federationId;
    @LdapAttribute(name="oxAuthFederationMetadataURI")
    private String federationURI;
    @LdapAttributesList(name="name", value="values", sortByName=true)
    private List<CustomAttribute> customAttributes = new ArrayList<CustomAttribute>();
    @LdapCustomObjectClass
    private String[] customObjectClasses;

    public AuthenticationMethod getAuthenticationMethod() {
        return AuthenticationMethod.fromString((String)this.tokenEndpointAuthMethod);
    }

    public String getDn() {
        return this.dn;
    }

    public void setDn(String dn) {
        this.dn = dn;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getEncodedClientSecret() {
        return this.encodedClientSecret;
    }

    public void setEncodedClientSecret(String encodedClientSecret) {
        this.encodedClientSecret = encodedClientSecret;
    }

    public String getClientSecret() throws StringEncrypter.EncryptionException {
        return EncryptionService.instance().decrypt(this.encodedClientSecret);
    }

    public void setClientSecret(String clientSecret) throws StringEncrypter.EncryptionException {
        this.encodedClientSecret = EncryptionService.instance().encrypt(clientSecret);
    }

    public String getRegistrationAccessToken() {
        return this.registrationAccessToken;
    }

    public void setRegistrationAccessToken(String registrationAccessToken) {
        this.registrationAccessToken = registrationAccessToken;
    }

    public Date getClientIdIssuedAt() {
        return this.clientIdIssuedAt;
    }

    public void setClientIdIssuedAt(Date clientIdIssuedAt) {
        this.clientIdIssuedAt = clientIdIssuedAt;
    }

    public Date getClientSecretExpiresAt() {
        return this.clientSecretExpiresAt != null ? new Date(this.clientSecretExpiresAt.getTime()) : null;
    }

    public void setClientSecretExpiresAt(Date clientSecretExpiresAt) {
        this.clientSecretExpiresAt = clientSecretExpiresAt != null ? new Date(clientSecretExpiresAt.getTime()) : null;
    }

    public String[] getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(String[] redirectUris) {
        this.redirectUris = redirectUris;
    }

    public ResponseType[] getResponseTypes() {
        return this.responseTypes;
    }

    public void setResponseTypes(ResponseType[] responseTypes) {
        this.responseTypes = responseTypes;
    }

    public String[] getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(String[] grantTypes) {
        this.grantTypes = grantTypes;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String[] getContacts() {
        return this.contacts;
    }

    public void setContacts(String[] contacts) {
        this.contacts = contacts;
    }

    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public String getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(String logoUri) {
        this.logoUri = logoUri;
    }

    public String getClientUri() {
        return this.clientUri;
    }

    public void setClientUri(String clientUri) {
        this.clientUri = clientUri;
    }

    public String getTokenEndpointAuthMethod() {
        return this.tokenEndpointAuthMethod;
    }

    public void setTokenEndpointAuthMethod(String tokenEndpointAuthMethod) {
        this.tokenEndpointAuthMethod = tokenEndpointAuthMethod;
    }

    public String getPolicyUri() {
        return this.policyUri;
    }

    public void setPolicyUri(String policyUri) {
        this.policyUri = policyUri;
    }

    public String getTosUri() {
        return this.tosUri;
    }

    public void setTosUri(String tosUri) {
        this.tosUri = tosUri;
    }

    public String getJwksUri() {
        return this.jwksUri;
    }

    public void setJwksUri(String jwksUri) {
        this.jwksUri = jwksUri;
    }

    public String getSectorIdentifierUri() {
        return this.sectorIdentifierUri;
    }

    public void setSectorIdentifierUri(String sectorIdentifierUri) {
        this.sectorIdentifierUri = sectorIdentifierUri;
    }

    public String getSubjectType() {
        return this.subjectType;
    }

    public void setSubjectType(String subjectType) {
        this.subjectType = subjectType;
    }

    public String getRequestObjectSigningAlg() {
        return this.requestObjectSigningAlg;
    }

    public void setRequestObjectSigningAlg(String requestObjectSigningAlg) {
        this.requestObjectSigningAlg = requestObjectSigningAlg;
    }

    public String getUserInfoSignedResponseAlg() {
        return this.userInfoSignedResponseAlg;
    }

    public void setUserInfoSignedResponseAlg(String userInfoSignedResponseAlg) {
        this.userInfoSignedResponseAlg = userInfoSignedResponseAlg;
    }

    public String getUserInfoEncryptedResponseAlg() {
        return this.userInfoEncryptedResponseAlg;
    }

    public void setUserInfoEncryptedResponseAlg(String userInfoEncryptedResponseAlg) {
        this.userInfoEncryptedResponseAlg = userInfoEncryptedResponseAlg;
    }

    public String getUserInfoEncryptedResponseEnc() {
        return this.userInfoEncryptedResponseEnc;
    }

    public void setUserInfoEncryptedResponseEnc(String userInfoEncryptedResponseEnc) {
        this.userInfoEncryptedResponseEnc = userInfoEncryptedResponseEnc;
    }

    public String getIdTokenSignedResponseAlg() {
        return this.idTokenSignedResponseAlg;
    }

    public void setIdTokenSignedResponseAlg(String idTokenSignedResponseAlg) {
        this.idTokenSignedResponseAlg = idTokenSignedResponseAlg;
    }

    public String getIdTokenEncryptedResponseAlg() {
        return this.idTokenEncryptedResponseAlg;
    }

    public void setIdTokenEncryptedResponseAlg(String idTokenEncryptedResponseAlg) {
        this.idTokenEncryptedResponseAlg = idTokenEncryptedResponseAlg;
    }

    public String getIdTokenEncryptedResponseEnc() {
        return this.idTokenEncryptedResponseEnc;
    }

    public void setIdTokenEncryptedResponseEnc(String idTokenEncryptedResponseEnc) {
        this.idTokenEncryptedResponseEnc = idTokenEncryptedResponseEnc;
    }

    public Integer getDefaultMaxAge() {
        return this.defaultMaxAge;
    }

    public void setDefaultMaxAge(Integer defaultMaxAge) {
        this.defaultMaxAge = defaultMaxAge;
    }

    public Boolean getRequireAuthTime() {
        return this.requireAuthTime;
    }

    public void setRequireAuthTime(Boolean requireAuthTime) {
        this.requireAuthTime = requireAuthTime;
    }

    public String[] getDefaultAcrValues() {
        return this.defaultAcrValues;
    }

    public void setDefaultAcrValues(String[] defaultAcrValues) {
        this.defaultAcrValues = defaultAcrValues;
    }

    public String getInitiateLoginUri() {
        return this.initiateLoginUri;
    }

    public void setInitiateLoginUri(String initiateLoginUri) {
        this.initiateLoginUri = initiateLoginUri;
    }

    public String[] getPostLogoutRedirectUris() {
        return this.postLogoutRedirectUris;
    }

    public void setPostLogoutRedirectUris(String[] postLogoutRedirectUris) {
        this.postLogoutRedirectUris = postLogoutRedirectUris;
    }

    public String[] getRequestUris() {
        return this.requestUris;
    }

    public void setRequestUris(String[] requestUris) {
        this.requestUris = requestUris;
    }

    public String[] getScopes() {
        return this.scopes;
    }

    public void setScopes(String[] scopes) {
        this.scopes = scopes;
    }

    public String getTrustedClient() {
        return this.trustedClient;
    }

    public void setTrustedClient(String trustedClient) {
        this.trustedClient = trustedClient;
    }

    public String[] getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(String[] p_userGroups) {
        if (LdapUtils.isValidDNs(p_userGroups)) {
            this.userGroups = p_userGroups;
        }
    }

    public String getFederationId() {
        return this.federationId;
    }

    public void setFederationId(String p_federationId) {
        this.federationId = p_federationId;
    }

    public String getFederationURI() {
        return this.federationURI;
    }

    public void setFederationURI(String p_federationURI) {
        this.federationURI = p_federationURI;
    }

    public List<CustomAttribute> getCustomAttributes() {
        return this.customAttributes;
    }

    public void setCustomAttributes(List<CustomAttribute> customAttributes) {
        this.customAttributes = customAttributes;
    }

    public String[] getCustomObjectClasses() {
        return this.customObjectClasses;
    }

    public void setCustomObjectClasses(String[] p_customObjectClasses) {
        this.customObjectClasses = p_customObjectClasses;
    }

    public static Client instance() {
        return new Client();
    }

    public static String buildClientDn(String p_clientId) {
        StringBuilder dn = new StringBuilder();
        dn.append(String.format("inum=%s,", p_clientId));
        dn.append(ConfigurationFactory.getBaseDn().getClients());
        return dn.toString();
    }

    public Client setClientIdWithDn(String p_clientId) {
        this.setClientId(p_clientId);
        this.setDn(Client.buildClientDn(p_clientId));
        return this;
    }

    public boolean hasUserGroups() {
        return !ArrayUtils.isEmpty((Object[])this.userGroups);
    }

    public Object getAttribute(String clientAttribute) throws InvalidClaimException {
        String attribute = null;
        ScopeService scopeService = ScopeService.instance();
        if (clientAttribute != null) {
            if (clientAttribute.equals("displayName")) {
                attribute = this.clientName;
            } else if (clientAttribute.equals("inum")) {
                attribute = this.clientId;
            } else if (clientAttribute.equals("oxAuthAppType")) {
                attribute = this.applicationType;
            } else if (clientAttribute.equals("oxAuthIdTokenSignedResponseAlg")) {
                attribute = this.idTokenSignedResponseAlg;
            } else if (clientAttribute.equals("oxAuthRedirectURI") && this.redirectUris != null) {
                JSONArray array = new JSONArray();
                for (String redirectUri : this.redirectUris) {
                    array.put((Object)redirectUri);
                }
                attribute = array;
            } else if (clientAttribute.equals("oxAuthScope") && this.scopes != null) {
                JSONArray array = new JSONArray();
                for (String scopeDN : this.scopes) {
                    Scope s = scopeService.getScopeByDn(scopeDN);
                    if (s == null) continue;
                    String scopeName = s.getDisplayName();
                    array.put((Object)scopeName);
                }
                attribute = array;
            } else {
                for (CustomAttribute customAttribute : this.customAttributes) {
                    if (!customAttribute.getName().equals(clientAttribute)) continue;
                    List<String> values = customAttribute.getValues();
                    if (values == null) break;
                    if (values.size() == 1) {
                        attribute = values.get(0);
                        break;
                    }
                    JSONArray array = new JSONArray();
                    for (String v : values) {
                        array.put((Object)v);
                    }
                    attribute = array;
                    break;
                }
            }
        }
        return attribute;
    }
}

