/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.config;

import java.io.File;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.gluu.site.ldap.persistence.LdapEntryManager;
import org.gluu.site.ldap.persistence.exception.LdapMappingException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.xdi.exception.ConfigurationException;
import org.xdi.oxauth.model.config.BaseDnConfiguration;
import org.xdi.oxauth.model.config.ClaimMappingConfiguration;
import org.xdi.oxauth.model.config.Conf;
import org.xdi.oxauth.model.config.Configuration;
import org.xdi.oxauth.model.config.StaticConf;
import org.xdi.oxauth.model.error.ErrorMessages;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.jwk.JSONWebKeySet;
import org.xdi.oxauth.util.FileConfiguration;
import org.xdi.oxauth.util.ServerUtil;

@Scope(value=ScopeType.APPLICATION)
@Name(value="configurationFactory")
@AutoCreate
public class ConfigurationFactory {
    private static final Log LOG = Logging.getLog(ConfigurationFactory.class);
    private static final String BASE_DIR = System.getProperty("catalina.home") != null ? System.getProperty("catalina.home") : System.getProperty("jboss.home.dir");
    private static final String DIR = BASE_DIR + File.separator + "conf" + File.separator;
    private static final String CONFIG_FILE_PATH = DIR + "oxauth-config.xml";
    private static final String LDAP_FILE_PATH = DIR + "oxauth-ldap.properties";
    public static final String ERRORS_FILE_PATH = DIR + "oxauth-errors.json";
    public static final String STATIC_CONF_FILE_PATH = DIR + "oxauth-static-conf.json";
    public static final String ID_GEN_SCRIPT_FILE_PATH = DIR + "oxauth-id-gen.py";
    public static final String WEB_KEYS_FILE = "oxauth-web-keys.json";
    public static String webKeysFilePath = ConfigurationFactory.getLdapConfiguration().getString("certsDir") + File.separator + "oxauth-web-keys.json";
    public static final String CONFIGURATION_FILE_CRYPTO_PROPERTIES_FILE = DIR + "salt";
    private static final ConfigurationFactory INSTANCE = new ConfigurationFactory();
    private volatile Configuration m_conf;
    private volatile StaticConf m_staticConf;
    private volatile JSONWebKeySet m_jwks;

    public static FileConfiguration getLdapConfiguration() {
        return LdapHolder.LDAP_CONF;
    }

    public static Configuration getConfiguration() {
        return INSTANCE.getConf();
    }

    public static StaticConf getStaticConfiguration() {
        return INSTANCE.getStaticConf();
    }

    public static BaseDnConfiguration getBaseDn() {
        return ConfigurationFactory.getStaticConfiguration().getBaseDn();
    }

    public static List<ClaimMappingConfiguration> getClaimMappings() {
        return ConfigurationFactory.getStaticConfiguration().getClaimMapping();
    }

    public static JSONWebKeySet getWebKeys() {
        return INSTANCE.getKeyValueList();
    }

    public static void create() {
        if (!ConfigurationFactory.createFromLdap(true)) {
            LOG.error((Object)"Failed to load configuration from LDAP. Please fix it!!!.", new Object[0]);
            throw new RuntimeException("Failed to load configuration from LDAP.");
        }
        LOG.info((Object)"Configuration loaded successfully.", new Object[0]);
    }

    private static void createFromFile() {
        Configuration configFromFile = ConfigurationFactory.loadConfFromFile();
        ErrorMessages errorsFromFile = ConfigurationFactory.loadErrorsFromFile();
        StaticConf staticConfFromFile = ConfigurationFactory.loadStaticConfFromFile();
        JSONWebKeySet webKeysFromFile = ConfigurationFactory.loadWebKeysFromFile();
        if (configFromFile != null) {
            INSTANCE.setConf(configFromFile);
        } else {
            LOG.error((Object)("Failed to load configuration from file: {0}. " + CONFIG_FILE_PATH), new Object[0]);
        }
        if (errorsFromFile != null) {
            ErrorResponseFactory f = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
            f.setMessages(errorsFromFile);
        } else {
            LOG.error((Object)"Failed to load errors from file: {0}. ", new Object[]{ERRORS_FILE_PATH});
        }
        if (staticConfFromFile != null) {
            INSTANCE.setStaticConf(staticConfFromFile);
        } else {
            LOG.error((Object)"Failed to load static configuration from file: {0}. ", new Object[]{STATIC_CONF_FILE_PATH});
        }
        if (webKeysFromFile != null) {
            INSTANCE.setKeyValueList(webKeysFromFile);
        } else {
            LOG.error((Object)"Failed to load web keys configuration from file: {0}. ", new Object[]{webKeysFilePath});
        }
    }

    public static boolean updateFromLdap() {
        return ConfigurationFactory.createFromLdap(false);
    }

    private static boolean createFromLdap(boolean p_recoverFromFiles) {
        LOG.info((Object)"Loading configuration from LDAP...", new Object[0]);
        LdapEntryManager ldapManager = ServerUtil.getLdapManager();
        String dn = ConfigurationFactory.getLdapConfiguration().getString("configurationEntryDN");
        try {
            Conf conf = (Conf)ldapManager.find(Conf.class, (Object)dn);
            if (conf != null) {
                ConfigurationFactory.init(conf);
                return true;
            }
        }
        catch (LdapMappingException e) {
            LOG.warn((Object)e.getMessage(), new Object[0]);
            if (p_recoverFromFiles) {
                LOG.info((Object)"Unable to find configuration in LDAP, try to create configuration entry in LDAP... ", new Object[0]);
                if (ConfigurationFactory.getLdapConfiguration().getBoolean("createLdapConfigurationEntryIfNotExist")) {
                    ConfigurationFactory.createFromFile();
                    Conf conf = ConfigurationFactory.asConf();
                    if (conf != null) {
                        try {
                            ldapManager.persist((Object)conf);
                            LOG.info((Object)"Configuration entry is created in LDAP.", new Object[0]);
                            return true;
                        }
                        catch (Exception ex) {
                            LOG.error((Object)e.getMessage(), (Throwable)ex, new Object[0]);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
        return false;
    }

    private static Conf asConf() {
        try {
            String dn = ConfigurationFactory.getLdapConfiguration().getString("configurationEntryDN");
            ErrorResponseFactory errorFactory = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
            Conf c = new Conf();
            c.setDn(dn);
            c.setDynamic(ServerUtil.createJsonMapper().writeValueAsString((Object)INSTANCE.getConf()));
            c.setErrors(ServerUtil.createJsonMapper().writeValueAsString((Object)errorFactory.getMessages()));
            c.setStatics(ServerUtil.createJsonMapper().writeValueAsString((Object)INSTANCE.getStaticConf()));
            c.setWebKeys(ServerUtil.createJsonMapper().writeValueAsString((Object)INSTANCE.getKeyValueList()));
            return c;
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private static void init(Conf p_conf) {
        ConfigurationFactory.initConfigurationFromJson(p_conf.getDynamic());
        ConfigurationFactory.initStaticConfigurationFromJson(p_conf.getStatics());
        ConfigurationFactory.initErrorsFromJson(p_conf.getErrors());
        ConfigurationFactory.initWebKeysFromJson(p_conf.getWebKeys());
    }

    private static void initWebKeysFromJson(String p_webKeys) {
        try {
            JSONWebKeySet k = (JSONWebKeySet)ServerUtil.createJsonMapper().readValue(p_webKeys, JSONWebKeySet.class);
            if (k != null) {
                INSTANCE.setKeyValueList(k);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private static void initStaticConfigurationFromJson(String p_statics) {
        try {
            StaticConf c = (StaticConf)ServerUtil.createJsonMapper().readValue(p_statics, StaticConf.class);
            if (c != null) {
                INSTANCE.setStaticConf(c);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private static void initConfigurationFromJson(String p_configurationJson) {
        try {
            Configuration c = (Configuration)ServerUtil.createJsonMapper().readValue(p_configurationJson, Configuration.class);
            if (c != null) {
                INSTANCE.setConf(c);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    private static void initErrorsFromJson(String p_errosAsJson) {
        try {
            ErrorMessages errorMessages = (ErrorMessages)ServerUtil.createJsonMapper().readValue(p_errosAsJson, ErrorMessages.class);
            if (errorMessages != null) {
                ErrorResponseFactory f = (ErrorResponseFactory)ServerUtil.instance(ErrorResponseFactory.class);
                f.setMessages(errorMessages);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
        }
    }

    public static Configuration loadConfFromFile() {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
            Unmarshaller u = jc.createUnmarshaller();
            return (Configuration)u.unmarshal(new File(CONFIG_FILE_PATH));
        }
        catch (JAXBException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private static ErrorMessages loadErrorsFromFile() {
        try {
            return (ErrorMessages)ServerUtil.createJsonMapper().readValue(new File(ERRORS_FILE_PATH), ErrorMessages.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private static StaticConf loadStaticConfFromFile() {
        try {
            return (StaticConf)ServerUtil.createJsonMapper().readValue(new File(STATIC_CONF_FILE_PATH), StaticConf.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private static JSONWebKeySet loadWebKeysFromFile() {
        try {
            return (JSONWebKeySet)ServerUtil.createJsonMapper().readValue(new File(webKeysFilePath), JSONWebKeySet.class);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e, new Object[0]);
            return null;
        }
    }

    private static FileConfiguration createFileConfiguration(String fileName, boolean isMandatory) {
        try {
            FileConfiguration fileConfiguration = new FileConfiguration(fileName);
            return fileConfiguration;
        }
        catch (Exception ex) {
            if (isMandatory) {
                LOG.error((Object)"Failed to load configuration from {0}", (Throwable)ex, new Object[]{fileName});
                throw new ConfigurationException("Failed to load configuration from " + fileName, (Throwable)ex);
            }
            return null;
        }
    }

    public static String loadCryptoConfigurationSalt() {
        try {
            FileConfiguration cryptoConfiguration = ConfigurationFactory.createFileConfiguration(CONFIGURATION_FILE_CRYPTO_PROPERTIES_FILE, true);
            return cryptoConfiguration.getString("encodeSalt");
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to load configuration from {0}", (Throwable)ex, new Object[]{CONFIGURATION_FILE_CRYPTO_PROPERTIES_FILE});
            throw new ConfigurationException("Failed to load configuration from " + CONFIGURATION_FILE_CRYPTO_PROPERTIES_FILE, (Throwable)ex);
        }
    }

    public Configuration getConf() {
        return this.m_conf;
    }

    public void setConf(Configuration p_conf) {
        this.m_conf = p_conf;
    }

    public StaticConf getStaticConf() {
        return this.m_staticConf;
    }

    public void setStaticConf(StaticConf p_staticConf) {
        this.m_staticConf = p_staticConf;
    }

    public JSONWebKeySet getKeyValueList() {
        return this.m_jwks;
    }

    public void setKeyValueList(JSONWebKeySet p_jwks) {
        this.m_jwks = p_jwks;
    }

    private static class LdapHolder {
        private static final FileConfiguration LDAP_CONF = LdapHolder.createLdapConfiguration();

        private LdapHolder() {
        }

        private static FileConfiguration createLdapConfiguration() {
            try {
                return new FileConfiguration(LDAP_FILE_PATH);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
                return null;
            }
        }
    }
}

