/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.RegisterRequest;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.register.ApplicationType;
import org.xdi.oxauth.model.register.RegisterResponseParam;
import org.xdi.oxauth.model.util.StringUtils;

public class SectorIdentifierUrlVerificationEmbeddedTest
extends BaseTest {
    private String clientId1;
    private String clientSecret1;

    @Parameters(value={"registerPath", "redirectUris", "sectorIdentifierUri"})
    @Test
    public void requestAuthorizationCodeWithSectorIdentifierStep1(String registerPath, final String redirectUris, final String sectorIdentifierUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAuthorizationCodeWithSectorIdentifierStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_ACCESS_TOKEN.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.REGISTRATION_CLIENT_URI.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_ID_ISSUED_AT.toString()));
                    Assert.assertTrue((boolean)jsonObj.has(RegisterResponseParam.CLIENT_SECRET_EXPIRES_AT.toString()));
                    SectorIdentifierUrlVerificationEmbeddedTest.this.clientId1 = jsonObj.getString(RegisterResponseParam.CLIENT_ID.toString());
                    SectorIdentifierUrlVerificationEmbeddedTest.this.clientSecret1 = jsonObj.getString(RegisterResponseParam.CLIENT_SECRET.toString());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "redirectUri"})
    @Test(dependsOnMethods={"requestAuthorizationCodeWithSectorIdentifierStep1"})
    public void requestAuthorizationCodeWithSectorIdentifierStep2(String authorizePath, final String userId, final String userSecret, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, SectorIdentifierUrlVerificationEmbeddedTest.this.clientId1, scopes, redirectUri, null);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestAuthorizationCodeWithSectorIdentifierStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                try {
                    URI uri = new URI(response.getHeader("Location").toString());
                    Assert.assertNotNull((Object)uri.getQuery(), (String)"Query string is null");
                    Map params = QueryStringDecoder.decode((String)uri.getQuery());
                    Assert.assertNotNull(params.get("code"), (String)"The code is null");
                    Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                    Assert.assertNotNull(params.get("state"), (String)"The state is null");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                    Assert.fail((String)"Response URI is not well formed");
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "redirectUris"})
    @Test
    public void sectorIdentifierUrlVerificationFail1(String registerPath, final String redirectUris) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    registerRequest.setSectorIdentifierUri("https://INVALID_SECTOR_IDENTIFIER_URL");
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("sectorIdentifierUrlVerificationFail1", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"registerPath", "sectorIdentifierUri"})
    @Test
    public void sectorIdentifierUrlVerificationFail2(String registerPath, final String sectorIdentifierUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, registerPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                try {
                    super.prepareRequest(request);
                    String redirectUris = "https://INVALID_REDIRECT_URI https://client.example.com/cb https://client.example.com/cb1 https://client.example.com/cb2";
                    RegisterRequest registerRequest = new RegisterRequest(ApplicationType.WEB, "oxAuth test app", StringUtils.spaceSeparatedToList((String)redirectUris));
                    registerRequest.addCustomAttribute("oxAuthTrustedClient", "true");
                    registerRequest.setSectorIdentifierUri(sectorIdentifierUri);
                    request.setContentType("application/json");
                    String registerRequestContent = registerRequest.getJSONParameters().toString(4);
                    request.setContent(registerRequestContent.getBytes());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("sectorIdentifierUrlVerificationFail2", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }
}

