/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.common.IntrospectionResponse;
import org.xdi.oxauth.model.uma.TUma;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.util.ServerUtil;

public class IntrospectionWebServiceEmbeddedTest
extends BaseTest {
    private Token m_authorization;
    private Token m_tokenToIntrospect;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaAatClientId", "umaAatClientSecret", "umaRedirectUri"})
    public void requestAuthorization(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaAatClientId, String umaAatClientSecret, String umaRedirectUri) {
        this.m_authorization = TUma.requestAat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaAatClientId, umaAatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_authorization);
    }

    @Test(dependsOnMethods={"requestAuthorization"})
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaAatClientId", "umaAatClientSecret", "umaRedirectUri"})
    public void requestTokenToIntrospect(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaAatClientId, String umaAatClientSecret, String umaRedirectUri) {
        this.m_tokenToIntrospect = TUma.requestAat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaAatClientId, umaAatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_tokenToIntrospect);
    }

    @Test(dependsOnMethods={"requestTokenToIntrospect"})
    @Parameters(value={"introspectionPath"})
    public void introspection(String introspectionPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, introspectionPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Accept", (Object)"application/json");
                request.addHeader("Authorization", (Object)("Bearer " + IntrospectionWebServiceEmbeddedTest.this.m_authorization.getAccessToken()));
                request.addParameter("token", IntrospectionWebServiceEmbeddedTest.this.m_tokenToIntrospect.getAccessToken());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("introspection", response);
                Assert.assertEquals((int)response.getStatus(), (int)200);
                try {
                    IntrospectionResponse t = (IntrospectionResponse)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), IntrospectionResponse.class);
                    Assert.assertTrue((t != null && t.isActive() ? 1 : 0) != 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            }
        }.run();
    }
}

