/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.io.IOException;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.common.Holder;
import org.xdi.oxauth.model.common.Id;
import org.xdi.oxauth.model.common.IdType;
import org.xdi.oxauth.model.uma.AuthorizationResponse;
import org.xdi.oxauth.model.uma.RequesterPermissionTokenResponse;
import org.xdi.oxauth.model.uma.ResourceSetPermissionTicket;
import org.xdi.oxauth.model.uma.RptAuthorizationRequest;
import org.xdi.oxauth.model.uma.TUma;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.util.ServerUtil;

public class IdGenRestWSEmbeddedTest
extends BaseTest {
    private Token m_aat;
    private RequesterPermissionTokenResponse m_rpt;
    private final Holder<ResourceSetPermissionTicket> m_ticketH = new Holder();

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaAatClientId", "umaAatClientSecret", "umaRedirectUri"})
    public void init_0(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaAatClientId, String umaAatClientSecret, String umaRedirectUri) {
        this.m_aat = TUma.requestAat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaAatClientId, umaAatClientSecret, umaRedirectUri);
        UmaTestUtil.assert_((Token)this.m_aat);
    }

    @Test(dependsOnMethods={"init_0"})
    @Parameters(value={"umaRptPath", "umaAmHost"})
    public void init(String umaRptPath, String umaAmHost) {
        this.m_rpt = TUma.requestRpt(this, this.m_aat, umaRptPath, umaAmHost);
        UmaTestUtil.assert_((RequesterPermissionTokenResponse)this.m_rpt);
    }

    @Test(dependsOnMethods={"init"})
    @Parameters(value={"idGenerationPath"})
    public void requestInumForOpenidConnectClient_Negative(String idGenerationPath) throws Exception {
        String prefix = "@!1111";
        String path = idGenerationPath + "/" + "@!1111" + "/" + IdType.CLIENTS.getType();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, path){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Accept", (Object)"application/json");
                request.addHeader("Authorization", (Object)("Bearer " + IdGenRestWSEmbeddedTest.this.m_rpt.getToken()));
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestInumForOpenidConnectClient", response);
                Assert.assertEquals((int)response.getStatus(), (int)403);
                try {
                    ResourceSetPermissionTicket t = (ResourceSetPermissionTicket)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), ResourceSetPermissionTicket.class);
                    UmaTestUtil.assert_((ResourceSetPermissionTicket)t);
                    IdGenRestWSEmbeddedTest.this.m_ticketH.setT((Object)t);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            }
        }.run();
    }

    @Test(dependsOnMethods={"requestInumForOpenidConnectClient_Negative"})
    @Parameters(value={"umaPermissionAuthorizationPath", "umaAmHost"})
    public void authorizeRpt(String umaPermissionAuthorizationPath, String umaAmHost) {
        RptAuthorizationRequest request = new RptAuthorizationRequest();
        request.setRpt(this.m_rpt.getToken());
        request.setTicket(((ResourceSetPermissionTicket)this.m_ticketH.getT()).getTicket());
        AuthorizationResponse response = TUma.requestAuthorization(this, umaPermissionAuthorizationPath, umaAmHost, this.m_aat, request);
        Assert.assertNotNull((Object)response, (String)"Token response status is null");
    }

    @Test(dependsOnMethods={"authorizeRpt"})
    @Parameters(value={"idGenerationPath"})
    public void requestInumForOpenidConnectClient(String idGenerationPath) throws Exception {
        String prefix = "@!1111";
        String path = idGenerationPath + "/" + "@!1111" + "/" + IdType.CLIENTS.getType();
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, path){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Accept", (Object)"application/json");
                request.addHeader("Authorization", (Object)("Bearer " + IdGenRestWSEmbeddedTest.this.m_rpt.getToken()));
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestInumForOpenidConnectClient", response);
                Assert.assertEquals((int)response.getStatus(), (int)200);
                try {
                    Id id = (Id)ServerUtil.createJsonMapper().readValue(response.getContentAsString(), Id.class);
                    UmaTestUtil.assert_((Id)id);
                    Assert.assertTrue((boolean)id.getId().startsWith("@!1111"));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            }
        }.run();
    }

    @Test(dependsOnMethods={"requestInumForOpenidConnectClient"})
    @Parameters(value={"idGenerationPath"})
    public void requestPeopleInum(String idGenerationPath) throws Exception {
        String prefix = "@!1111";
        String path = idGenerationPath + "/" + "@!1111" + "/" + IdType.PEOPLE;
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, path){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Accept", (Object)"text/plain");
                request.addHeader("Authorization", (Object)("Bearer " + IdGenRestWSEmbeddedTest.this.m_rpt.getToken()));
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("requestPeopleInum", response);
                String id = response.getContentAsString();
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((boolean)id.startsWith("@!1111"), (String)"Unexpected id.");
            }
        }.run();
    }
}

