/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.ws.rs;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.client.AuthorizationRequest;
import org.xdi.oxauth.client.QueryStringDecoder;
import org.xdi.oxauth.client.TokenRequest;
import org.xdi.oxauth.client.UserInfoRequest;
import org.xdi.oxauth.client.ValidateTokenRequest;
import org.xdi.oxauth.model.common.GrantType;
import org.xdi.oxauth.model.common.Prompt;
import org.xdi.oxauth.model.common.ResponseType;
import org.xdi.oxauth.model.jwt.Jwt;

public class AuthorizationCodeFlowEmbeddedTest
extends BaseTest {
    String authorizationCode1;
    String authorizationCode2;
    String authorizationCode3;
    String authorizationCode4;
    String accessToken1;
    String refreshToken1;

    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void completeFlowStep1(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                String state = "af0ifjsldkj";
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("completeFlowStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                        Map params = QueryStringDecoder.decode((String)uri.getQuery());
                        Assert.assertNotNull(params.get("code"), (String)"The code is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        AuthorizationCodeFlowEmbeddedTest.this.authorizationCode1 = (String)params.get("code");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "validateTokenPath", "clientId", "clientSecret", "redirectUri"})
    @Test(dependsOnMethods={"completeFlowStep1"})
    public void completeFlowStep2(final String tokenPath, final String validateTokenPath, final String clientId, final String clientSecret, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(AuthorizationCodeFlowEmbeddedTest.this.authorizationCode1);
                tokenRequest.setRedirectUri(redirectUri);
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("completeFlowStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
                    String accessToken = jsonObj.getString("access_token");
                    String refreshToken = jsonObj.getString("refresh_token");
                    String idToken = jsonObj.getString("id_token");
                    AuthorizationCodeFlowEmbeddedTest.this.completeFlowStep3(tokenPath, validateTokenPath, accessToken, refreshToken, clientId, clientSecret);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    public void completeFlowStep3(final String tokenPath, String validateTokenPath, final String accessToken, final String refreshToken, final String clientId, final String clientSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, validateTokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ValidateTokenRequest validateTokenRequest = new ValidateTokenRequest();
                validateTokenRequest.setAccessToken(accessToken);
                request.setQueryString(validateTokenRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("completeFlowStep3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("valid"), (String)"Unexpected result: valid not found");
                    Assert.assertTrue((boolean)jsonObj.getBoolean("valid"), (String)"Unexpected result: valid is false");
                    Assert.assertTrue((boolean)jsonObj.has("expires_in"), (String)"Unexpected result: expires_in not found");
                    AuthorizationCodeFlowEmbeddedTest.this.completeFlowStep4(tokenPath, refreshToken, clientId, clientSecret);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    public void completeFlowStep4(String tokenPath, final String refreshToken, final String clientId, final String clientSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.REFRESH_TOKEN);
                tokenRequest.setRefreshToken(refreshToken);
                tokenRequest.setScope("email read_stream manage_pages");
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("completeFlowStep4", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void completeFlowWithOptionalNonceStep1(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                String state = "af0ifjsldkj";
                String nonce = UUID.randomUUID().toString();
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, nonce);
                authorizationRequest.setState(state);
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("completeFlowWithOptionalNonceStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                        Map params = QueryStringDecoder.decode((String)uri.getQuery());
                        Assert.assertNotNull(params.get("code"), (String)"The code is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        AuthorizationCodeFlowEmbeddedTest.this.authorizationCode4 = (String)params.get("code");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "validateTokenPath", "clientId", "clientSecret", "redirectUri"})
    @Test(dependsOnMethods={"completeFlowWithOptionalNonceStep1"})
    public void completeFlowWithOptionalNonceStep2(final String tokenPath, final String validateTokenPath, final String clientId, final String clientSecret, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(AuthorizationCodeFlowEmbeddedTest.this.authorizationCode4);
                tokenRequest.setRedirectUri(redirectUri);
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("completeFlowWithOptionalNonceStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
                    String accessToken = jsonObj.getString("access_token");
                    String refreshToken = jsonObj.getString("refresh_token");
                    String idToken = jsonObj.getString("id_token");
                    Jwt jwt = Jwt.parse((String)idToken);
                    Assert.assertNotNull((Object)jwt.getClaims().getClaimAsString("nonce"));
                    AuthorizationCodeFlowEmbeddedTest.this.completeFlowWithOptionalNonceStep3(tokenPath, validateTokenPath, accessToken, refreshToken, clientId, clientSecret);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    public void completeFlowWithOptionalNonceStep3(final String tokenPath, String validateTokenPath, final String accessToken, final String refreshToken, final String clientId, final String clientSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, validateTokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                ValidateTokenRequest validateTokenRequest = new ValidateTokenRequest();
                validateTokenRequest.setAccessToken(accessToken);
                request.setQueryString(validateTokenRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("completeFlowWithOptionalNonceStep3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)("Unexpected response code. " + response.getContentAsString()));
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store, private") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("valid"), (String)"Unexpected result: valid not found");
                    Assert.assertTrue((boolean)jsonObj.getBoolean("valid"), (String)"Unexpected result: valid is false");
                    Assert.assertTrue((boolean)jsonObj.has("expires_in"), (String)"Unexpected result: expires_in not found");
                    AuthorizationCodeFlowEmbeddedTest.this.completeFlowWithOptionalNonceStep4(tokenPath, refreshToken, clientId, clientSecret);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    public void completeFlowWithOptionalNonceStep4(String tokenPath, final String refreshToken, final String clientId, final String clientSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.REFRESH_TOKEN);
                tokenRequest.setRefreshToken(refreshToken);
                tokenRequest.setScope("email read_stream manage_pages");
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("completeFlowWithOptionalNonceStep4", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("scope"), (String)"Unexpected result: scope not found");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void revokeTokensStep1(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("revokeTokensStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                        Map params = QueryStringDecoder.decode((String)uri.getQuery());
                        Assert.assertNotNull(params.get("code"), (String)"The code is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        AuthorizationCodeFlowEmbeddedTest.this.authorizationCode2 = (String)params.get("code");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "clientId", "clientSecret", "redirectUri"})
    @Test(dependsOnMethods={"revokeTokensStep1"})
    public void revokeTokensStep2n3(String tokenPath, final String clientId, final String clientSecret, final String redirectUri) throws Exception {
        AuthorizationCodeFlowEmbeddedTest test = this;
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath, (AbstractSeamTest)test, tokenPath){
            final /* synthetic */ AbstractSeamTest val$test;
            final /* synthetic */ String val$tokenPath;
            {
                this.val$test = abstractSeamTest;
                this.val$tokenPath = string4;
                super(x0, x1, x2);
            }

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(AuthorizationCodeFlowEmbeddedTest.this.authorizationCode2);
                tokenRequest.setRedirectUri(redirectUri);
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("revokeTokensStep2n3", response);
                Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                Assert.assertTrue((response.getHeader("Cache-Control") != null && response.getHeader("Cache-Control").equals("no-store") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Cache-Control")));
                Assert.assertTrue((response.getHeader("Pragma") != null && response.getHeader("Pragma").equals("no-cache") ? 1 : 0) != 0, (String)("Unexpected result: " + response.getHeader("Pragma")));
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("access_token"), (String)"Unexpected result: access_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("token_type"), (String)"Unexpected result: token_type not found");
                    Assert.assertTrue((boolean)jsonObj.has("refresh_token"), (String)"Unexpected result: refresh_token not found");
                    Assert.assertTrue((boolean)jsonObj.has("id_token"), (String)"Unexpected result: id_token not found");
                    AuthorizationCodeFlowEmbeddedTest.this.accessToken1 = jsonObj.getString("access_token");
                    AuthorizationCodeFlowEmbeddedTest.this.refreshToken1 = jsonObj.getString("refresh_token");
                    new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment(this.val$test), ResourceRequestEnvironment.Method.POST, this.val$tokenPath){

                        protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                            super.prepareRequest(request);
                            TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                            tokenRequest.setCode(AuthorizationCodeFlowEmbeddedTest.this.authorizationCode2);
                            tokenRequest.setRedirectUri(redirectUri);
                            tokenRequest.setAuthUsername(clientId);
                            tokenRequest.setAuthPassword(clientSecret);
                            request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                            request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                            request.addParameters(tokenRequest.getParameters());
                        }

                        protected void onResponse(EnhancedMockHttpServletResponse response) {
                            super.onResponse(response);
                            BaseTest.showResponse("revokeTokens step 3", response);
                            Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
                            Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                            try {
                                JSONObject jsonObj = new JSONObject(response.getContentAsString());
                                Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                                Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                                Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                            }
                        }
                    }.run();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Assert.fail((String)e.getMessage());
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "clientId", "clientSecret"})
    @Test(dependsOnMethods={"revokeTokensStep2n3"})
    public void revokeTokensStep4(String tokenPath, final String clientId, final String clientSecret) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.REFRESH_TOKEN);
                tokenRequest.setRefreshToken(AuthorizationCodeFlowEmbeddedTest.this.refreshToken1);
                tokenRequest.setScope("email read_stream manage_pages");
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("revokeTokensStep4", response);
                Assert.assertEquals((int)response.getStatus(), (int)401, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"userInfoPath"})
    @Test(dependsOnMethods={"revokeTokensStep4"})
    public void revokeTokensStep5(String userInfoPath) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, userInfoPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Authorization", (Object)("Bearer " + AuthorizationCodeFlowEmbeddedTest.this.accessToken1));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                UserInfoRequest userInfoRequest = new UserInfoRequest(null);
                request.addParameters(userInfoRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("revokeTokensStep5", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }

    @Parameters(value={"authorizePath", "userId", "userSecret", "clientId", "redirectUri"})
    @Test
    public void tokenExpirationStep1(String authorizePath, final String userId, final String userSecret, final String clientId, final String redirectUri) throws Exception {
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.GET, authorizePath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                ArrayList<ResponseType> responseTypes = new ArrayList<ResponseType>();
                responseTypes.add(ResponseType.CODE);
                ArrayList<String> scopes = new ArrayList<String>();
                scopes.add("openid");
                scopes.add("profile");
                scopes.add("address");
                scopes.add("email");
                AuthorizationRequest authorizationRequest = new AuthorizationRequest(responseTypes, clientId, scopes, redirectUri, null);
                authorizationRequest.setState("af0ifjsldkj");
                authorizationRequest.getPrompts().add(Prompt.NONE);
                authorizationRequest.setAuthUsername(userId);
                authorizationRequest.setAuthPassword(userSecret);
                request.addHeader("Authorization", (Object)("Basic " + authorizationRequest.getEncodedCredentials()));
                request.addHeader("Accept", (Object)"text/plain");
                request.setQueryString(authorizationRequest.getQueryString());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("tokenExpirationStep1", response);
                Assert.assertEquals((int)response.getStatus(), (int)302, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getHeader("Location"), (String)("Unexpected result: " + response.getHeader("Location")));
                if (response.getHeader("Location") != null) {
                    try {
                        URI uri = new URI(response.getHeader("Location").toString());
                        Assert.assertNotNull((Object)uri.getQuery(), (String)"The query string is null");
                        Map params = QueryStringDecoder.decode((String)uri.getQuery());
                        Assert.assertNotNull(params.get("code"), (String)"The code is null");
                        Assert.assertNotNull(params.get("scope"), (String)"The scope is null");
                        Assert.assertNotNull(params.get("state"), (String)"The state is null");
                        AuthorizationCodeFlowEmbeddedTest.this.authorizationCode3 = (String)params.get("code");
                    }
                    catch (URISyntaxException e) {
                        e.printStackTrace();
                        Assert.fail((String)"Response URI is not well formed");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Assert.fail((String)e.getMessage());
                    }
                }
            }
        }.run();
    }

    @Parameters(value={"tokenPath", "clientId", "clientSecret", "redirectUri"})
    @Test(dependsOnMethods={"tokenExpirationStep1"})
    public void tokenExpirationStep2(String tokenPath, final String clientId, final String clientSecret, final String redirectUri) throws Exception {
        System.out.println("Sleeping for 20 seconds .....");
        Thread.sleep(20000L);
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this), ResourceRequestEnvironment.Method.POST, tokenPath){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                TokenRequest tokenRequest = new TokenRequest(GrantType.AUTHORIZATION_CODE);
                tokenRequest.setCode(AuthorizationCodeFlowEmbeddedTest.this.authorizationCode3);
                tokenRequest.setRedirectUri(redirectUri);
                tokenRequest.setAuthUsername(clientId);
                tokenRequest.setAuthPassword(clientSecret);
                request.addHeader("Authorization", (Object)("Basic " + tokenRequest.getEncodedCredentials()));
                request.addHeader("Content-Type", (Object)"application/x-www-form-urlencoded");
                request.addParameters(tokenRequest.getParameters());
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("tokenExpirationStep2", response);
                Assert.assertEquals((int)response.getStatus(), (int)400, (String)"Unexpected response code.");
                Assert.assertNotNull((Object)response.getContentAsString(), (String)("Unexpected result: " + response.getContentAsString()));
                try {
                    JSONObject jsonObj = new JSONObject(response.getContentAsString());
                    Assert.assertTrue((boolean)jsonObj.has("error"), (String)"The error type is null");
                    Assert.assertTrue((boolean)jsonObj.has("error_description"), (String)"The error description is null");
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    Assert.fail((String)(e.getMessage() + "\nResponse was: " + response.getContentAsString()));
                }
            }
        }.run();
    }
}

