/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.uma.ResourceSet;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.TUma;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;

public class RegisterResourceSetWSTest
extends BaseTest {
    private Token m_pat;
    private ResourceSetStatus m_resourceSetStatus;
    private String m_umaRegisterResourcePath;

    @Test
    @Parameters(value={"authorizePath", "tokenPath", "umaUserId", "umaUserSecret", "umaPatClientId", "umaPatClientSecret", "umaRedirectUri", "umaRegisterResourcePath"})
    public void init(String authorizePath, String tokenPath, String umaUserId, String umaUserSecret, String umaPatClientId, String umaPatClientSecret, String umaRedirectUri, String umaRegisterResourcePath) {
        this.m_pat = TUma.requestPat(this, authorizePath, tokenPath, umaUserId, umaUserSecret, umaPatClientId, umaPatClientSecret, umaRedirectUri);
        this.m_umaRegisterResourcePath = umaRegisterResourcePath;
    }

    @Test(dependsOnMethods={"init"})
    public void testRegisterResourceSet() throws Exception {
        this.m_resourceSetStatus = TUma.registerResourceSet(this, this.m_pat, this.m_umaRegisterResourcePath, UmaTestUtil.createResourceSet());
        UmaTestUtil.assert_((ResourceSetStatus)this.m_resourceSetStatus);
        Assert.assertEquals((String)this.m_resourceSetStatus.getRev(), (String)"1", (String)"Resource set description revision is not 1");
    }

    @Test(dependsOnMethods={"testRegisterResourceSet"})
    public void testModifyResourceSet() throws Exception {
        ResourceSet resourceSet = new ResourceSet();
        resourceSet.setName("Server Photo Album 2");
        resourceSet.setIconUri("http://www.example.com/icons/flower.png");
        resourceSet.setScopes(Arrays.asList("http://photoz.example.com/dev/scopes/view", "http://photoz.example.com/dev/scopes/all"));
        ResourceSetStatus status = TUma.modifyResourceSet(this, this.m_pat, this.m_umaRegisterResourcePath, this.m_resourceSetStatus.getId(), this.m_resourceSetStatus.getRev(), resourceSet);
        UmaTestUtil.assert_((ResourceSetStatus)status);
        Assert.assertEquals((String)status.getRev(), (String)"2", (String)"Resource set description revision is not 2");
        this.m_resourceSetStatus.setRev(status.getRev());
    }

    @Test(dependsOnMethods={"testModifyResourceSet"})
    public void testGetResourceSets() throws Exception {
        List<String> list = TUma.getResourceSetList(this, this.m_pat, this.m_umaRegisterResourcePath);
        Assert.assertTrue((list != null && !list.isEmpty() && list.contains(this.m_resourceSetStatus.getId()) ? 1 : 0) != 0, (String)"Resource set list is empty");
    }

    @Test(dependsOnMethods={"testGetResourceSets"})
    public void testDeleteResourceSet() throws Exception {
        TUma.deleteResourceSet(this, this.m_pat, this.m_umaRegisterResourcePath, this.m_resourceSetStatus.getId(), this.m_resourceSetStatus.getRev());
    }
}

