/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.uma;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.Response;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.jboss.seam.mock.AbstractSeamTest;
import org.jboss.seam.mock.EnhancedMockHttpServletRequest;
import org.jboss.seam.mock.EnhancedMockHttpServletResponse;
import org.jboss.seam.mock.ResourceRequestEnvironment;
import org.testng.Assert;
import org.xdi.oxauth.BaseTest;
import org.xdi.oxauth.model.uma.ResourceSet;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.TUma;
import org.xdi.oxauth.model.uma.UmaTestUtil;
import org.xdi.oxauth.model.uma.wrapper.Token;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

class TRegisterResourceSet {
    private final BaseTest m_baseTest;
    private ResourceSetStatus m_registerStatus;
    private ResourceSetStatus m_modifyStatus;

    public TRegisterResourceSet(BaseTest p_baseTest) {
        Assert.assertNotNull((Object)((Object)p_baseTest));
        this.m_baseTest = p_baseTest;
    }

    public ResourceSetStatus registerResourceSet(Token p_pat, String umaRegisterResourcePath, ResourceSet p_resourceSet) {
        try {
            this.m_registerStatus = this.registerResourceSetInternal(p_pat, umaRegisterResourcePath, p_resourceSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        UmaTestUtil.assert_((ResourceSetStatus)this.m_registerStatus);
        return this.m_registerStatus;
    }

    public ResourceSetStatus modifyResourceSet(Token p_pat, String umaRegisterResourcePath, String p_rsId, String p_rev, ResourceSet p_resourceSet) {
        try {
            this.m_modifyStatus = this.modifyResourceSetInternal(p_pat, umaRegisterResourcePath, p_rsId, p_rev, p_resourceSet);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        UmaTestUtil.assert_((ResourceSetStatus)this.m_modifyStatus);
        return this.m_modifyStatus;
    }

    private ResourceSetStatus registerResourceSetInternal(final Token p_pat, String umaRegisterResourcePath, final ResourceSet p_resourceSet) throws Exception {
        String rsid = String.valueOf(System.currentTimeMillis());
        String path = umaRegisterResourcePath + "/" + rsid;
        System.out.println("Path: " + path);
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.PUT, path){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                System.out.println("PAT: " + p_pat.getAccessToken());
                request.addHeader("Accept", (Object)"application/json");
                request.addHeader("Authorization", (Object)("Bearer " + p_pat.getAccessToken()));
                try {
                    String json = ServerUtil.createJsonMapper().writeValueAsString((Object)p_resourceSet);
                    System.out.println("Json: " + json);
                    request.setContent(Util.getBytes((String)json));
                    request.setContentType("application/json");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("UMA : TRegisterResourceSet.registerResourceSetInternal() : ", response);
                Assert.assertEquals((int)response.getStatus(), (int)Response.Status.CREATED.getStatusCode(), (String)"Unexpected response code.");
                TRegisterResourceSet.this.m_registerStatus = TUma.readJsonValue(response.getContentAsString(), ResourceSetStatus.class);
                UmaTestUtil.assert_((ResourceSetStatus)TRegisterResourceSet.this.m_registerStatus);
            }
        }.run();
        return this.m_registerStatus;
    }

    private ResourceSetStatus modifyResourceSetInternal(final Token p_pat, String umaRegisterResourcePath, String p_rsId, final String p_rev, final ResourceSet p_resourceSet) throws Exception {
        String path = umaRegisterResourcePath + "/" + p_rsId + "/";
        new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.PUT, path){

            protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                super.prepareRequest(request);
                request.addHeader("Accept", (Object)"application/json");
                request.addHeader("Authorization", (Object)("Bearer " + p_pat.getAccessToken()));
                request.addHeader("If-Match", (Object)p_rev);
                try {
                    String json = ServerUtil.createJsonMapper().writeValueAsString((Object)p_resourceSet);
                    request.setContent(Util.getBytes((String)json));
                    request.setContentType("application/json");
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Assert.fail();
                }
            }

            protected void onResponse(EnhancedMockHttpServletResponse response) {
                super.onResponse(response);
                BaseTest.showResponse("UMA : TRegisterResourceSet.modifyResourceSetInternal() : ", response);
                Assert.assertEquals((int)response.getStatus(), (int)Response.Status.CREATED.getStatusCode(), (String)"Unexpected response code.");
                TRegisterResourceSet.this.m_modifyStatus = TUma.readJsonValue(response.getContentAsString(), ResourceSetStatus.class);
                UmaTestUtil.assert_((ResourceSetStatus)TRegisterResourceSet.this.m_modifyStatus);
            }
        }.run();
        return this.m_modifyStatus;
    }

    public List<String> getResourceSetList(final Token p_pat, String p_umaRegisterResourcePath) {
        final ArrayList<String> result = new ArrayList<String>();
        try {
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.GET, p_umaRegisterResourcePath){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    request.addHeader("Accept", (Object)"application/json");
                    request.addHeader("Authorization", (Object)("Bearer " + p_pat.getAccessToken()));
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("UMA : TRegisterResourceSet.getResourceSetList() : ", response);
                    Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response code.");
                    List list = TUma.readJsonValue(response.getContentAsString(), List.class);
                    if (list != null) {
                        result.addAll(list);
                    }
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
        return result;
    }

    public void deleteResourceSet(final Token p_pat, String p_umaRegisterResourcePath, String p_id, final String p_rev) {
        String path = p_umaRegisterResourcePath + "/" + p_id + "/";
        try {
            new ResourceRequestEnvironment.ResourceRequest(new ResourceRequestEnvironment((AbstractSeamTest)this.m_baseTest), ResourceRequestEnvironment.Method.DELETE, path){

                protected void prepareRequest(EnhancedMockHttpServletRequest request) {
                    super.prepareRequest(request);
                    request.addHeader("Authorization", (Object)("Bearer " + p_pat.getAccessToken()));
                    request.addHeader("If-Match", (Object)p_rev);
                }

                protected void onResponse(EnhancedMockHttpServletResponse response) {
                    super.onResponse(response);
                    BaseTest.showResponse("UMA : TRegisterResourceSet.deleteResourceSet() : ", response);
                    Assert.assertEquals((int)response.getStatus(), (int)Response.Status.NO_CONTENT.getStatusCode(), (String)"Unexpected response code.");
                }
            }.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    public static void main(String[] args) throws IOException {
        ResourceSet r = new ResourceSet();
        r.setName("test name");
        r.setIconUri("http://icon.com");
        ObjectMapper mapper = ServerUtil.createJsonMapper();
        mapper.configure(SerializationConfig.Feature.WRAP_ROOT_VALUE, true);
        String json = mapper.writeValueAsString((Object)r);
        System.out.println(json);
        String j = "{\"resourceSetStatus\":{\"_id\":1364301527462,\"_rev\":1,\"status\":\"created\"}}";
        ResourceSetStatus newR = TUma.readJsonValue("{\"resourceSetStatus\":{\"_id\":1364301527462,\"_rev\":1,\"status\":\"created\"}}", ResourceSetStatus.class);
        System.out.println();
    }
}

