/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.comp;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.IOUtils;
import org.testng.Assert;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.xdi.oxauth.BaseComponentTestAdapter;
import org.xdi.oxauth.model.config.Conf;
import org.xdi.oxauth.model.config.Configuration;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.util.Util;
import org.xdi.oxauth.util.ServerUtil;

public class ConfigurationTest
extends BaseComponentTestAdapter {
    @Parameters(value={"configurationDn"})
    public ConfigurationTest(String p_configurationDn) {
    }

    @Test
    public void configurationPresence() {
        String dn = ConfigurationFactory.getLdapConfiguration().getString("configurationEntryDN");
        Conf conf = (Conf)this.getLdapManager().find(Conf.class, (Object)dn);
        Assert.assertTrue((conf != null && Util.allNotBlank((String[])new String[]{conf.getDynamic(), conf.getErrors(), conf.getStatics(), conf.getWebKeys()}) ? 1 : 0) != 0);
    }

    public void createLatestTestConfInLdapFromFiles() throws Exception {
        String prefix = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf";
        String errorsFile = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-errors.json";
        String staticFile = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-static-conf.json";
        String webKeysFile = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-web-keys.json";
        String configFile = "U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-config.xml";
        String errorsJson = IOUtils.toString((InputStream)new FileInputStream("U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-errors.json"));
        String staticConfJson = IOUtils.toString((InputStream)new FileInputStream("U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-static-conf.json"));
        String webKeysJson = IOUtils.toString((InputStream)new FileInputStream("U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-web-keys.json"));
        String configJson = ServerUtil.createJsonMapper().writeValueAsString((Object)ConfigurationTest.loadConfFromFile("U:\\own\\project\\oxAuth\\Server\\src\\test\\resources\\conf\\oxauth-config.xml"));
        Conf c = new Conf();
        c.setDn("ou=testconfiguration,o=@!1111,o=gluu");
        c.setDynamic(configJson);
        c.setErrors(errorsJson);
        c.setStatics(staticConfJson);
        c.setWebKeys(webKeysJson);
        this.getLdapManager().persist((Object)c);
    }

    private static Configuration loadConfFromFile(String p_filePath) throws JAXBException {
        JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Configuration.class});
        Unmarshaller u = jc.createUnmarshaller();
        return (Configuration)u.unmarshal(new File(p_filePath));
    }
}

