/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.util;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONObject;
import org.xdi.oxauth.model.crypto.Key;
import org.xdi.oxauth.model.crypto.signature.ECDSAKeyFactory;
import org.xdi.oxauth.model.crypto.signature.RSAKeyFactory;
import org.xdi.oxauth.model.crypto.signature.SignatureAlgorithm;

public class KeyGenerator {
    public static void main(String[] args) throws Exception {
        JSONArray keys = new JSONArray();
        keys.put((Object)KeyGenerator.generateRS256Keys());
        keys.put((Object)KeyGenerator.generateRS384Keys());
        keys.put((Object)KeyGenerator.generateRS512Keys());
        keys.put((Object)KeyGenerator.generateES256Keys());
        keys.put((Object)KeyGenerator.generateES384Keys());
        keys.put((Object)KeyGenerator.generateES512Keys());
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("keys", (Object)keys);
        System.out.println(jsonObject.toString(4).replace("\\/", "/"));
    }

    public static JSONObject generateRS256Keys() throws Exception {
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS256, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("RSA");
        key.setUse("SIGNATURE");
        key.setAlgorithm("RS256");
        key.setKeyId("1");
        key.setCurve(JSONObject.NULL);
        return key.toJSONObject();
    }

    public static JSONObject generateRS384Keys() throws Exception {
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS384, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("RSA");
        key.setUse("SIGNATURE");
        key.setAlgorithm("RS384");
        key.setKeyId("2");
        key.setCurve(JSONObject.NULL);
        return key.toJSONObject();
    }

    public static JSONObject generateRS512Keys() throws Exception {
        RSAKeyFactory keyFactory = new RSAKeyFactory(SignatureAlgorithm.RS512, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("RSA");
        key.setUse("SIGNATURE");
        key.setAlgorithm("RS512");
        key.setKeyId("3");
        key.setCurve(JSONObject.NULL);
        return key.toJSONObject();
    }

    public static JSONObject generateES256Keys() throws Exception {
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES256, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("EC");
        key.setUse("SIGNATURE");
        key.setAlgorithm("EC");
        key.setKeyId("4");
        key.setCurve((Object)"P-256");
        return key.toJSONObject();
    }

    public static JSONObject generateES384Keys() throws Exception {
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES384, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("EC");
        key.setUse("SIGNATURE");
        key.setAlgorithm("EC");
        key.setKeyId("5");
        key.setCurve((Object)"P-384");
        return key.toJSONObject();
    }

    public static JSONObject generateES512Keys() throws Exception {
        ECDSAKeyFactory keyFactory = new ECDSAKeyFactory(SignatureAlgorithm.ES512, "CN=Test CA Certificate");
        Key key = keyFactory.getKey();
        key.setKeyType("EC");
        key.setUse("SIGNATURE");
        key.setAlgorithm("EC");
        key.setKeyId("6");
        key.setCurve((Object)"P-521");
        return key.toJSONObject();
    }
}

