/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.uma.ws.rs;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Response;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.common.AuthorizationGrant;
import org.xdi.oxauth.model.common.AuthorizationGrantList;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.model.error.ErrorResponseFactory;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.uma.ResourceSetStatus;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.uma.VersionedResourceSet;
import org.xdi.oxauth.model.uma.persistence.ResourceSet;
import org.xdi.oxauth.service.token.TokenService;
import org.xdi.oxauth.service.uma.ResourceSetService;
import org.xdi.oxauth.service.uma.ScopeService;
import org.xdi.oxauth.service.uma.UmaValidationService;
import org.xdi.oxauth.uma.ws.rs.ResourceSetRegistrationRestWebService;
import org.xdi.oxauth.util.ServerUtil;
import org.xdi.util.StringHelper;

@Name(value="resourceSetRegistrationRestWebService")
public class ResourceSetRegistrationRestWebServiceImpl
implements ResourceSetRegistrationRestWebService {
    private static final String STATUS_CREATED = "created";
    private static final String STATUS_UPDATED = "updated";
    @Logger
    private Log log;
    @In
    private TokenService tokenService;
    @In
    private UmaValidationService umaValidationService;
    @In
    private ResourceSetService resourceSetService;
    @In
    private ErrorResponseFactory errorResponseFactory;
    @In
    private AuthorizationGrantList authorizationGrantList;
    @In
    private ScopeService umaScopeService;

    @Override
    public Response putResourceSet(String authorization, String rsver, String rsid, org.xdi.oxauth.model.uma.ResourceSet resourceSet) {
        try {
            boolean isCreate = StringHelper.isEmpty((String)rsver);
            if (isCreate) {
                String ignoredId = rsid;
                rsid = this.generatedId();
                this.log.trace((Object)"Try to create resource set, provided id (ignored): {0}, id: {1}", new Object[]{ignoredId, rsid});
            } else {
                this.log.trace((Object)"Try to modify resource set, id: {0}", new Object[]{rsid});
            }
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            return this.putResourceSetImpl(authorization, rsver, rsid, resourceSet);
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private synchronized String generatedId() {
        return String.valueOf(System.currentTimeMillis());
    }

    @Override
    public Response getResourceSet(String authorization, String rsid) {
        try {
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            this.log.debug((Object)"Getting resource set description: '{0}'", new Object[]{rsid});
            this.prepareResourceSetsBranch();
            ResourceSet ldapResourceSet = new ResourceSet();
            ldapResourceSet.setDn(this.resourceSetService.getBaseDnForResourceSet());
            ldapResourceSet.setId(rsid);
            List<ResourceSet> ldapResourceSets = this.resourceSetService.findResourceSets(ldapResourceSet);
            if (ldapResourceSets.size() != 1) {
                this.log.error((Object)"Specified resource set description isn't exist", new Object[0]);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
            }
            ldapResourceSet = ldapResourceSets.get(0);
            VersionedResourceSet versionedResourceSet = new VersionedResourceSet();
            BeanUtils.copyProperties((Object)versionedResourceSet, (Object)ldapResourceSet);
            versionedResourceSet.setScopes(this.umaScopeService.getScopeUrlsByDns(ldapResourceSet.getScopes()));
            Response.ResponseBuilder builder = Response.ok();
            builder.entity((Object)ServerUtil.asJson(versionedResourceSet));
            builder.tag(new EntityTag(versionedResourceSet.getRev()));
            return builder.build();
        }
        catch (Exception ex) {
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    @Override
    public List<String> getResourceSetList(String authorization, String p_scope) {
        block5: {
            try {
                this.log.trace((Object)"Getting resource set descriptions.", new Object[0]);
                this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
                String patToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
                AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(patToken);
                if (authorizationGrant != null) {
                    String clientDn = authorizationGrant.getClientDn();
                    this.prepareResourceSetsBranch();
                    List<ResourceSet> ldapResourceSets = this.resourceSetService.getResourceSetsByAssociatedClient(clientDn);
                    ArrayList<String> result = new ArrayList<String>(ldapResourceSets.size());
                    for (ResourceSet ldapResourceSet : ldapResourceSets) {
                        if (StringUtils.isNotBlank((String)p_scope)) {
                            List<String> scopeUrlsByDns = this.umaScopeService.getScopeUrlsByDns(ldapResourceSet.getScopes());
                            if (scopeUrlsByDns == null || !scopeUrlsByDns.contains(p_scope)) continue;
                            result.add(ldapResourceSet.getId());
                            continue;
                        }
                        result.add(ldapResourceSet.getId());
                    }
                    return result;
                }
            }
            catch (Exception ex) {
                this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
                if (!(ex instanceof WebApplicationException)) break block5;
                throw (WebApplicationException)ex;
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
    }

    @Override
    public Response deleteResourceSet(String authorization, String rsver, String rsid) {
        try {
            this.umaValidationService.validateAuthorizationWithProtectScope(authorization);
            this.log.debug((Object)"Getting resource set descriptions'", new Object[0]);
            this.prepareResourceSetsBranch();
            ResourceSet ldapResourceSet = new ResourceSet();
            ldapResourceSet.setDn(this.resourceSetService.getBaseDnForResourceSet());
            ldapResourceSet.setId(rsid);
            ldapResourceSet.setRev(rsver);
            List<ResourceSet> ldapResourceSets = this.resourceSetService.findResourceSets(ldapResourceSet);
            if (ldapResourceSets.size() != 1) {
                this.log.error((Object)"Specified resource set description isn't exist", new Object[0]);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
            }
            this.resourceSetService.removeResourceSet(ldapResourceSets.get(0));
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (Exception ex) {
            if (ex instanceof WebApplicationException) {
                throw (WebApplicationException)ex;
            }
            this.log.error((Object)"Exception happened", (Throwable)ex, new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.SERVER_ERROR)).build());
        }
    }

    private Response putResourceSetImpl(String authorization, String rsver, String rsid, org.xdi.oxauth.model.uma.ResourceSet resourceSet) throws IllegalAccessException, InvocationTargetException, IOException {
        String status;
        String resourceSetDn;
        this.log.trace((Object)"putResourceSetImpl, rsid: {0}, rsver: {1}", new Object[]{rsid, rsver});
        String patToken = this.tokenService.getTokenFromAuthorizationParameter(authorization);
        AuthorizationGrant authorizationGrant = this.authorizationGrantList.getAuthorizationGrantByAccessToken(patToken);
        String userDn = authorizationGrant.getUserDn();
        String clientInum = authorizationGrant.getClientId();
        String clientDn = authorizationGrant.getClientDn();
        if (StringHelper.isEmpty((String)rsver)) {
            resourceSetDn = this.addResourceSet(rsid, resourceSet, userDn, clientInum, clientDn);
            status = STATUS_CREATED;
        } else {
            resourceSetDn = this.updateResourceSet(rsver, rsid, resourceSet, authorizationGrant, clientDn);
            status = STATUS_UPDATED;
        }
        ResourceSet ldapUpdatedResourceSet = this.resourceSetService.getResourceSetByDn(resourceSetDn);
        ResourceSetStatus resourceSetStatus = new ResourceSetStatus();
        resourceSetStatus.setStatus(status);
        BeanUtils.copyProperties((Object)resourceSetStatus, (Object)ldapUpdatedResourceSet);
        String entity = ServerUtil.asJson(resourceSetStatus);
        Response.ResponseBuilder builder = Response.status((Response.Status)Response.Status.CREATED);
        builder.entity((Object)entity);
        EntityTag tag = new EntityTag(ldapUpdatedResourceSet.getRev());
        builder.tag(tag);
        return builder.build();
    }

    private String addResourceSet(String rsid, org.xdi.oxauth.model.uma.ResourceSet resourceSet, String userDn, String clientInum, String clientDn) throws IllegalAccessException, InvocationTargetException {
        this.log.debug((Object)"Adding new resource set description: '{0}'", new Object[]{rsid});
        this.prepareResourceSetsBranch();
        String resourceSetDn = this.resourceSetService.getDnForResourceSet(rsid);
        List<String> scopeDNs = this.umaScopeService.getScopeDNsByUrlsAndAddToLdapIfNeeded(resourceSet.getScopes());
        ResourceSet ldapResourceSet = new ResourceSet();
        BeanUtils.copyProperties((Object)ldapResourceSet, (Object)resourceSet);
        ldapResourceSet.setId(rsid);
        ldapResourceSet.setRev("1");
        ldapResourceSet.setCreator(userDn);
        ldapResourceSet.setDn(resourceSetDn);
        ldapResourceSet.setScopes(scopeDNs);
        Boolean addClient = ConfigurationFactory.getConfiguration().getUmaKeepClientDuringResourceSetRegistration();
        if (addClient == null || addClient.booleanValue()) {
            ldapResourceSet.setClients(new ArrayList<String>(Arrays.asList(clientDn)));
        }
        this.resourceSetService.addResourceSet(ldapResourceSet);
        return resourceSetDn;
    }

    private String updateResourceSet(String rsver, String rsid, org.xdi.oxauth.model.uma.ResourceSet resourceSet, AuthorizationGrant authorizationGrant, String clientDn) throws IllegalAccessException, InvocationTargetException {
        this.log.debug((Object)"Updating resource set description: '{0}'. Version: '{1}'", new Object[]{rsid, rsver});
        this.prepareResourceSetsBranch();
        ResourceSet ldapResourceSet = new ResourceSet();
        ldapResourceSet.setDn(this.resourceSetService.getBaseDnForResourceSet());
        ldapResourceSet.setId(rsid);
        ldapResourceSet.setRev(rsver);
        List<ResourceSet> ldapResourceSets = this.resourceSetService.findResourceSets(ldapResourceSet);
        if (ldapResourceSets.size() != 1) {
            this.log.error((Object)"Specified resource set description isn't exist", new Object[0]);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.NOT_FOUND)).build());
        }
        ldapResourceSet = ldapResourceSets.get(0);
        String resourceSetDn = ldapResourceSet.getDn();
        BeanUtils.copyProperties((Object)ldapResourceSet, (Object)resourceSet);
        List<String> scopeDNs = this.umaScopeService.getScopeDNsByUrlsAndAddToLdapIfNeeded(resourceSet.getScopes());
        ldapResourceSet.setScopes(scopeDNs);
        int currRev = StringHelper.toInteger((String)rsver, (int)-1);
        if (currRev == -1) {
            this.log.error((Object)"Failed to parse revision number: '{0}'", new Object[]{currRev});
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)this.errorResponseFactory.getUmaJsonErrorResponse((IErrorType)UmaErrorResponseType.PRECONDITION_FAILED)).build());
        }
        ldapResourceSet.setRev(String.valueOf(++currRev));
        this.resourceSetService.updateResourceSet(ldapResourceSet);
        return resourceSetDn;
    }

    private void prepareResourceSetsBranch() {
        if (!this.resourceSetService.containsBranch()) {
            this.resourceSetService.addBranch();
        }
    }
}

