/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.service;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.IOUtils;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.async.Asynchronous;
import org.jboss.seam.async.Schedule;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.core.Events;
import org.jboss.seam.log.Log;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.xdi.exception.PythonException;
import org.xdi.model.AuthenticationScriptUsageType;
import org.xdi.model.SimpleCustomProperty;
import org.xdi.model.config.CustomAuthenticationConfiguration;
import org.xdi.oxauth.model.ExternalAuthenticatorConfiguration;
import org.xdi.oxauth.model.config.ConfigurationFactory;
import org.xdi.oxauth.service.LdapCustomAuthenticationConfigurationService;
import org.xdi.oxauth.service.python.interfaces.DummyExternalAuthenticatorType;
import org.xdi.oxauth.service.python.interfaces.ExternalAuthenticatorType;
import org.xdi.service.PythonService;
import org.xdi.util.StringHelper;

@Scope(value=ScopeType.APPLICATION)
@Name(value="externalAuthenticationService")
@AutoCreate
@Startup(depends={"appInitializer"})
public class ExternalAuthenticationService
implements Serializable {
    private static final long serialVersionUID = -1225880597520443390L;
    public static final String AMR_METHOD_PREFIX = "https://schema.gluu.org/openid/amr/method/";
    private static final String EVENT_TYPE = "ExternalAuthenticationTimerEvent";
    private static final int DEFAULT_INTERVAL = 30;
    private static final ExternalAuthenticatorType DUMMY_AUTHENTICATOR_TYPE = new DummyExternalAuthenticatorType();
    private static final String PYTHON_ENTRY_INTERCEPTOR_TYPE = "ExternalAuthenticator";
    private Map<String, ExternalAuthenticatorConfiguration> externalAuthenticatorConfigurations;
    private Map<AuthenticationScriptUsageType, List<ExternalAuthenticatorConfiguration>> externalAuthenticatorConfigurationsByUsageType;
    private Map<AuthenticationScriptUsageType, ExternalAuthenticatorConfiguration> defaultExternalAuthenticators;
    @Logger
    private Log log;
    @In
    private PythonService pythonService;
    @In
    private LdapCustomAuthenticationConfigurationService ldapCustomAuthenticationConfigurationService;
    private AtomicBoolean isActive;
    private long lastFinishedTime;

    @Observer(value={"org.jboss.seam.postInitialization"})
    public void init() {
        this.isActive = new AtomicBoolean(false);
        this.lastFinishedTime = System.currentTimeMillis();
        this.reload();
        Events.instance().raiseTimedEvent(EVENT_TYPE, (Schedule)new TimerSchedule(Long.valueOf(60000L), Long.valueOf(30000L)), new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Observer(value={"ExternalAuthenticationTimerEvent"})
    @Asynchronous
    public void reloadTimerEvent() {
        if (this.isActive.get()) {
            return;
        }
        if (!this.isActive.compareAndSet(false, true)) {
            return;
        }
        try {
            this.reload();
        }
        catch (Throwable ex) {
            this.log.error((Object)"Exception happened while reloading custom external authentication configuration", ex, new Object[0]);
        }
        finally {
            this.isActive.set(false);
            this.lastFinishedTime = System.currentTimeMillis();
        }
    }

    private void reload() {
        List<CustomAuthenticationConfiguration> currentCustomAuthenticationConfigurations = this.ldapCustomAuthenticationConfigurationService.getCustomAuthenticationConfigurations();
        this.reloadImpl(currentCustomAuthenticationConfigurations);
    }

    private void reloadImpl(List<CustomAuthenticationConfiguration> newCustomAuthenticationConfigurations) {
        this.externalAuthenticatorConfigurations = this.reloadExternalConfigurations(this.externalAuthenticatorConfigurations, newCustomAuthenticationConfigurations);
        this.externalAuthenticatorConfigurationsByUsageType = this.groupExternalAuthenticatorConfigurationsByUsageType(this.externalAuthenticatorConfigurations);
        this.defaultExternalAuthenticators = this.determineDefaultExternalAuthenticatorConfigurations(this.externalAuthenticatorConfigurations);
    }

    public Map<String, ExternalAuthenticatorConfiguration> reloadExternalConfigurations(Map<String, ExternalAuthenticatorConfiguration> externalAuthenticatorConfigurations, List<CustomAuthenticationConfiguration> newCustomAuthenticationConfigurations) {
        HashMap<Object, Object> newExternalAuthenticatorConfigurations = externalAuthenticatorConfigurations == null ? new HashMap() : new HashMap<String, ExternalAuthenticatorConfiguration>(externalAuthenticatorConfigurations);
        ArrayList<String> newSupportedNames = new ArrayList<String>();
        for (CustomAuthenticationConfiguration newCustomAuthenticationConfiguration : newCustomAuthenticationConfigurations) {
            if (!newCustomAuthenticationConfiguration.isEnabled()) continue;
            String newSupportedName = StringHelper.toLowerCase((String)newCustomAuthenticationConfiguration.getName());
            newSupportedNames.add(newSupportedName);
            ExternalAuthenticatorConfiguration prevExternalAuthenticatorConfiguration = (ExternalAuthenticatorConfiguration)newExternalAuthenticatorConfigurations.get(newSupportedName);
            if (prevExternalAuthenticatorConfiguration != null && prevExternalAuthenticatorConfiguration.getCustomAuthenticationConfiguration().getVersion() == newCustomAuthenticationConfiguration.getVersion()) continue;
            HashMap<String, SimpleCustomProperty> newConfigurationAttributes = new HashMap<String, SimpleCustomProperty>();
            for (SimpleCustomProperty simpleCustomProperty : newCustomAuthenticationConfiguration.getCustomAuthenticationAttributes()) {
                newConfigurationAttributes.put(simpleCustomProperty.getValue1(), simpleCustomProperty);
            }
            ExternalAuthenticatorType newExternalAuthenticatorType = this.createExternalAuthenticator(newCustomAuthenticationConfiguration, newConfigurationAttributes);
            ExternalAuthenticatorConfiguration newExternalAuthenticatorConfiguration = new ExternalAuthenticatorConfiguration(newCustomAuthenticationConfiguration, newExternalAuthenticatorType, newConfigurationAttributes);
            newExternalAuthenticatorConfigurations.put(newSupportedName, newExternalAuthenticatorConfiguration);
        }
        Iterator it = newExternalAuthenticatorConfigurations.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry externalAuthenticatorConfigurationEntry = it.next();
            String prevSupportedName = (String)externalAuthenticatorConfigurationEntry.getKey();
            if (newSupportedNames.contains(prevSupportedName)) continue;
            it.remove();
        }
        return newExternalAuthenticatorConfigurations;
    }

    public Map<AuthenticationScriptUsageType, List<ExternalAuthenticatorConfiguration>> groupExternalAuthenticatorConfigurationsByUsageType(Map<String, ExternalAuthenticatorConfiguration> externalAuthenticatorConfigurations) {
        HashMap<AuthenticationScriptUsageType, List<ExternalAuthenticatorConfiguration>> newExternalAuthenticatorConfigurationsByUsageType = new HashMap<AuthenticationScriptUsageType, List<ExternalAuthenticatorConfiguration>>();
        for (AuthenticationScriptUsageType usageType : AuthenticationScriptUsageType.values()) {
            ArrayList<ExternalAuthenticatorConfiguration> currExternalAuthenticatorConfigurationsByUsageType = new ArrayList<ExternalAuthenticatorConfiguration>();
            for (ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration : externalAuthenticatorConfigurations.values()) {
                if (!this.isValidateUsageType(usageType, externalAuthenticatorConfiguration)) continue;
                currExternalAuthenticatorConfigurationsByUsageType.add(externalAuthenticatorConfiguration);
            }
            newExternalAuthenticatorConfigurationsByUsageType.put(usageType, currExternalAuthenticatorConfigurationsByUsageType);
        }
        return newExternalAuthenticatorConfigurationsByUsageType;
    }

    public Map<AuthenticationScriptUsageType, ExternalAuthenticatorConfiguration> determineDefaultExternalAuthenticatorConfigurations(Map<String, ExternalAuthenticatorConfiguration> externalAuthenticatorConfigurations) {
        HashMap<AuthenticationScriptUsageType, ExternalAuthenticatorConfiguration> newDefaultExternalAuthenticatorConfigurations = new HashMap<AuthenticationScriptUsageType, ExternalAuthenticatorConfiguration>();
        for (AuthenticationScriptUsageType usageType : AuthenticationScriptUsageType.values()) {
            ExternalAuthenticatorConfiguration defaultExternalAuthenticator = null;
            for (ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration : this.externalAuthenticatorConfigurationsByUsageType.get(usageType)) {
                if (defaultExternalAuthenticator != null && defaultExternalAuthenticator.getLevel() < externalAuthenticatorConfiguration.getLevel() && (defaultExternalAuthenticator.getLevel() != externalAuthenticatorConfiguration.getLevel() || defaultExternalAuthenticator.getPriority() <= externalAuthenticatorConfiguration.getPriority())) continue;
                defaultExternalAuthenticator = externalAuthenticatorConfiguration;
            }
            newDefaultExternalAuthenticatorConfigurations.put(usageType, defaultExternalAuthenticator);
        }
        return newDefaultExternalAuthenticatorConfigurations;
    }

    public ExternalAuthenticatorType createExternalAuthenticator(CustomAuthenticationConfiguration customAuthenticationConfiguration, Map<String, SimpleCustomProperty> configurationAttributes) {
        ExternalAuthenticatorType externalAuthenticator;
        try {
            externalAuthenticator = this.createExternalAuthenticatorFromStringWithPythonException(customAuthenticationConfiguration, configurationAttributes);
        }
        catch (PythonException ex) {
            this.log.error((Object)"Failed to prepare external authenticator", (Throwable)ex, new Object[0]);
            return null;
        }
        if (externalAuthenticator == null) {
            this.log.debug((Object)"Using default external authenticator class", new Object[0]);
            externalAuthenticator = DUMMY_AUTHENTICATOR_TYPE;
        }
        return externalAuthenticator;
    }

    public boolean executeExternalAuthenticatorIsValidAuthenticationMethod(AuthenticationScriptUsageType usageType, ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'isValidAuthenticationMethod' authenticator method", new Object[0]);
            ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
            Map<String, SimpleCustomProperty> configurationAttributes = externalAuthenticatorConfiguration.getConfigurationAttributes();
            return externalAuthenticator.isValidAuthenticationMethod(usageType, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public String executeExternalAuthenticatorGetAlternativeAuthenticationMethod(AuthenticationScriptUsageType usageType, ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'getAlternativeAuthenticationMethod' authenticator method", new Object[0]);
            ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
            Map<String, SimpleCustomProperty> configurationAttributes = externalAuthenticatorConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getAlternativeAuthenticationMethod(usageType, configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return null;
        }
    }

    public int executeExternalAuthenticatorGetCountAuthenticationSteps(ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'getCountAuthenticationSteps' authenticator method", new Object[0]);
            ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
            Map<String, SimpleCustomProperty> configurationAttributes = externalAuthenticatorConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getCountAuthenticationSteps(configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return -1;
        }
    }

    public boolean executeExternalAuthenticatorAuthenticate(ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration, Map<String, String[]> requestParameters, int step) {
        try {
            this.log.debug((Object)"Executing python 'authenticate' authenticator method", new Object[0]);
            ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
            Map<String, SimpleCustomProperty> configurationAttributes = externalAuthenticatorConfiguration.getConfigurationAttributes();
            return externalAuthenticator.authenticate(configurationAttributes, requestParameters, step);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public boolean executeExternalAuthenticatorLogout(ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration, Map<String, String[]> requestParameters) {
        int apiVersion = this.executeExternalAuthenticatorGetApiVersion(externalAuthenticatorConfiguration);
        if (apiVersion > 2) {
            try {
                this.log.debug((Object)"Executing python 'logout' authenticator method", new Object[0]);
                ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
                Map<String, SimpleCustomProperty> configurationAttributes = externalAuthenticatorConfiguration.getConfigurationAttributes();
                return externalAuthenticator.logout(configurationAttributes, requestParameters);
            }
            catch (Exception ex) {
                this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
                return false;
            }
        }
        return true;
    }

    public boolean executeExternalAuthenticatorPrepareForStep(ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration, Map<String, String[]> requestParameters, int step) {
        try {
            this.log.debug((Object)"Executing python 'prepareForStep' authenticator method", new Object[0]);
            ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
            Map<String, SimpleCustomProperty> configurationAttributes = externalAuthenticatorConfiguration.getConfigurationAttributes();
            return externalAuthenticator.prepareForStep(configurationAttributes, requestParameters, step);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return false;
        }
    }

    public List<String> executeExternalAuthenticatorGetExtraParametersForStep(ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration, int step) {
        try {
            this.log.debug((Object)"Executing python 'getPageForStep' authenticator method", new Object[0]);
            ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
            Map<String, SimpleCustomProperty> configurationAttributes = externalAuthenticatorConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getExtraParametersForStep(configurationAttributes, step);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return null;
        }
    }

    public String executeExternalAuthenticatorGetPageForStep(ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration, int step) {
        try {
            this.log.debug((Object)"Executing python 'getPageForStep' authenticator method", new Object[0]);
            ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
            Map<String, SimpleCustomProperty> configurationAttributes = externalAuthenticatorConfiguration.getConfigurationAttributes();
            return externalAuthenticator.getPageForStep(configurationAttributes, step);
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return null;
        }
    }

    public int executeExternalAuthenticatorGetApiVersion(ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration) {
        try {
            this.log.debug((Object)"Executing python 'getApiVersion' authenticator method", new Object[0]);
            ExternalAuthenticatorType externalAuthenticator = externalAuthenticatorConfiguration.getExternalAuthenticatorType();
            return externalAuthenticator.getApiVersion();
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex, new Object[0]);
            return -1;
        }
    }

    public ExternalAuthenticatorType createExternalAuthenticatorFromFile() {
        ExternalAuthenticatorType externalAuthenticator;
        try {
            externalAuthenticator = this.createExternalAuthenticatorFromFileWithPythonException();
        }
        catch (PythonException ex) {
            this.log.error((Object)"Failed to prepare external authenticator", (Throwable)ex, new Object[0]);
            return null;
        }
        if (externalAuthenticator == null) {
            this.log.debug((Object)"Using default external authenticator class", new Object[0]);
            externalAuthenticator = DUMMY_AUTHENTICATOR_TYPE;
        }
        return externalAuthenticator;
    }

    public ExternalAuthenticatorType createExternalAuthenticatorFromFileWithPythonException() throws PythonException {
        String externalAuthenticatorScriptFileName = ConfigurationFactory.getConfiguration().getExternalAuthenticatorScriptFileName();
        if (StringHelper.isEmpty((String)externalAuthenticatorScriptFileName)) {
            return null;
        }
        String tomcatHome = System.getProperty("catalina.home");
        if (tomcatHome == null) {
            return null;
        }
        String fullPathToExternalAuthenticatorPythonScript = tomcatHome + File.separator + "conf" + File.separator + "python" + File.separator + externalAuthenticatorScriptFileName;
        ExternalAuthenticatorType externalAuthenticatorType = (ExternalAuthenticatorType)this.pythonService.loadPythonScript(fullPathToExternalAuthenticatorPythonScript, PYTHON_ENTRY_INTERCEPTOR_TYPE, ExternalAuthenticatorType.class, new PyObject[]{new PyLong(System.currentTimeMillis())});
        boolean initialized = externalAuthenticatorType.init(null);
        if (initialized) {
            return externalAuthenticatorType;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalAuthenticatorType createExternalAuthenticatorFromStringWithPythonException(CustomAuthenticationConfiguration customAuthenticationConfiguration, Map<String, SimpleCustomProperty> configurationAttributes) throws PythonException {
        String customAuthenticationScript = customAuthenticationConfiguration.getCustomAuthenticationScript();
        if (customAuthenticationScript == null) {
            return null;
        }
        ExternalAuthenticatorType externalAuthenticatorType = null;
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(customAuthenticationScript.getBytes("UTF-8"));
            externalAuthenticatorType = (ExternalAuthenticatorType)this.pythonService.loadPythonScript((InputStream)bis, PYTHON_ENTRY_INTERCEPTOR_TYPE, ExternalAuthenticatorType.class, new PyObject[]{new PyLong(System.currentTimeMillis())});
        }
        catch (UnsupportedEncodingException e) {
            try {
                this.log.error((Object)e.getMessage(), (Throwable)e, new Object[0]);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)bis);
        }
        IOUtils.closeQuietly((InputStream)bis);
        if (externalAuthenticatorType == null) {
            return null;
        }
        boolean initialized = false;
        try {
            initialized = externalAuthenticatorType.init(configurationAttributes);
        }
        catch (Exception ex) {
            this.log.error((Object)"Failed to initialize custom authenticator", (Throwable)ex, new Object[0]);
        }
        if (initialized) {
            return externalAuthenticatorType;
        }
        return null;
    }

    public boolean isEnabled(AuthenticationScriptUsageType usageType) {
        return this.externalAuthenticatorConfigurationsByUsageType.get(usageType).size() > 0;
    }

    public ExternalAuthenticatorConfiguration getExternalAuthenticatorByAuthLevel(AuthenticationScriptUsageType usageType, int authLevel) {
        ExternalAuthenticatorConfiguration resultDefaultExternalAuthenticator = null;
        for (ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration : this.externalAuthenticatorConfigurationsByUsageType.get(usageType)) {
            if (externalAuthenticatorConfiguration.getLevel() != authLevel || resultDefaultExternalAuthenticator != null && resultDefaultExternalAuthenticator.getPriority() <= externalAuthenticatorConfiguration.getPriority()) continue;
            resultDefaultExternalAuthenticator = externalAuthenticatorConfiguration;
        }
        return resultDefaultExternalAuthenticator;
    }

    public ExternalAuthenticatorConfiguration determineExternalAuthenticatorConfiguration(AuthenticationScriptUsageType usageType, int authStep, String authLevel, String authMode) {
        ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration = null;
        externalAuthenticatorConfiguration = authStep == 1 ? (StringHelper.isNotEmpty((String)authMode) ? this.getExternalAuthenticatorConfiguration(usageType, authMode) : (StringHelper.isNotEmpty((String)authLevel) ? this.getExternalAuthenticatorByAuthLevel(usageType, StringHelper.toInteger((String)authLevel)) : this.getDefaultExternalAuthenticator(usageType))) : this.getExternalAuthenticatorConfiguration(usageType, authMode);
        return externalAuthenticatorConfiguration;
    }

    public ExternalAuthenticatorConfiguration determineExternalAuthenticatorConfiguration(AuthenticationScriptUsageType usageType, List<String> amrValues) {
        List<String> authModes = this.getAuthModesByAmrValues(amrValues);
        if (authModes.size() > 0) {
            for (String authMode : authModes) {
                for (ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration : this.externalAuthenticatorConfigurationsByUsageType.get(usageType)) {
                    if (!StringHelper.equalsIgnoreCase((String)authMode, (String)externalAuthenticatorConfiguration.getName())) continue;
                    return externalAuthenticatorConfiguration;
                }
            }
        }
        return null;
    }

    private List<String> getAuthModesByAmrValues(List<String> amrValues) {
        ArrayList<String> authModes = new ArrayList<String>();
        for (String amrValue : amrValues) {
            String authMode;
            if (!StringHelper.isNotEmpty((String)amrValue) || !StringHelper.toLowerCase((String)amrValue).startsWith(AMR_METHOD_PREFIX) || !this.externalAuthenticatorConfigurations.containsKey(StringHelper.toLowerCase((String)(authMode = amrValue.substring(AMR_METHOD_PREFIX.length()))))) continue;
            authModes.add(authMode);
        }
        return authModes;
    }

    public ExternalAuthenticatorConfiguration determineExternalAuthenticatorForWorkflow(AuthenticationScriptUsageType usageType, ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration) {
        int apiVersion = this.executeExternalAuthenticatorGetApiVersion(externalAuthenticatorConfiguration);
        if (apiVersion > 2) {
            String authMode = externalAuthenticatorConfiguration.getName();
            this.log.debug((Object)"Validating auth_mode: '{0}'", new Object[]{authMode});
            boolean isValidAuthenticationMethod = this.executeExternalAuthenticatorIsValidAuthenticationMethod(usageType, externalAuthenticatorConfiguration);
            if (!isValidAuthenticationMethod) {
                this.log.warn((Object)"Current auth_mode: '{0}' isn't valid", new Object[]{authMode});
                String alternativeAuthenticationMethod = this.executeExternalAuthenticatorGetAlternativeAuthenticationMethod(usageType, externalAuthenticatorConfiguration);
                if (StringHelper.isEmpty((String)alternativeAuthenticationMethod)) {
                    this.log.error((Object)"Failed to determine alternative authentication mode for auth_mode: '{0}'", new Object[]{authMode});
                    return null;
                }
                ExternalAuthenticatorConfiguration alternativeExternalAuthenticatorConfiguration = this.getExternalAuthenticatorConfiguration(AuthenticationScriptUsageType.INTERACTIVE, alternativeAuthenticationMethod);
                if (alternativeExternalAuthenticatorConfiguration == null) {
                    this.log.error((Object)"Failed to get alternative ExternalAuthenticatorConfiguration '{0}' for auth_mode: '{1}'", new Object[]{alternativeAuthenticationMethod, authMode});
                    return null;
                }
                return alternativeExternalAuthenticatorConfiguration;
            }
        }
        return externalAuthenticatorConfiguration;
    }

    public ExternalAuthenticatorConfiguration getDefaultExternalAuthenticator(AuthenticationScriptUsageType usageType) {
        return this.defaultExternalAuthenticators.get(usageType);
    }

    public ExternalAuthenticatorConfiguration getExternalAuthenticatorConfiguration(AuthenticationScriptUsageType usageType, String name) {
        for (ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration : this.externalAuthenticatorConfigurationsByUsageType.get(usageType)) {
            if (!StringHelper.equalsIgnoreCase((String)name, (String)externalAuthenticatorConfiguration.getName())) continue;
            return externalAuthenticatorConfiguration;
        }
        return null;
    }

    public ExternalAuthenticatorConfiguration getExternalAuthenticatorConfiguration(String name) {
        for (Map.Entry<String, ExternalAuthenticatorConfiguration> externalAuthenticatorConfigurationEntry : this.externalAuthenticatorConfigurations.entrySet()) {
            if (!StringHelper.equalsIgnoreCase((String)name, (String)externalAuthenticatorConfigurationEntry.getKey())) continue;
            return externalAuthenticatorConfigurationEntry.getValue();
        }
        return null;
    }

    public List<ExternalAuthenticatorConfiguration> getExternalAuthenticatorConfigurations() {
        return new ArrayList<ExternalAuthenticatorConfiguration>(this.externalAuthenticatorConfigurations.values());
    }

    public List<String> getAmrValuesList() {
        ArrayList<String> amrValues = new ArrayList<String>();
        for (Map.Entry<String, ExternalAuthenticatorConfiguration> externalAuthenticatorConfigurationEntry : this.externalAuthenticatorConfigurations.entrySet()) {
            String amrValue = AMR_METHOD_PREFIX + externalAuthenticatorConfigurationEntry.getKey();
            amrValues.add(amrValue);
        }
        return amrValues;
    }

    private boolean isValidateUsageType(AuthenticationScriptUsageType usageType, ExternalAuthenticatorConfiguration externalAuthenticatorConfiguration) {
        if (externalAuthenticatorConfiguration == null) {
            return false;
        }
        AuthenticationScriptUsageType externalAuthenticatorUsageType = externalAuthenticatorConfiguration.getCustomAuthenticationConfiguration().getUsageType();
        if (externalAuthenticatorUsageType == null) {
            externalAuthenticatorUsageType = AuthenticationScriptUsageType.INTERACTIVE;
        }
        if (AuthenticationScriptUsageType.BOTH.equals((Object)externalAuthenticatorUsageType)) {
            return true;
        }
        if (AuthenticationScriptUsageType.INTERACTIVE.equals((Object)usageType) && AuthenticationScriptUsageType.INTERACTIVE.equals((Object)externalAuthenticatorUsageType)) {
            return true;
        }
        if (AuthenticationScriptUsageType.SERVICE.equals((Object)usageType) && AuthenticationScriptUsageType.SERVICE.equals((Object)externalAuthenticatorUsageType)) {
            return true;
        }
        return AuthenticationScriptUsageType.LOGOUT.equals((Object)usageType) && AuthenticationScriptUsageType.LOGOUT.equals((Object)externalAuthenticatorUsageType);
    }

    public static ExternalAuthenticationService instance() {
        return (ExternalAuthenticationService)Component.getInstance(ExternalAuthenticationService.class);
    }
}

