/*
 * Decompiled with CFR 0.152.
 */
package org.xdi.oxauth.model.error;

import java.util.List;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.AutoCreate;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.log.Log;
import org.xdi.oxauth.model.authorize.AuthorizeErrorResponseType;
import org.xdi.oxauth.model.clientinfo.ClientInfoErrorResponseType;
import org.xdi.oxauth.model.error.DefaultErrorResponse;
import org.xdi.oxauth.model.error.ErrorMessage;
import org.xdi.oxauth.model.error.ErrorMessages;
import org.xdi.oxauth.model.error.IErrorType;
import org.xdi.oxauth.model.federation.FederationErrorResponseType;
import org.xdi.oxauth.model.register.RegisterErrorResponseType;
import org.xdi.oxauth.model.session.EndSessionErrorResponseType;
import org.xdi.oxauth.model.token.TokenErrorResponseType;
import org.xdi.oxauth.model.token.ValidateTokenErrorResponseType;
import org.xdi.oxauth.model.uma.UmaErrorResponse;
import org.xdi.oxauth.model.uma.UmaErrorResponseType;
import org.xdi.oxauth.model.userinfo.UserInfoErrorResponseType;
import org.xdi.util.StringHelper;

@Name(value="errorResponseFactory")
@AutoCreate
@Scope(value=ScopeType.APPLICATION)
public class ErrorResponseFactory {
    @Logger
    private Log log;
    private volatile ErrorMessages messages;

    public ErrorMessages getMessages() {
        return this.messages;
    }

    public void setMessages(ErrorMessages p_messages) {
        this.messages = p_messages;
    }

    private ErrorMessage getError(List<ErrorMessage> p_list, IErrorType type) {
        this.log.debug((Object)"Looking for the error with id: {0}", new Object[]{type});
        if (p_list != null) {
            for (ErrorMessage error : p_list) {
                if (!error.getId().equals(type.getParameter())) continue;
                this.log.debug((Object)"Found error, id: {0}", new Object[]{type});
                return error;
            }
        }
        this.log.debug((Object)"Error not found, id: {0}", new Object[]{type});
        return null;
    }

    public String getErrorAsJson(IErrorType p_type) {
        return this.getErrorResponse(p_type).toJSonString();
    }

    public String getErrorAsJson(IErrorType p_type, String p_state) {
        return this.getErrorResponse(p_type, p_state).toJSonString();
    }

    public String getErrorAsQueryString(IErrorType p_type, String p_state) {
        return this.getErrorResponse(p_type, p_state).toQueryString();
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type, String p_state) {
        DefaultErrorResponse response = this.getErrorResponse(type);
        response.setState(p_state);
        return response;
    }

    public DefaultErrorResponse getErrorResponse(IErrorType type) {
        DefaultErrorResponse response = new DefaultErrorResponse();
        response.setType(type);
        if (type != null && this.messages != null) {
            List<ErrorMessage> list = null;
            if (type instanceof AuthorizeErrorResponseType) {
                list = this.messages.getAuthorize();
            } else if (type instanceof FederationErrorResponseType) {
                list = this.messages.getFederation();
            } else if (type instanceof ClientInfoErrorResponseType) {
                list = this.messages.getClientInfo();
            } else if (type instanceof EndSessionErrorResponseType) {
                list = this.messages.getEndSession();
            } else if (type instanceof RegisterErrorResponseType) {
                list = this.messages.getRegister();
            } else if (type instanceof TokenErrorResponseType) {
                list = this.messages.getToken();
            } else if (type instanceof UmaErrorResponseType) {
                list = this.messages.getUma();
            } else if (type instanceof UserInfoErrorResponseType) {
                list = this.messages.getUserInfo();
            } else if (type instanceof ValidateTokenErrorResponseType) {
                list = this.messages.getValidateToken();
            }
            if (list != null) {
                ErrorMessage m = this.getError(list, type);
                response.setErrorDescription(m.getDescription());
                response.setErrorUri(m.getUri());
            }
        }
        return response;
    }

    public UmaErrorResponse getUmaErrorResponse(IErrorType type) {
        UmaErrorResponse response = new UmaErrorResponse();
        ErrorMessage errorMessage = this.getError(this.messages.getUma(), type);
        response.setError(errorMessage.getId());
        response.setErrorDescription(errorMessage.getDescription());
        response.setErrorUri(errorMessage.getUri());
        return response;
    }

    public String getUmaJsonErrorResponse(IErrorType type) {
        UmaErrorResponse response = this.getUmaErrorResponse(type);
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("error", (Object)response.getError());
            if (StringHelper.isNotEmpty((String)response.getStatus())) {
                jsonObj.put("status", (Object)response.getStatus());
            }
            if (StringHelper.isNotEmpty((String)response.getErrorDescription())) {
                jsonObj.put("error_description", (Object)response.getErrorDescription());
            }
            if (StringHelper.isNotEmpty((String)response.getErrorUri())) {
                jsonObj.put("error_uri", (Object)response.getErrorUri());
            }
        }
        catch (JSONException ex) {
            this.log.error((Object)"Failed to generate error response", (Throwable)ex, new Object[0]);
            return null;
        }
        return jsonObj.toString();
    }
}

